/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.crop;

import ic2.api.classic.crops.ClassicCrops;
import ic2.api.crops.BaseSeed;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropSeed;
import ic2.core.IC2;
import ic2.core.block.crop.Ic2Crops;
import ic2.core.block.crop.TileEntityCrop;
import ic2.core.item.base.ItemIC2;
import ic2.core.item.render.model.CropSeedModel;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.textures.models.BaseModel;
import ic2.core.platform.textures.obj.IAdvancedTexturedItem;
import ic2.core.platform.textures.obj.ICustomModeledItem;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCropSeed
extends ItemIC2
implements ICropSeed,
IAdvancedTexturedItem,
ICustomModeledItem {
    Map<CropCard, ModelResourceLocation> cards = new HashMap<CropCard, ModelResourceLocation>();

    public ItemCropSeed() {
        this.func_77627_a(true);
        this.setTranslationKey(Ic2ItemLang.cropSeed);
        this.func_77625_d(1);
    }

    @Override
    public List<ItemStack> getValidItemTypes() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ResourceLocation entry : ClassicCrops.instance.getDisplayItems().keySet()) {
            ItemStack result = new ItemStack((Item)this);
            StackUtil.getOrCreateNbtData(result).func_74778_a("CropID", entry.toString());
            list.add(result);
        }
        return list;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BaseModel getModelFromItem(ItemStack item) {
        return new CropSeedModel(ClassicCrops.instance.getDisplayItems().get(new ResourceLocation(StackUtil.getNbtData(item).func_74779_i("CropID"))));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation createResourceLocationForStack(ItemStack stack) {
        ModelResourceLocation model = this.createResource(stack);
        this.cards.put(this.getCard(stack), model);
        return model;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelResourceLocation getResourceLocationForStack(ItemStack stack) {
        ModelResourceLocation model;
        if (GuiScreen.func_146271_m()) {
            ModelResourceLocation model2;
            if (this.getScannedFromStack(stack) > 0 && (model2 = this.cards.get(this.getCard(stack))) != null) {
                return model2;
            }
        } else if (ItemCropSeed.shouldBeVisible(stack) && (model = this.cards.get(this.getCard(stack))) != null) {
            return model;
        }
        return this.cards.get(null);
    }

    @SideOnly(value=Side.CLIENT)
    private ModelResourceLocation createResource(ItemStack stack) {
        String name = stack.func_77977_a();
        ResourceLocation resource = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)this);
        CropCard card = this.getCard(stack);
        if (card != null) {
            ResourceLocation cropID = new ResourceLocation(card.getOwner(), card.getId());
            return new ModelResourceLocation(resource.func_110624_b() + name.substring(name.indexOf(".") + 1) + cropID.toString(), "inventory");
        }
        return new ModelResourceLocation(resource.func_110624_b() + name.substring(name.indexOf(".") + 1), "inventory");
    }

    private CropCard getCard(ItemStack stack) {
        if (stack == null || !stack.func_77942_o()) {
            return null;
        }
        return ClassicCrops.instance.getCropCard(new ResourceLocation(StackUtil.getOrCreateNbtData(stack).func_74779_i("CropID")));
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.getScannedFromStack(stack) >= 4 ? 64 : 1;
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @Override
    public int getTextureEntry(int meta) {
        return 87;
    }

    @Override
    public String getSheet(int meta) {
        return "i0";
    }

    public int getMetadata(ItemStack stack) {
        return 0;
    }

    public boolean func_77645_m() {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.getScannedFromStack(stack) >= 4) {
            tooltip.add(TextFormatting.DARK_GREEN + Ic2GuiLang.cropGrowth.getLocalized() + TextFormatting.RESET + this.getGrowthFromStack(stack));
            tooltip.add(TextFormatting.GOLD + Ic2GuiLang.cropGain.getLocalized() + TextFormatting.RESET + this.getGainFromStack(stack));
            tooltip.add(TextFormatting.DARK_AQUA + Ic2GuiLang.cropResistance.getLocalized() + TextFormatting.RESET + this.getResistanceFromStack(stack));
        }
        if (!GuiScreen.func_146271_m() && !ItemCropSeed.shouldBeVisible(stack)) {
            tooltip.add(Ic2InfoLang.cropButton.getLocalized());
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (!(tile instanceof TileEntityCrop)) {
            return EnumActionResult.PASS;
        }
        TileEntityCrop crop = (TileEntityCrop)tile;
        ItemStack stack = player.func_184586_b(hand);
        if (crop.tryPlantSeed(this.getSeedFromStack(stack), this.getScannedFromStack(stack))) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return IC2.platform.isRendering() ? EnumActionResult.PASS : EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (CropCard card : Crops.instance.getCrops()) {
            if (card == Crops.weed) continue;
            items.add((Object)ItemCropSeed.generateItemStack(card, 1, 1, 1, 4));
        }
    }

    public static ItemStack generateItemStack(CropCard card, int growth, int gain, int resistance, int scan) {
        ItemStack stack = new ItemStack(Ic2Items.cropSeed.func_77973_b());
        NBTTagCompound data = StackUtil.getOrCreateNbtData(stack);
        data.func_74778_a("CropID", new ResourceLocation(card.getOwner(), card.getId()).toString());
        data.func_74768_a("Growth", growth);
        data.func_74768_a("Gain", gain);
        data.func_74768_a("Resistance", resistance);
        data.func_74768_a("Scan", scan);
        return stack;
    }

    private BaseSeed getSeedFromStack(ItemStack stack) {
        return new BaseSeed(this.getCropFromStack(stack), 1, this.getGrowthFromStack(stack), this.getGainFromStack(stack), this.getResistanceFromStack(stack), 1);
    }

    @Override
    public CropCard getCropFromStack(ItemStack itemStack) {
        return ClassicCrops.instance.getCropCard(new ResourceLocation(StackUtil.getOrCreateNbtData(itemStack).func_74779_i("CropID")));
    }

    @Override
    public void setCropFromStack(ItemStack itemStack, CropCard crop) {
        StackUtil.getOrCreateNbtData(itemStack).func_74778_a("CropID", new ResourceLocation(crop.getOwner(), crop.getId()).toString());
    }

    @Override
    public int getGrowthFromStack(ItemStack itemStack) {
        return StackUtil.getNbtData(itemStack).func_74762_e("Growth");
    }

    @Override
    public void setGrowthFromStack(ItemStack itemStack, int value) {
        StackUtil.getOrCreateNbtData(itemStack).func_74768_a("Growth", value);
    }

    @Override
    public int getGainFromStack(ItemStack itemStack) {
        return StackUtil.getNbtData(itemStack).func_74762_e("Gain");
    }

    @Override
    public void setGainFromStack(ItemStack itemStack, int value) {
        StackUtil.getOrCreateNbtData(itemStack).func_74768_a("Gain", value);
    }

    @Override
    public int getResistanceFromStack(ItemStack itemStack) {
        return StackUtil.getNbtData(itemStack).func_74762_e("Resistance");
    }

    @Override
    public void setResistanceFromStack(ItemStack itemStack, int value) {
        StackUtil.getOrCreateNbtData(itemStack).func_74768_a("Resistance", value);
    }

    @Override
    public int getScannedFromStack(ItemStack itemStack) {
        return StackUtil.getNbtData(itemStack).func_74762_e("Scan");
    }

    @Override
    public void setScannedFromStack(ItemStack itemStack, int value) {
        StackUtil.getOrCreateNbtData(itemStack).func_74768_a("Scan", value);
    }

    @Override
    public void incrementScannedFromStack(ItemStack itemStack) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(itemStack);
        nbt.func_74768_a("Scan", nbt.func_74762_e("Scan") + 1);
    }

    public static boolean shouldBeVisible(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74767_n("Visible");
    }

    public static void setVisible(ItemStack stack) {
        StackUtil.getOrCreateNbtData(stack).func_74757_a("Visible", true);
    }

    @Override
    public LocaleComp getLangComponent(ItemStack stack) {
        CropCard id = this.getCropFromStack(stack);
        int scan = this.getScannedFromStack(stack);
        if (scan < 0) {
            return Ic2ItemLang.cropSeedInvalid;
        }
        if (scan == 0) {
            return Ic2ItemLang.cropSeedUnknown;
        }
        if (id != null) {
            return Ic2ItemLang.cropSeedItem;
        }
        return super.getLangComponent(stack);
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        return this.getLangComponent(stack).getLocalizedFormatted(Ic2Crops.instance.getCropName(stack));
    }

    @SideOnly(value=Side.CLIENT)
    public static ItemStack getDisplayItem(ItemStack base) {
        if (!GuiScreen.func_146271_m() && !ItemCropSeed.shouldBeVisible(base) || !(base.func_77973_b() instanceof ItemCropSeed)) {
            return ItemStack.field_190927_a;
        }
        ItemCropSeed item = (ItemCropSeed)base.func_77973_b();
        if (item.getScannedFromStack(base) < 4 && !ItemCropSeed.shouldBeVisible(base)) {
            return ItemStack.field_190927_a;
        }
        CropCard crop = item.getCard(base);
        return crop == null ? ItemStack.field_190927_a : ClassicCrops.instance.getDisplayItem(crop);
    }
}

