/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor.electric;

import ic2.api.classic.item.IDamagelessElectricItem;
import ic2.api.item.ElectricItem;
import ic2.core.IC2;
import ic2.core.item.armor.base.ItemIC2AdvArmorBase;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemArmorNightVisionGoggles
extends ItemIC2AdvArmorBase
implements IDamagelessElectricItem {
    public ItemArmorNightVisionGoggles() {
        super(34, EntityEquipmentSlot.HEAD);
        this.setTranslationKey(Ic2ItemLang.nightVisionGoggle);
        this.func_77656_e(0);
    }

    @Override
    public String getTexture() {
        return "ic2:textures/models/armor/nightvision";
    }

    @Override
    public ItemStack getRepairItem() {
        return null;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        ItemStack empty = new ItemStack((Item)this);
        ItemStack full = new ItemStack((Item)this);
        ElectricItem.manager.discharge(empty, 2.147483647E9, Integer.MAX_VALUE, true, false, false);
        ElectricItem.manager.charge(full, 2.147483647E9, Integer.MAX_VALUE, true, false);
        subItems.add((Object)empty);
        subItems.add((Object)full);
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxCharge(ItemStack stack) {
        return 20000.0;
    }

    @Override
    public int getTier(ItemStack stack) {
        return 1;
    }

    @Override
    public double getTransferLimit(ItemStack stack) {
        return 200.0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        sortedTooltip.get((Object)ToolTipType.Ctrl).add(TextFormatting.UNDERLINE + Ic2Lang.pressTo.getLocalizedFormatted(IC2.keyboard.getKeyName(4), Ic2InfoLang.nightVisionHudKey));
        sortedTooltip.get((Object)ToolTipType.Shift).add(Ic2InfoLang.nightVisionSeeInTheDark.getLocalized());
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (world.field_72995_K) {
            return;
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(itemStack);
        int ticker = nbt.func_74762_e("Ticker");
        if (ticker > 0) {
            --ticker;
        }
        boolean enabled = nbt.func_74767_n("Enabled");
        if (ticker <= 0 && IC2.keyboard.isHudModeKeyDown(player)) {
            ticker = 20;
            enabled = !enabled;
            nbt.func_74757_a("Enabled", enabled);
            IC2.platform.messagePlayer(player, enabled ? Ic2InfoLang.nightVisionEnabled : Ic2InfoLang.nightVisionDisabled);
        }
        if (enabled && ElectricItem.manager.use(itemStack, 1.0, (EntityLivingBase)player)) {
            IC2.platform.removePotion((EntityLivingBase)player, MobEffects.field_76440_q);
            player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 250, 0, true, false));
        }
        nbt.func_74768_a("Ticker", ticker);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ElectricItem.manager.getCharge(stack) / this.getMaxCharge(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }
}

