/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor.electric;

import ic2.api.classic.item.ICropAnalyzer;
import ic2.api.classic.item.IEUReader;
import ic2.api.classic.item.IThermometer;
import ic2.api.item.ElectricItem;
import ic2.api.item.IMetalArmor;
import ic2.core.IC2;
import ic2.core.item.armor.base.ItemElectricArmorBase;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ISpecialArmor;

public class ItemArmorNanoSuit
extends ItemElectricArmorBase
implements IMetalArmor,
IEUReader,
IThermometer,
ICropAnalyzer {
    public ItemArmorNanoSuit(int index, EntityEquipmentSlot equipmentSlotIn) {
        super(index, equipmentSlotIn, 100000, 160, 2);
    }

    @Override
    public boolean isCropAnalyzer(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74767_n("CropUpgrade");
    }

    @Override
    public boolean isThermometer(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74767_n("ThermometerUpgrade");
    }

    @Override
    public boolean isEUReader(ItemStack stack) {
        return StackUtil.getNbtData(stack).func_74767_n("EUReaderUpgrade");
    }

    @Override
    public double getDamageAbsorptionRatio() {
        return 0.9;
    }

    @Override
    public int getEnergyPerDamage() {
        return 800;
    }

    @Override
    public String getTexture() {
        return "ic2:textures/models/armor/nano";
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (source == DamageSource.field_76379_h && this.field_77881_a == EntityEquipmentSlot.FEET) {
            int energyPerDamage = this.getEnergyPerDamage();
            int damageLimit = (int)(energyPerDamage > 0 ? ElectricItem.manager.discharge(armor, 2.147483647E9, Integer.MAX_VALUE, true, false, true) / (double)energyPerDamage : 0.0);
            float absorbtion = damage < 8.0 ? 1.0f : 0.875f;
            return new ISpecialArmor.ArmorProperties(10, (double)(absorbtion *= IC2.config.getFloat("electricSuitAbsorbtionScale")), damageLimit);
        }
        return super.getProperties(player, armor, source, damage, slot);
    }

    @Override
    public void damageAbsorbed(EntityPlayer player, int damage) {
        IC2.achievements.issueStat(player, "nanoArmorDamageTaken", damage);
    }

    @Override
    public boolean isMetalArmor(ItemStack itemstack, EntityPlayer player) {
        return true;
    }

    @Override
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        List<String> s = sortedTooltip.get((Object)ToolTipType.Shift);
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        if (nbt.func_74764_b("EUReaderUpgrade")) {
            s.add(Ic2Lang.upgradeEU.getLocalized());
        }
        if (nbt.func_74764_b("CropUpgrade")) {
            s.add(Ic2Lang.upgradeCrop.getLocalized());
        }
        if (nbt.func_74764_b("ThermometerUpgrade")) {
            s.add(Ic2Lang.upgradeThermo.getLocalized());
        }
    }
}

