/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.armor.electric;

import ic2.core.item.armor.base.ItemArmorElectricJetpackBase;
import ic2.core.item.armor.base.ItemArmorJetpackBase;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;

public class ItemArmorCompactedElectricJetpack
extends ItemArmorElectricJetpackBase {
    public ItemArmorCompactedElectricJetpack(int index) {
        super(index, EntityEquipmentSlot.CHEST);
        this.setTranslationKey(Ic2ItemLang.jetpackCompactElectric);
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxCharge(ItemStack stack) {
        return 360000.0;
    }

    @Override
    public boolean canDisable(ItemStack stack) {
        return true;
    }

    @Override
    public int getTier(ItemStack stack) {
        return 2;
    }

    @Override
    public double getTransferLimit(ItemStack stack) {
        return 500.0;
    }

    @Override
    public boolean canDoRocketMode(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canDoAdvHoverMode(ItemStack stack) {
        return true;
    }

    @Override
    public boolean isElectricJetpack(ItemStack stack) {
        return true;
    }

    @Override
    public float getPower(ItemStack stack) {
        return 1.4f;
    }

    @Override
    public float getThruster(ItemStack stack, ItemArmorJetpackBase.HoverMode mode) {
        switch (mode) {
            case Adv: {
                return 1.8f;
            }
            case Basic: {
                return 1.2f;
            }
            case None: {
                return 0.6f;
            }
        }
        return 0.6f;
    }

    @Override
    public float getDropPercentage(ItemStack stack) {
        return 0.05f;
    }

    @Override
    public int getMaxHeight(ItemStack stack, int worldHeight) {
        return (int)((float)worldHeight / 1.1f);
    }

    @Override
    public int getMaxRocketCharge(ItemStack stack) {
        return 25000;
    }

    @Override
    public int getFuelCost(ItemStack stack, ItemArmorJetpackBase.HoverMode mode) {
        switch (mode) {
            case None: {
                return 15;
            }
            case Basic: {
                return 12;
            }
            case Adv: {
                return 15;
            }
        }
        return 15;
    }

    @Override
    public String getTexture() {
        return "ic2:textures/models/armor/jetpack_Combined_Electric";
    }
}

