/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring.tile;

import ic2.api.classic.energy.tile.IAnchorConductor;
import ic2.api.classic.energy.tile.IEnergyConductorColored;
import ic2.api.classic.energy.tile.IInsulationModifieableConductor;
import ic2.api.classic.event.RetextureEventClassic;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.util.IWorldTickCallback;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IColoredEnergyTile;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.energy.tile.IMetaDelegate;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.block.base.util.info.CableColorInfo;
import ic2.core.block.base.util.info.CableLossInfo;
import ic2.core.block.base.util.info.CableMaxEnergyInfo;
import ic2.core.block.base.util.texture.ICopyEntry;
import ic2.core.block.base.util.texture.TextureCopyStorage;
import ic2.core.block.wiring.BlockCable;
import ic2.core.block.wiring.cables.CableContainer;
import ic2.core.block.wiring.cables.IWireInformation;
import ic2.core.block.wiring.cables.WireRegistry;
import ic2.core.block.wiring.tile.TileEntityLuminator;
import ic2.core.block.wiring.tile.TileEntityMultipartLuminator;
import ic2.core.energy.EnergyNetLocal;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.obj.IItemContainer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityCable
extends TileEntityBlock
implements IEnergyConductorColored,
IInsulationModifieableConductor,
INetworkTileEntityEventListener,
IColoredEnergyTile,
IItemContainer,
IAnchorConductor {
    @NetworkField(index=3, compression=NetworkField.BitLevel.Bit8, override=true)
    public int cableType = 0;
    @NetworkField(index=4)
    public IEnergyConductorColored.WireColor cableColor = IEnergyConductorColored.WireColor.Blank;
    @NetworkField(index=5)
    public byte foamed = 0;
    @NetworkField(index=6)
    public TextureCopyStorage storage = new TextureCopyStorage(6);
    @NetworkField(index=7, compression=NetworkField.BitLevel.Bit8)
    public int insulation = 0;
    protected boolean addedToEnergyNet;
    @NetworkField(index=8)
    public RotationList connection = RotationList.EMPTY;
    @NetworkField(index=9)
    public RotationList anchors = RotationList.EMPTY;
    public static WireRegistry registry = WireRegistry.instance;

    public TileEntityCable() {
        this.addNetworkFields("cableType", "cableColor", "foamed", "connection", "anchors", "insulation", "storage");
        this.addInfos(new CableLossInfo(this), new CableMaxEnergyInfo(this), new CableColorInfo(this));
    }

    public TileEntityCable(int type) {
        this.cableType = type;
        this.addNetworkFields("cableType", "cableColor", "foamed", "connection", "anchors", "insulation", "storage");
        this.addInfos(new CableLossInfo(this), new CableMaxEnergyInfo(this), new CableColorInfo(this));
    }

    public TileEntityCable(CableContainer container) {
        this.cableType = container.getType();
        this.insulation = container.getInsulation();
        this.addNetworkFields("cableType", "cableColor", "foamed", "connection", "anchors", "insulation", "storage");
        this.addInfos(new CableLossInfo(this), new CableMaxEnergyInfo(this), new CableColorInfo(this));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.cableType = nbt.func_74762_e("CableType");
        this.cableColor = IEnergyConductorColored.WireColor.values()[nbt.func_74762_e("WireColor")];
        byte newFoamed = nbt.func_74771_c("Foaming");
        this.insulation = nbt.func_74762_e("Insulation");
        this.connection = RotationList.ofNumber(nbt.func_74771_c("Connection"));
        this.anchors = RotationList.ofNumber(nbt.func_74771_c("Anchors"));
        if (newFoamed == 1) {
            this.changeFoam(newFoamed, true);
        } else {
            this.foamed = newFoamed;
        }
        this.storage.readFromNBT(nbt.func_74775_l("Storage"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("CableType", this.cableType);
        nbt.func_74768_a("WireColor", this.cableColor.ordinal());
        nbt.func_74774_a("Foaming", this.foamed);
        nbt.func_74768_a("Insulation", this.insulation);
        nbt.func_74774_a("Connection", (byte)this.connection.getCode());
        nbt.func_74774_a("Anchors", (byte)this.anchors.getCode());
        this.storage.writeToNBT(this.getTag(nbt, "Storage"));
        return nbt;
    }

    public Vec3i getConnections() {
        return new Vec3i(this.connection.getCode(), this.anchors.getCode(), this.connection.getCode() << 6 | this.anchors.getCode());
    }

    @Override
    public boolean addAnchor(EnumFacing side) {
        if (this.anchors.contains(side)) {
            return false;
        }
        if (this.isRendering()) {
            return true;
        }
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        this.addedToEnergyNet = false;
        this.anchors = this.anchors.add(side);
        this.getNetwork().updateTileEntityField(this, "anchors");
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        this.addedToEnergyNet = true;
        return true;
    }

    @Override
    public boolean removeAnchor(EnumFacing side) {
        if (this.anchors.notContains(side)) {
            return false;
        }
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        this.addedToEnergyNet = false;
        this.anchors = this.anchors.remove(side);
        this.getNetwork().updateTileEntityField(this, "anchors");
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        this.addedToEnergyNet = true;
        return true;
    }

    @Override
    public boolean hasAnchor(EnumFacing side) {
        return this.anchors.contains(side);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.addedToEnergyNet && this.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (this.addedToEnergyNet && this.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public void onNetworkUpdate(String field) {
        if (field.equals("storage") || field.equals("anchors") || field.equals("insulation") || field.equals("cableType") || field.equals("cableColor") || field.equals("foamed") || field.equals("connection")) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public void onNetworkEvent(int event) {
        switch (event) {
            case 0: {
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.8f);
                for (int l = 0; l < 8; ++l) {
                    this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)this.func_174877_v().func_177958_n() + Math.random(), (double)this.func_174877_v().func_177956_o() + 1.2, (double)this.func_174877_v().func_177952_p() + Math.random(), 0.0, 0.0, 0.0, new int[0]);
                }
                break;
            }
            default: {
                IC2.platform.displayError("An unknown event type was received over multiplayer.\nThis could happen due to corrupted data or a bug.\n\n(Technical information: event ID " + event + ", tile entity below)\nT: " + this + " (" + this.func_174877_v() + ")");
            }
        }
    }

    public boolean changeColor(IEnergyConductorColored.WireColor newColor, EnumFacing side) {
        if (this.foamed == 0 && (!registry.getInfoFromType(this.cableType).canColorWithoutInsulation() && this.insulation <= 0 || !registry.getInfoFromType(this.cableType).canColorWithoutInsulation() && registry.getInfoFromType(this.cableType).getMaxInsulationTypes() <= 0 || this.cableColor == newColor)) {
            return false;
        }
        if (this.foamed > 1 && (side == null ? !this.storage.canApply(newColor) : this.storage.getColor(side) == newColor)) {
            return false;
        }
        if (this.isSimulating()) {
            if (this.foamed == 0) {
                if (this.addedToEnergyNet) {
                    MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
                }
                this.addedToEnergyNet = false;
                this.cableColor = newColor;
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
                this.addedToEnergyNet = true;
                this.getNetwork().updateTileEntityField(this, "cableColor");
            } else if (this.foamed == 2) {
                if (side == null) {
                    this.storage.setAll(newColor);
                } else {
                    this.storage.set(side.func_176745_a(), newColor);
                }
                this.getNetwork().updateTileEntityField(this, "storage");
            }
        }
        return true;
    }

    public void setInsulation(int insulation) {
        if (this.insulation != insulation) {
            this.changeInsulation(insulation);
        }
    }

    public void changeInsulation(int newLevel) {
        if (this.insulation == newLevel) {
            return;
        }
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        this.addedToEnergyNet = false;
        this.insulation = newLevel;
        if (newLevel == 0 && !registry.getContainerFromType(this.cableType, this.insulation).getInfo().canColorWithoutInsulation()) {
            this.cableColor = IEnergyConductorColored.WireColor.Blank;
            this.getNetwork().updateTileEntityField(this, "cableColor");
        }
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        this.addedToEnergyNet = true;
        this.getNetwork().updateTileEntityField(this, "insulation");
    }

    public boolean changeFoam(byte foamed) {
        return this.changeFoam(foamed, false);
    }

    private boolean changeFoam(byte newFoam, boolean duringLoad) {
        if (this.foamed == newFoam) {
            return false;
        }
        if (this.isSimulating()) {
            this.foamed = newFoam;
            if (this.foamed == 1) {
                this.storage.setAll(IEnergyConductorColored.WireColor.Silver);
                if (!duringLoad) {
                    this.getNetwork().updateTileEntityField(this, "storage");
                }
                IC2.callbacks.addCallback(this.field_145850_b, new IWorldTickCallback(){

                    @Override
                    public ActionResult<Integer> tickCallback(World world) {
                        if (TileEntityCable.this.func_145837_r() || TileEntityCable.this.foamed != 1) {
                            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)0);
                        }
                        if (TileEntityCable.this.field_145850_b.func_175671_l(TileEntityCable.this.func_174877_v()) * 6 >= ((TileEntityCable)TileEntityCable.this).field_145850_b.field_73012_v.nextInt(1000)) {
                            TileEntityCable.this.changeFoam((byte)2);
                            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)0);
                        }
                        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)500);
                    }
                }, 500);
            } else if (this.foamed == 0) {
                // empty if block
            }
            if (!duringLoad) {
                this.getNetwork().updateTileEntityField(this, "foamed");
            }
        }
        return true;
    }

    @Override
    public double getConductionLoss() {
        return registry.getInfoFromType(this.cableType).getConductorLoss(this.insulation);
    }

    @Override
    public double getInsulationEnergyAbsorption() {
        return registry.getInfoFromType(this.cableType).getInsulationEnergyAbsorption(this.insulation);
    }

    @Override
    public double getInsulationBreakdownEnergy() {
        return registry.getInfoFromType(this.cableType).getInsulationBreakdownEnergy(this.insulation);
    }

    @Override
    public double getConductorBreakdownEnergy() {
        return registry.getInfoFromType(this.cableType).getConductorBreakdownEnergy(this.insulation);
    }

    @Override
    public void removeInsulation() {
        int newInsulation = registry.getInfoFromType(this.cableType).removeAllInsulation(this.insulation);
        if (newInsulation != this.insulation) {
            this.changeInsulation(newInsulation);
        }
    }

    @Override
    public void removeConductor() {
        boolean burn = EnergyNetLocal.burn && this.field_145850_b.field_73012_v.nextFloat() < EnergyNetLocal.chance;
        this.field_145850_b.func_175698_g(this.func_174877_v());
        this.getNetwork().initiateTileEntityEvent(this, 0, true);
        if (burn) {
            this.field_145850_b.func_175656_a(this.func_174877_v(), Blocks.field_150480_ab.func_176223_P());
        }
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return this.connection.contains(side);
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return this.connection.contains(side);
    }

    @Override
    public IEnergyConductorColored.WireColor getConductorColor() {
        return this.cableColor;
    }

    @Override
    public EnumDyeColor getColor(EnumFacing side) {
        return this.cableColor.toColor();
    }

    public boolean canInteractWith(IEnergyTile tile, EnumFacing side) {
        if (this.anchors.contains(side)) {
            return false;
        }
        if (tile instanceof TileEntityCable) {
            return this.canInteractWithCable((TileEntityCable)tile, side.func_176734_d());
        }
        if (tile instanceof TileEntityMultipartLuminator) {
            return !((TileEntityMultipartLuminator)tile).hasSide(side.func_176734_d().func_176745_a()) && this.canInteractWithAPICable((IEnergyConductorColored)tile);
        }
        if (tile instanceof IAnchorConductor && ((IAnchorConductor)tile).hasAnchor(side.func_176734_d())) {
            return false;
        }
        if (tile instanceof IEnergyConductorColored) {
            return this.canInteractWithAPICable((IEnergyConductorColored)tile);
        }
        if (tile instanceof TileEntityLuminator) {
            return ((TileEntityLuminator)tile).acceptsEnergyFrom(this, side.func_176734_d());
        }
        if (tile instanceof IEnergyAcceptor && !(tile instanceof IEnergyEmitter)) {
            return ((IEnergyAcceptor)tile).acceptsEnergyFrom(this, side.func_176734_d());
        }
        if (tile instanceof IEnergyEmitter && !(tile instanceof IEnergyAcceptor)) {
            return ((IEnergyEmitter)tile).emitsEnergyTo(this, side.func_176734_d());
        }
        if (tile instanceof IEnergyAcceptor && tile instanceof IEnergyEmitter) {
            return ((IEnergyEmitter)tile).emitsEnergyTo(this, side.func_176734_d()) || ((IEnergyAcceptor)tile).acceptsEnergyFrom(this, side.func_176734_d());
        }
        return tile instanceof IMetaDelegate || tile instanceof INetworkTileEntityEventListener;
    }

    @Override
    public void onBlockUpdate(Block block) {
        super.onBlockUpdate(block);
        if (this.isRendering()) {
            return;
        }
        RotationList newList = RotationList.EMPTY;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            IEnergyTile tile = EnergyNet.instance.getSubTile(this.func_145831_w(), this.func_174877_v().func_177972_a(dir));
            if (tile == null || !(tile instanceof IEnergyAcceptor) && !(tile instanceof IEnergyEmitter)) {
                tile = EnergyNet.instance.getTile(this.func_145831_w(), this.func_174877_v().func_177972_a(dir));
            }
            if (tile == null || !this.canInteractWith(tile, dir)) continue;
            newList = newList.add(dir);
        }
        if (this.connection.getCode() != newList.getCode()) {
            this.connection = newList;
            this.getNetwork().updateTileEntityField(this, "connection");
        }
    }

    public boolean canConnect(EnumFacing facing) {
        return this.connection.contains(facing) || this.anchors.contains(facing);
    }

    public boolean canInteractWithAPICable(IEnergyConductorColored cable) {
        return this.cableColor == IEnergyConductorColored.WireColor.Blank || cable.getConductorColor() == IEnergyConductorColored.WireColor.Blank || this.cableColor == cable.getConductorColor();
    }

    public boolean canInteractWithCable(TileEntityCable cable, EnumFacing side) {
        if (cable.hasAnchor(side)) {
            return false;
        }
        return this.cableColor == IEnergyConductorColored.WireColor.Blank || cable.cableColor == IEnergyConductorColored.WireColor.Blank || this.cableColor == cable.cableColor;
    }

    @Override
    public double getWrenchDropRate() {
        return 0.0;
    }

    @Override
    public boolean canSetFacing(EntityPlayer player, EnumFacing facing) {
        return false;
    }

    @Override
    public boolean canRemoveBlock(EntityPlayer player) {
        return false;
    }

    public TextureCopyStorage getStorage() {
        return this.storage;
    }

    public boolean add(EnumFacing targetSide, IBlockState model, IBlockState render, int[] color, RetextureEventClassic.Rotation[] rot, EnumFacing facing) {
        if (this.storage.isColored(targetSide.func_176745_a())) {
            this.storage.set(targetSide.func_176745_a(), model, render, color, rot, facing);
            this.getNetwork().updateTileEntityField(this, "storage");
            return true;
        }
        ICopyEntry entry = this.storage.getEntry(targetSide.func_176745_a());
        if (entry.getModelState() == model && entry.getRenderState() == render && entry.getSide() == facing) {
            return false;
        }
        this.storage.set(targetSide.func_176745_a(), model, render, color, rot, facing);
        this.getNetwork().updateTileEntityField(this, "storage");
        return true;
    }

    @Override
    public boolean tryAddInsulation() {
        IWireInformation info = registry.getInfoFromType(this.cableType);
        int newLevel = info.addInsulation(this.insulation);
        if (newLevel != this.insulation) {
            this.changeInsulation(newLevel);
            return true;
        }
        return false;
    }

    @Override
    public boolean tryRemoveInsulation() {
        IWireInformation info = registry.getInfoFromType(this.cableType);
        int newLevel = info.removeInsulation(this.insulation);
        if (newLevel != this.insulation) {
            this.changeInsulation(newLevel);
            return true;
        }
        return false;
    }

    public int getAsItemMeta() {
        return registry.getMetaFromType(this.cableType, this.insulation);
    }

    @Override
    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(registry.getContainerFromType(this.cableType, this.insulation).getDrop());
        for (int i = 0; i < 6; ++i) {
            if (!this.anchors.contains(EnumFacing.func_82600_a((int)i))) continue;
            list.add(Ic2Items.miningPipe.func_77946_l());
        }
        return list;
    }

    @Override
    public boolean hasSpecialAction(EntityPlayer player, EnumFacing facing, Vec3d hit) {
        EnumFacing side = new BlockCable.ClickHelper(hit, (float)(registry.getInfoFromType(this.cableType).getConductorThickness(this.insulation) / 16.0)).getFacing(facing);
        return side != null && this.anchors.contains(side);
    }

    @Override
    public EnumActionResult doSpecialAction(EntityPlayer player, EnumFacing facing, Vec3d hit) {
        EnumFacing side = new BlockCable.ClickHelper(hit, (float)(registry.getInfoFromType(this.cableType).getConductorThickness(this.insulation) / 16.0)).getFacing(facing);
        if (this.isRendering()) {
            return EnumActionResult.PASS;
        }
        if (side != null && this.removeAnchor(side)) {
            ItemStack pipe = Ic2Items.miningPipe.func_77946_l();
            if (!player.field_71071_by.func_70441_a(pipe)) {
                player.func_71019_a(pipe, true);
            }
            return EnumActionResult.SUCCESS;
        }
        return super.doSpecialAction(player, facing, hit);
    }
}

