/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring.tile;

import ic2.api.classic.network.adv.NetworkField;
import ic2.api.classic.tile.IElectrolyzerProvider;
import ic2.api.classic.tile.machine.IEUStorage;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IMultiEnergySource;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityMachine;
import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.comparators.ComparatorEUStorage;
import ic2.core.block.base.util.info.EnergyInfo;
import ic2.core.block.base.util.info.SinkTierInfo;
import ic2.core.block.base.util.info.SourceTierInfo;
import ic2.core.block.wiring.container.ContainerBatteryStation;
import ic2.core.block.wiring.misc.SlotInformation;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.ArrayFilter;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.util.math.MathUtil;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityBatteryStation
extends TileEntityMachine
implements IEnergySink,
IMultiEnergySource,
IEUStorage,
IElectrolyzerProvider,
INetworkClientTileEntityEventListener,
ITickable,
IHasGui {
    @NetworkField(index=3)
    public int storedEnergy;
    @NetworkField(index=4)
    public int maxEnergy;
    @NetworkField(index=5, compression=NetworkField.BitLevel.Bit8)
    public int[] income = new int[20];
    @NetworkField(index=6, compression=NetworkField.BitLevel.Bit8)
    public int[] outcome = new int[20];
    public int tick;
    @NetworkField(index=7)
    public int averageIn;
    @NetworkField(index=8)
    public int averageOut;
    @NetworkField(index=9)
    public SlotInformation slots = new SlotInformation(this);
    @NetworkField(index=10, compression=NetworkField.BitLevel.Bit8)
    public int stationMode = 0;
    public static int maxMode = 3;
    @NetworkField(index=11, compression=NetworkField.BitLevel.Bit8)
    public int sendingMode = 0;
    public static int sendingMaxMode = 3;
    public boolean dirty = false;
    public boolean added = false;
    @NetworkField(index=12, compression=NetworkField.BitLevel.Bit8)
    public int state = 0;

    public TileEntityBatteryStation() {
        super(9);
        this.addNetworkFields("state", "stationMode", "sendingMode");
        this.addGuiFields("maxEnergy", "storedEnergy", "slots", "averageIn", "averageOut");
        this.addInfos(new EnergyInfo(this), new SinkTierInfo(this), new SourceTierInfo(this));
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        int[] slots = MathUtil.fromTo(0, 9);
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, slots);
        handler.registerDefaultSlotsForSide(RotationList.ALL, slots);
        handler.registerSlotType(SlotType.BatteryStation, slots);
        handler.registerInputFilter(new ArrayFilter(CommonFilters.ChargeEU, CommonFilters.DischargeEU), slots);
    }

    @Override
    protected void addComparators(ComparatorManager manager) {
        super.addComparators(manager);
        manager.addComparatorMode(new ComparatorEUStorage(this));
    }

    @Override
    public int getStoredEU() {
        return this.storedEnergy;
    }

    @Override
    public int getMaxEU() {
        return this.maxEnergy;
    }

    @Override
    public void setStackInSlot(int slot, ItemStack stack) {
        super.setStackInSlot(slot, stack);
        this.slots.updateSlot(slot);
        this.dirty = true;
        if (this.sendingMode == 0) {
            this.slots.setFirstSlot();
        }
    }

    @Override
    public int getMaxStackSize(int slot) {
        return 1;
    }

    @Override
    public void onNetworkUpdate(String field) {
        super.onNetworkUpdate(field);
        if (field.equals("state")) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return (this.stationMode == 0 || this.stationMode == 2) && side != this.getFacing();
    }

    @Override
    public double getDemandedEnergy() {
        return this.maxEnergy - this.storedEnergy;
    }

    @Override
    public int getSinkTier() {
        return 10;
    }

    @Override
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        if (amount <= 0.0) {
            return 0.0;
        }
        double left = this.slots.charge(amount);
        double added = amount - left;
        this.storedEnergy = (int)((double)this.storedEnergy + added);
        int n = this.tick;
        this.income[n] = (int)((double)this.income[n] + added);
        this.getNetwork().updateTileGuiField(this, "storedEnergy");
        return left;
    }

    @Override
    public double getOfferedEnergy() {
        return this.slots.getOffer();
    }

    @Override
    public void drawEnergy(double amount) {
        int n = this.tick;
        this.outcome[n] = (int)((double)this.outcome[n] + amount);
        this.storedEnergy = (int)((double)this.storedEnergy - amount);
        this.slots.draw(amount);
        if (this.sendingMode == 0) {
            this.slots.setFirstSlot();
            this.getNetwork().updateTileGuiField(this, "slots");
        } else if (this.sendingMode == 2) {
            this.slots.updateDrawSlot();
        }
        this.getNetwork().updateTileGuiField(this, "storedEnergy");
    }

    @Override
    public int getSourceTier() {
        return this.slots.getTier();
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return (this.stationMode == 1 || this.stationMode == 2) && side == this.getFacing();
    }

    @Override
    public boolean sendMultipleEnergyPackets() {
        return (this.stationMode == 1 || this.stationMode == 2) && this.sendingMode == 2;
    }

    @Override
    public int getMultipleEnergyPacketAmount() {
        return this.slots.getSlotCount();
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.batteryStation;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.added) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.added = true;
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (this.added) {
            this.added = false;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
    }

    @Override
    public int getProcessRate() {
        return EnergyNet.instance.getTierFromPower(this.getTier()) / 16;
    }

    @Override
    public int getTier() {
        return this.slots.makeMaxTier();
    }

    @Override
    public void drawPower(int amount) {
        this.slots.drawAll(amount);
        int n = this.tick;
        this.outcome[n] = this.outcome[n] + amount;
        this.storedEnergy -= amount;
    }

    @Override
    public void addPower(int amount) {
        this.slots.charge(amount);
        int n = this.tick;
        this.income[n] = this.income[n] + amount;
        this.storedEnergy += amount;
    }

    @Override
    public int getStoredEnergy() {
        return this.storedEnergy;
    }

    @Override
    public int getMaxEnergyStorage() {
        return this.maxEnergy;
    }

    @Override
    public boolean canRemoveBlock(EntityPlayer player) {
        return true;
    }

    @Override
    public boolean canSetFacing(EntityPlayer player, EnumFacing facing) {
        return this.getFacing() != facing;
    }

    @Override
    public void setFacing(EnumFacing face) {
        if (this.added) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        this.added = false;
        super.setFacing(face);
        MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
        this.added = true;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        if (event == 0) {
            if (this.added) {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            }
            this.added = false;
            ++this.stationMode;
            if (this.stationMode >= maxMode) {
                this.stationMode = 0;
            }
            this.getNetwork().updateTileEntityField(this, "stationMode");
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.added = true;
            IC2.platform.messagePlayer(player, this.getStationMode());
        } else if (event == 1) {
            if (this.stationMode < 1) {
                IC2.platform.messagePlayer(player, Ic2GuiLang.nothingHappend);
                return;
            }
            ++this.sendingMode;
            if (this.sendingMode >= sendingMaxMode) {
                this.sendingMode = 0;
                this.slots.setFirstSlot();
                this.getNetwork().updateTileGuiField(this, "slots");
            }
            this.getNetwork().updateTileEntityField(this, "sendingMode");
            IC2.platform.messagePlayer(player, this.getSendingMode());
        }
    }

    public LocaleComp getStationMode() {
        switch (this.stationMode) {
            case 1: {
                return Ic2GuiLang.stationModeDischarging;
            }
            case 2: {
                return Ic2GuiLang.stationModeBatbox;
            }
        }
        return Ic2GuiLang.stationModeCharging;
    }

    public LocaleComp getSendingMode() {
        switch (this.sendingMode) {
            case 1: {
                return Ic2GuiLang.sendingModeHigh;
            }
            case 2: {
                return Ic2GuiLang.sendingModePacket;
            }
        }
        return Ic2GuiLang.sendingModeLow;
    }

    public void func_73660_a() {
        if (this.dirty) {
            this.dirty = false;
            this.slots.updateAll();
            this.storedEnergy = this.slots.getCharge();
            this.maxEnergy = this.slots.getMaxCharge();
            this.getNetwork().updateTileGuiField(this, "storedEnergy");
            this.getNetwork().updateTileGuiField(this, "maxEnergy");
        }
        ++this.tick;
        if (this.tick >= 20) {
            this.tick = 0;
            double maxIn = 0.0;
            double maxOut = 0.0;
            for (int i = 0; i < 20; ++i) {
                maxIn += (double)this.income[i];
                maxOut += (double)this.outcome[i];
            }
            this.averageIn = (int)(maxIn / 20.0);
            this.averageOut = (int)(maxOut / 20.0);
            this.income = new int[20];
            this.outcome = new int[20];
            this.getNetwork().updateTileGuiField(this, "averageIn");
            this.getNetwork().updateTileGuiField(this, "averageOut");
            int newState = this.getUpdatedState();
            if (newState != this.state) {
                this.state = newState;
                this.getNetwork().updateTileEntityField(this, "state");
            }
        }
        this.updateComparators();
    }

    public float getChargeLevel() {
        float ret = (float)this.storedEnergy / (float)this.maxEnergy;
        if (ret > 1.0f) {
            ret = 1.0f;
        }
        return ret;
    }

    public int getUpdatedState() {
        float charge = this.getChargeLevel();
        if ((double)charge <= 0.01) {
            return 0;
        }
        if ((double)charge >= 0.99) {
            return 3;
        }
        if ((double)charge < 0.5) {
            return 1;
        }
        return 2;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerBatteryStation(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.averageIn = nbt.func_74762_e("In");
        this.averageOut = nbt.func_74762_e("Out");
        this.sendingMode = nbt.func_74762_e("Send");
        this.stationMode = nbt.func_74762_e("Station");
        this.state = nbt.func_74762_e("State");
        this.slots.updateAll();
        this.dirty = true;
        this.storedEnergy = this.slots.getCharge();
        this.maxEnergy = this.slots.getMaxCharge();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("In", this.averageIn);
        nbt.func_74768_a("Out", this.averageOut);
        nbt.func_74768_a("Send", this.sendingMode);
        nbt.func_74768_a("Station", this.stationMode);
        nbt.func_74768_a("State", this.state);
        return nbt;
    }
}

