/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring.cables.types;

import ic2.api.classic.energy.tile.IEnergyConductorColored;
import ic2.core.block.wiring.cables.types.CableBase;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import net.minecraft.item.ItemStack;

public class GoldCable
extends CableBase {
    @Override
    public int getMaxInsulationTypes() {
        return 2;
    }

    @Override
    public double getConductorLoss(int insulation) {
        switch (insulation) {
            case 0: {
                return 0.5;
            }
            case 1: {
                return 0.45f;
            }
            case 2: {
                return 0.4f;
            }
        }
        return 0.0;
    }

    @Override
    public double getInsulationEnergyAbsorption(int insulation) {
        switch (insulation) {
            case 0: {
                return 8.0;
            }
            case 1: {
                return 32.0;
            }
            case 2: {
                return 128.0;
            }
        }
        return 0.0;
    }

    @Override
    public double getInsulationBreakdownEnergy(int insulation) {
        return 9001.0;
    }

    @Override
    public double getConductorBreakdownEnergy(int insulation) {
        return 129.0;
    }

    @Override
    public double getConductorThickness(int insulation) {
        switch (insulation) {
            case 0: {
                return 3.0;
            }
            case 1: {
                return 5.0;
            }
            case 2: {
                return 6.0;
            }
        }
        return 0.0;
    }

    @Override
    public int getTexture(int insulation, IEnergyConductorColored.WireColor color, boolean active) {
        switch (insulation) {
            case 0: {
                return 34 + color.ordinal();
            }
            case 1: {
                return 51 + color.ordinal();
            }
            case 2: {
                return 68 + color.ordinal();
            }
        }
        return 34;
    }

    @Override
    public int getItemIcon(int insulation) {
        return 98 + insulation;
    }

    @Override
    public LocaleComp getName(int insulation) {
        switch (insulation) {
            case 0: {
                return Ic2ItemLang.goldCable;
            }
            case 1: {
                return Ic2ItemLang.goldCableInsulated;
            }
            case 2: {
                return Ic2ItemLang.goldCableDoubleInsulated;
            }
        }
        return super.getName(insulation);
    }

    @Override
    public ItemStack getDrops(int insulation) {
        switch (insulation) {
            case 1: {
                return Ic2Items.insulatedGoldCable.func_77946_l();
            }
            case 2: {
                return Ic2Items.doubleInsulatedGoldCable.func_77946_l();
            }
        }
        return Ic2Items.goldCable.func_77946_l();
    }

    @Override
    public boolean canProvideRedstone() {
        return false;
    }
}

