/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring.cables;

import ic2.core.block.wiring.cables.CableContainer;
import ic2.core.block.wiring.cables.IWireInformation;
import ic2.core.block.wiring.cables.types.BronzeCable;
import ic2.core.block.wiring.cables.types.CopperCable;
import ic2.core.block.wiring.cables.types.DetectorCable;
import ic2.core.block.wiring.cables.types.GlassCable;
import ic2.core.block.wiring.cables.types.GoldCable;
import ic2.core.block.wiring.cables.types.IronCable;
import ic2.core.block.wiring.cables.types.PlasmaCable;
import ic2.core.block.wiring.cables.types.SplitterCable;
import ic2.core.block.wiring.cables.types.TinCable;
import ic2.core.util.obj.plugins.PluginEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.Event;

public class WireRegistry {
    IWireInformation[] types;
    CableContainer[] metaContainer;
    CableContainer[][] typeContainer;
    final CableContainer defaultContainer = new CableContainer(new CopperCable(), 0, 1, 0);
    final List<IWireInformation> info;
    int maxMetadata;
    public static WireRegistry instance = new WireRegistry();

    public WireRegistry() {
        ArrayList<IWireInformation> cables = new ArrayList<IWireInformation>();
        cables.add(new CopperCable());
        cables.add(new GoldCable());
        cables.add(new IronCable());
        cables.add(new GlassCable());
        cables.add(new TinCable());
        cables.add(new DetectorCable());
        cables.add(new SplitterCable());
        cables.add(new BronzeCable());
        cables.add(new PlasmaCable());
        MinecraftForge.EVENT_BUS.post((Event)new PluginEvent.WireRegistryEvent(cables));
        if (cables.size() > 16) {
            this.info = new ArrayList<IWireInformation>(cables.subList(0, 16));
            FMLLog.getLogger().info("More then 16 Cabel Metas were registered. Limiting to 16 Metadata");
        } else {
            this.info = cables;
        }
        this.processList();
    }

    public IWireInformation getInfoFromType(int type) {
        if (this.types.length <= type) {
            return this.defaultContainer.getInfo();
        }
        return this.types[type];
    }

    public IWireInformation getInfoFromMeta(int meta) {
        return this.getContainerFromMeta(meta).getInfo();
    }

    public int getInsulationFromMeta(int meta) {
        return this.getContainerFromMeta(meta).getInsulation();
    }

    public int getMetaFromType(int type) {
        return this.getMetaFromType(type, 0);
    }

    public int getMetaFromType(int type, int insulation) {
        return this.getContainerFromType(type, insulation).getMetadata();
    }

    public int getTypeFromMeta(int meta) {
        return this.getContainerFromMeta(meta).getType();
    }

    public CableContainer getContainerFromType(int type, int insulation) {
        if (type >= this.typeContainer.length) {
            return this.defaultContainer;
        }
        CableContainer[] array = this.typeContainer[type];
        if (insulation >= array.length) {
            return this.defaultContainer;
        }
        return array[insulation];
    }

    public CableContainer getContainerFromMeta(int meta) {
        if (meta >= this.metaContainer.length) {
            return this.defaultContainer;
        }
        return this.metaContainer[meta];
    }

    public int getTypeAmount() {
        return this.types.length;
    }

    public int getMaxMeta() {
        return this.maxMetadata;
    }

    public int getMaxBlockMeta() {
        return this.info.size() - 1;
    }

    private void processList() {
        this.types = this.info.toArray(new IWireInformation[this.info.size()]);
        this.typeContainer = new CableContainer[this.info.size()][];
        this.maxMetadata = 0;
        ArrayList<CableContainer> metaList = new ArrayList<CableContainer>();
        for (int i = 0; i < this.info.size(); ++i) {
            IWireInformation wireInfo = this.info.get(i);
            int max = wireInfo.getMaxInsulationTypes() + 1;
            CableContainer[] cont = new CableContainer[max];
            for (int z = 0; z < max; ++z) {
                CableContainer cu;
                cont[z] = cu = new CableContainer(wireInfo, i, z, this.maxMetadata++);
                metaList.add(cu);
            }
            this.typeContainer[i] = cont;
        }
        this.metaContainer = metaList.toArray(new CableContainer[metaList.size()]);
    }
}

