/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import ic2.core.IC2;
import ic2.core.block.base.BlockMultiID;
import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.block.base.tile.TileEntityElectricBlock;
import ic2.core.block.wiring.tile.TileEntityAdjustableTransformer;
import ic2.core.block.wiring.tile.TileEntityBatteryStation;
import ic2.core.block.wiring.tile.TileEntityCreativeEnergyStorage;
import ic2.core.block.wiring.tile.TileEntityElectricBatBox;
import ic2.core.block.wiring.tile.TileEntityElectricMFE;
import ic2.core.block.wiring.tile.TileEntityElectricMFSU;
import ic2.core.block.wiring.tile.TileEntityElectricPESU;
import ic2.core.block.wiring.tile.TileEntityTransformerEV;
import ic2.core.block.wiring.tile.TileEntityTransformerHV;
import ic2.core.block.wiring.tile.TileEntityTransformerIV;
import ic2.core.block.wiring.tile.TileEntityTransformerLV;
import ic2.core.block.wiring.tile.TileEntityTransformerMV;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.helpers.BlockStateContainerIC2;
import ic2.core.util.obj.IBootable;
import ic2.core.util.obj.IRareBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockElectric
extends BlockMultiID
implements IBootable,
IRareBlock {
    public static PropertyInteger chargelevel = PropertyInteger.func_177719_a((String)"chargelevel", (int)0, (int)3);

    public BlockElectric() {
        super(Material.field_151573_f);
        this.func_149711_c(1.5f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setTranslationKey(Ic2BlockLang.electricBlock);
        this.setHarvestLevel("pickaxe", 1);
    }

    @Override
    public void onLoad() {
        Ic2States.batBox = this.func_176203_a(0);
        Ic2States.mfe = this.func_176203_a(1);
        Ic2States.mfsu = this.func_176203_a(2);
        Ic2States.batteryStation = this.func_176203_a(3);
        Ic2States.creativeEnergyStorage = this.func_176203_a(4);
        Ic2States.pesu = this.func_176203_a(5);
        Ic2States.transformerLV = this.func_176203_a(8);
        Ic2States.transformerMV = this.func_176203_a(9);
        Ic2States.transformerHV = this.func_176203_a(10);
        Ic2States.transformerEV = this.func_176203_a(11);
        Ic2States.adjustableTransformer = this.func_176203_a(12);
        Ic2States.transformerIV = this.func_176203_a(13);
        Ic2Items.batBox = new ItemStack((Block)this, 1, 0);
        Ic2Items.mfe = new ItemStack((Block)this, 1, 1);
        Ic2Items.mfsu = new ItemStack((Block)this, 1, 2);
        Ic2Items.batteryStation = new ItemStack((Block)this, 1, 3);
        Ic2Items.creativeEnergyStorage = new ItemStack((Block)this, 1, 4);
        Ic2Items.pesu = new ItemStack((Block)this, 1, 5);
        Ic2Items.transformerLV = new ItemStack((Block)this, 1, 8);
        Ic2Items.transformerMV = new ItemStack((Block)this, 1, 9);
        Ic2Items.transformerHV = new ItemStack((Block)this, 1, 10);
        Ic2Items.transformerEV = new ItemStack((Block)this, 1, 11);
        Ic2Items.adjustableTransformer = new ItemStack((Block)this, 1, 12);
        Ic2Items.transformerIV = new ItemStack((Block)this, 1, 13);
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        int meta = stack.func_77960_j();
        if (meta == 2 || meta == 3 || meta == 10 || meta == 11 || meta == 12) {
            return EnumRarity.UNCOMMON;
        }
        if (meta == 5 || meta == 13) {
            return EnumRarity.RARE;
        }
        return EnumRarity.COMMON;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainerIC2((Block)this, new IProperty[]{this.getMetadataProperty(), allFacings, active, chargelevel});
    }

    @Override
    public IBlockState getDefaultBlockState() {
        return super.getDefaultBlockState().func_177226_a((IProperty)chargelevel, (Comparable)Integer.valueOf(0));
    }

    @Override
    public List<IBlockState> getValidStates() {
        return this.func_176194_O().func_177619_a();
    }

    @Override
    public List<IBlockState> getValidStateList() {
        int[] array;
        IBlockState def = this.func_176223_P();
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        for (int i : array = new int[]{0, 1, 2, 3, 5}) {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                for (int x = 0; x < 4; ++x) {
                    states.add(def.func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)Integer.valueOf(i)).func_177226_a((IProperty)allFacings, (Comparable)side).func_177226_a((IProperty)chargelevel, (Comparable)Integer.valueOf(x)));
                }
            }
        }
        states.add(def.func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)Integer.valueOf(4)));
        for (int i : array = new int[]{8, 9, 10, 11, 13}) {
            for (EnumFacing side : EnumFacing.field_82609_l) {
                states.add(def.func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)Integer.valueOf(i)).func_177226_a((IProperty)allFacings, (Comparable)side).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(false)));
                states.add(def.func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)Integer.valueOf(i)).func_177226_a((IProperty)allFacings, (Comparable)side).func_177226_a((IProperty)active, (Comparable)Boolean.valueOf(true)));
            }
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            states.add(def.func_177226_a((IProperty)this.getMetadataProperty(), (Comparable)Integer.valueOf(12)).func_177226_a((IProperty)allFacings, (Comparable)side));
        }
        return states;
    }

    @Override
    public TileEntityBlock createNewTileEntity(World worldIn, int meta) {
        switch (meta) {
            case 0: {
                return new TileEntityElectricBatBox();
            }
            case 1: {
                return new TileEntityElectricMFE();
            }
            case 2: {
                return new TileEntityElectricMFSU();
            }
            case 3: {
                return new TileEntityBatteryStation();
            }
            case 4: {
                return new TileEntityCreativeEnergyStorage();
            }
            case 5: {
                return new TileEntityElectricPESU();
            }
            case 8: {
                return new TileEntityTransformerLV();
            }
            case 9: {
                return new TileEntityTransformerMV();
            }
            case 10: {
                return new TileEntityTransformerHV();
            }
            case 11: {
                return new TileEntityTransformerEV();
            }
            case 12: {
                return new TileEntityAdjustableTransformer();
            }
            case 13: {
                return new TileEntityTransformerIV();
            }
        }
        return new TileEntityBlock();
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        switch (this.func_176201_c(state)) {
            case 1: {
                return Ic2Items.machine.func_77973_b();
            }
            case 2: {
                return Ic2Items.advMachine.func_77973_b();
            }
            case 3: {
                return Ic2Items.advMachine.func_77973_b();
            }
            case 5: {
                return Ic2Items.advMachine.func_77973_b();
            }
            case 9: {
                return Ic2Items.machine.func_77973_b();
            }
        }
        return super.func_180660_a(state, rand, fortune);
    }

    public int func_180651_a(IBlockState state) {
        switch (this.func_176201_c(state)) {
            case 1: {
                return 0;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return 0;
            }
            case 5: {
                return 0;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 0;
            }
            case 10: {
                return 9;
            }
            case 11: {
                return 10;
            }
            case 12: {
                return 11;
            }
            case 13: {
                return 12;
            }
        }
        return super.func_180651_a(state);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        int meta = this.func_176201_c(state);
        if (meta == 4) {
            return 0;
        }
        return super.quantityDropped(state, fortune, random);
    }

    @Override
    public List<Integer> getValidMetas() {
        return Arrays.asList(0, 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite[] getIconSheet(int meta) {
        switch (meta) {
            case 0: {
                return Ic2Icons.getTextures("batBox");
            }
            case 1: {
                return Ic2Icons.getTextures("mfe");
            }
            case 2: {
                return Ic2Icons.getTextures("mfsu");
            }
            case 3: {
                return Ic2Icons.getTextures("bBox");
            }
            case 5: {
                return Ic2Icons.getTextures("pesu");
            }
        }
        return Ic2Icons.getTextures("belec");
    }

    @Override
    public int getIconMeta(IBlockState state) {
        int meta = super.getIconMeta(state);
        if (meta >= 0 && meta <= 3 || meta == 5) {
            return (Integer)state.func_177229_b((IProperty)chargelevel);
        }
        if (meta == 4) {
            return 9;
        }
        return meta - 8;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntityBlock tile;
        IBlockState result = super.func_176221_a(state, worldIn, pos);
        if (this.hasChargeState(this.func_176201_c(result)) && (tile = (TileEntityBlock)worldIn.func_175625_s(pos)) instanceof TileEntityElectricBlock) {
            TileEntityElectricBlock block = (TileEntityElectricBlock)tile;
            result = result.func_177226_a((IProperty)chargelevel, (Comparable)Integer.valueOf(block.state));
        }
        return result;
    }

    public boolean hasChargeState(int meta) {
        return meta >= 0 && meta <= 3 || meta == 5;
    }

    @Override
    public int getMaxSheetSize(int meta) {
        if (meta < 4 || meta == 5) {
            return 4;
        }
        return 16;
    }

    @Override
    @Deprecated
    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntity tile = blockAccess.func_175625_s(pos);
        if (tile instanceof TileEntityElectricBlock) {
            return ((TileEntityElectricBlock)tile).isEmittingRedstone() ? 15 : 0;
        }
        return super.func_176211_b(blockState, blockAccess, pos, side);
    }

    @Override
    @Deprecated
    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntity tile = blockAccess.func_175625_s(pos);
        if (tile instanceof TileEntityElectricBlock) {
            return ((TileEntityElectricBlock)tile).isEmittingRedstone() ? 15 : 0;
        }
        return super.func_180656_a(blockState, blockAccess, pos, side);
    }

    @Deprecated
    public boolean func_149744_f(IBlockState state) {
        int meta = this.func_176201_c(state);
        if (meta >= 0 && meta <= 2) {
            return true;
        }
        return super.func_149744_f(state);
    }

    @Override
    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (IC2.platform.isRendering()) {
            return;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (!(tile instanceof TileEntityBlock)) {
            return;
        }
        TileEntityBlock block = (TileEntityBlock)tile;
        if (placer == null) {
            block.setFacing(EnumFacing.NORTH);
        } else {
            int pitch = Math.round(placer.field_70125_A);
            if (pitch >= 65) {
                block.setFacing(EnumFacing.UP);
            } else if (pitch <= -65) {
                block.setFacing(EnumFacing.DOWN);
            } else {
                block.setFacing(EnumFacing.func_176733_a((double)placer.field_70177_z).func_176734_d());
            }
        }
        if (stack.func_82837_s()) {
            block.setCustomName(stack.func_82833_r());
        }
    }
}

