/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal.container;

import ic2.core.block.personal.base.misc.PersonalInventory;
import ic2.core.block.personal.tile.TileEntityPersonalEnergyStorage;
import ic2.core.block.wiring.container.ContainerElectricBlock;
import ic2.core.inventory.container.ContainerTileComponent;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.gui.components.special.PersonalEnergyStorageComp;
import ic2.core.inventory.gui.components.special.PersonalStorageComp;
import ic2.core.inventory.slots.SlotArmor;
import ic2.core.inventory.slots.SlotCharge;
import ic2.core.inventory.slots.SlotDischarge;
import ic2.core.inventory.slots.SlotGhoest;
import ic2.core.platform.registry.Ic2GuiComp;
import ic2.core.platform.registry.Ic2Resources;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerPersonalEnergyStorage
extends ContainerTileComponent<TileEntityPersonalEnergyStorage> {
    public ContainerPersonalEnergyStorage(InventoryPlayer player, TileEntityPersonalEnergyStorage storage, boolean isView) {
        super(storage);
        if (!isView) {
            this.func_75146_a(new SlotCharge(storage.inventory, storage.storage.getTier(), 0, 56, 17));
            this.func_75146_a(new SlotDischarge(storage.inventory, storage.storage.getTier(), 1, 56, 53));
            this.addComponent(new PersonalStorageComp(storage));
        } else {
            PersonalInventory inv = storage.inventory.copy();
            this.func_75146_a(new SlotGhoest(inv, 0, 56, 17));
            this.func_75146_a(new SlotGhoest(inv, 1, 56, 53));
        }
        for (int i = 0; i < 4; ++i) {
            this.func_75146_a(new SlotArmor(player, 3 - i, ContainerElectricBlock.VALID_EQUIPMENT_SLOTS[i], 8, 8 + i * 18));
        }
        this.addComponent(new PersonalEnergyStorageComp(storage));
        this.addPlayerInventory(player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiLoaded(GuiIC2 gui) {
        gui.setMCOffset(Ic2GuiComp.personalEnergyStorageMCPos);
    }

    @Override
    public int guiInventorySize() {
        return 2;
    }

    @Override
    public ResourceLocation getTexture() {
        return Ic2Resources.personalEnergyStorage;
    }
}

