/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal.base.trades;

import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.adv.IInputBuffer;
import ic2.api.classic.network.adv.IOutputBuffer;
import ic2.api.classic.trading.trades.ITrade;
import ic2.core.IC2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TradeList
implements INetworkFieldData {
    List<ITrade> trades = new ArrayList<ITrade>();

    public void readFromNBT(NBTTagCompound nbt) {
        this.trades.clear();
        HashMap<Integer, ITrade> mapping = new HashMap<Integer, ITrade>();
        NBTTagList list = nbt.func_150295_c("Trades", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            mapping.put(data.func_74762_e("TradeSlot"), IC2.manager.createTradeFromNBT(data));
        }
        ArrayList mappingList = new ArrayList(mapping.keySet());
        Collections.sort(mappingList);
        for (Integer key : mappingList) {
            ITrade trade = (ITrade)mapping.get(key);
            if (trade == null) continue;
            this.trades.add(trade);
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.trades.size(); ++i) {
            NBTTagCompound data = IC2.manager.saveTradeToNBT(this.trades.get(i));
            data.func_74768_a("TradeSlot", i);
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("Trades", (NBTBase)list);
    }

    public List<ITrade> getTradesForPlayer(UUID player) {
        ArrayList<ITrade> tradeList = new ArrayList<ITrade>(this.trades.size());
        for (ITrade trade : this.trades) {
            if (!trade.canAccessTrade(player)) continue;
            tradeList.add(trade);
        }
        return tradeList;
    }

    public int indexOf(ITrade trade) {
        return this.trades.indexOf(trade);
    }

    public ITrade getTradeForSlot(int trade, UUID player) {
        ITrade result;
        ITrade iTrade = result = this.trades.size() > trade ? this.trades.get(trade) : null;
        if (result != null && !result.canAccessTrade(player)) {
            return null;
        }
        return result;
    }

    public void addTrade(ITrade trade) {
        if (trade == null) {
            return;
        }
        this.trades.add(trade);
    }

    public int getSize() {
        return this.trades.size();
    }

    public List<ITrade> getTrades() {
        return this.trades;
    }

    public ITrade getTradeSave(int slot) {
        if (slot < 0) {
            return null;
        }
        if (this.trades.size() > slot) {
            return this.trades.get(slot);
        }
        return null;
    }

    public void removeSave(int slot) {
        if (slot < 0) {
            return;
        }
        if (this.trades.size() > slot) {
            this.trades.remove(slot);
        }
    }

    @Override
    public void read(IInputBuffer buffer) {
        this.readFromNBT(buffer.readNBTData());
    }

    @Override
    public void write(IOutputBuffer buffer) {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        buffer.writeNBTData(nbt);
    }
}

