/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.personal.base;

import ic2.api.classic.audio.PositionSpec;
import ic2.api.classic.network.ICustomNetworkTileEventListener;
import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.trading.ITradeListener;
import ic2.api.classic.trading.providers.ITradeProvider;
import ic2.api.classic.trading.trades.IModifyableTrade;
import ic2.api.classic.trading.trades.ISubTrade;
import ic2.api.classic.trading.trades.ITrade;
import ic2.api.classic.trading.trades.TradeType;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.network.INetworkTileEntityEventListener;
import ic2.core.Direction;
import ic2.core.IC2;
import ic2.core.block.base.tile.TileEntityBlock;
import ic2.core.block.personal.base.misc.IPersonalBlock;
import ic2.core.block.personal.base.trades.TradeList;
import ic2.core.block.personal.base.util.TradeSyncer;
import ic2.core.inventory.transport.IItemTransporter;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.item.misc.ItemIC2Coin;
import ic2.core.network.fieldEvents.custom.NBTFieldPacket;
import ic2.core.platform.registry.Ic2Sounds;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileEntityTradeOMatBase
extends TileEntityBlock
implements ITradeProvider,
INetworkTileEntityEventListener,
INetworkClientTileEntityEventListener,
ICustomNetworkTileEventListener {
    List<ITradeListener> listeners = new ArrayList<ITradeListener>();
    TradeList tradeList = new TradeList();
    TradeSyncer sync = new TradeSyncer(this);
    public boolean worldGen = false;

    public abstract TradeType getType();

    @Override
    public abstract UUID getOwner();

    @Override
    public List<ITrade> getTradesForPlayer(UUID player) {
        return this.tradeList.getTradesForPlayer(player);
    }

    @Override
    public int getSlotForTrade(ITrade trade) {
        return this.tradeList.indexOf(trade);
    }

    @Override
    public ITrade getTradeForSlot(int trade, UUID player) {
        return this.tradeList.getTradeForSlot(trade, player);
    }

    public TradeSyncer getSyncer() {
        return this.sync;
    }

    @Override
    public void onTradePerformed(UUID player, ISubTrade trade, List<ItemStack> list) {
        this.getNetwork().initiateTileEntityEvent(this, 0, true);
        this.sendItemsAway(list, true);
        for (ITradeListener listener : this.listeners) {
            listener.onTradePerformed(trade, player, this);
        }
    }

    public boolean sendItemsAway(List<ItemStack> list, boolean doAdd) {
        if (list.isEmpty()) {
            return true;
        }
        if (!doAdd) {
            list = StackUtil.copyList(list);
        }
        EnumSet<Direction> dirs = EnumSet.noneOf(Direction.class);
        for (Direction dir : Direction.directions) {
            IItemTransporter transporter;
            TileEntity tile = dir.applyToTileEntity(this);
            if (!(tile instanceof IPersonalBlock) || (transporter = TransporterManager.manager.getTransporter(((IPersonalBlock)tile).getInventory(this.getOwner()), false)) == null) continue;
            EnumFacing facing = dir.getInverse().toFacing();
            for (int i = 0; i < list.size(); ++i) {
                ItemStack stack = list.get(i);
                if (stack.func_190926_b()) {
                    list.remove(i--);
                    continue;
                }
                ItemStack added = transporter.addItem(stack, facing, doAdd);
                if (added == null || added.func_190916_E() <= 0) continue;
                stack.func_190920_e(added.func_190916_E());
                if (!stack.func_190926_b()) continue;
                list.remove(i--);
            }
            if (!list.isEmpty()) continue;
            return true;
        }
        return dirs.isEmpty();
    }

    @Override
    public World getProviderWorld() {
        return this.func_145831_w();
    }

    @Override
    public BlockPos getProviderPos() {
        return this.func_174877_v();
    }

    @Override
    public void addListener(ITradeListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ITradeListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        IC2.manager.onTraderCreated(this);
    }

    @Override
    public void onUnloaded() {
        for (ITradeListener listener : this.listeners) {
            listener.onListenBreakDown(this);
        }
        super.onUnloaded();
    }

    @Override
    public void addTrade(ITrade trade) {
        if (trade == null || trade.getType() != this.getType()) {
            return;
        }
        this.tradeList.addTrade(trade.newInstance(this.getOwner()));
        this.sync.markAllDirty();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tradeList.readFromNBT(nbt.func_74775_l("TradeStorage"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        this.tradeList.writeToNBT(this.getTag(nbt, "TradeStorage"));
        return nbt;
    }

    public TradeList getTradeList() {
        return this.tradeList;
    }

    @Override
    public boolean isWorldGen() {
        return this.worldGen;
    }

    @Override
    public void onNetworkEvent(int event) {
        if (event == 0) {
            IC2.audioManager.playOnce(this, PositionSpec.Center, Ic2Sounds.tradeSound, true, IC2.audioManager.defaultVolume);
        }
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        if (event == 0) {
            this.sync.moveTrade(player, -1);
        } else if (event == 1) {
            this.sync.moveTrade(player, 1);
        } else if (event == 2) {
            this.tradeList.removeSave(this.tradeList.indexOf(this.sync.getServerTrade(player)));
            this.sync.markAllDirty();
        }
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, INetworkFieldData data) {
        if (player == null) {
            return;
        }
        if (data instanceof NBTFieldPacket) {
            this.getSyncer().receivePacket(player, (NBTFieldPacket)data);
        }
    }

    protected void removeSubTrade(EntityPlayer player, int subID) {
        ITrade trade = this.tradeList.getTradeSave(this.tradeList.indexOf(this.sync.getServerTrade(player)));
        if (trade == null || !(trade instanceof IModifyableTrade)) {
            return;
        }
        List<ISubTrade> sub = trade.getSubTrades(this.getOwner(), false);
        if (sub.size() <= subID || sub.size() <= 1) {
            return;
        }
        ((IModifyableTrade)trade).deleteSubTrade(sub.get(subID));
        this.sync.updateAll();
    }

    @Override
    public boolean canRemoveBlock(EntityPlayer player) {
        return this.isOwner(player.func_110124_au());
    }

    @Override
    public boolean canSetFacing(EntityPlayer player, EnumFacing facing) {
        return this.isOwner(player.func_110124_au()) && facing != this.getFacing();
    }

    private boolean isOwner(UUID player) {
        UUID owner = this.getOwner();
        return owner == null || owner.equals(player);
    }

    @Override
    public List<ItemStack> generateCoins(int moneyValue) {
        if (moneyValue <= 0) {
            return new ArrayList<ItemStack>();
        }
        return ItemIC2Coin.generateCoins(moneyValue);
    }
}

