/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.misc;

import ic2.core.IC2;
import ic2.core.block.misc.tile.TileEntityBarrel;
import ic2.core.platform.lang.ILocaleBlock;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.platform.textures.obj.ITexturedBlock;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IBlockStateLoader;
import ic2.core.util.obj.IBootable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBarrel
extends BlockContainer
implements ITexturedBlock,
IBlockStateLoader,
IBootable,
ILocaleBlock {
    public static PropertyDirection allFacings = PropertyDirection.func_177713_a((String)"facing", Arrays.asList(EnumFacing.field_176754_o));
    public static PropertyBool tabbed = PropertyBool.func_177716_a((String)"tabbed");

    public BlockBarrel() {
        super(Material.field_151575_d);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149663_c("blockBarrel");
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)tabbed, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)allFacings, (Comparable)EnumFacing.NORTH));
        this.setHarvestLevel("axe", 0);
    }

    public String func_149739_a() {
        return this.getName().getUnlocalized();
    }

    public String func_149732_F() {
        return this.getName().getLocalized();
    }

    @Override
    public LocaleComp getName() {
        return Ic2BlockLang.barrel;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{allFacings, tabbed});
    }

    @Override
    public void onLoad() {
        Ic2States.barrel = this.func_176203_a(0);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityBarrel();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public AxisAlignedBB getRenderBoundingBox(IBlockState state) {
        return field_185505_j;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureFromState(IBlockState state, EnumFacing side) {
        if (((Boolean)state.func_177229_b((IProperty)tabbed)).booleanValue() && state.func_177229_b((IProperty)allFacings) == side) {
            return Ic2Icons.getTextures("b0")[29];
        }
        if (side.func_176740_k().func_176722_c()) {
            return Ic2Icons.getTextures("b0")[44];
        }
        return Ic2Icons.getTextures("b0")[28];
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getParticleTexture(IBlockState state) {
        return Ic2Icons.getTextures("b0")[44];
    }

    @Override
    public List<IBlockState> getValidStates() {
        return this.func_176194_O().func_177619_a();
    }

    @Override
    public IBlockState getStateFromStack(ItemStack stack) {
        return null;
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        if (meta == 0) {
            return state;
        }
        return state.func_177226_a((IProperty)tabbed, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)allFacings, (Comparable)EnumFacing.func_176731_b((int)(meta - 1)));
    }

    public int func_176201_c(IBlockState state) {
        if (!((Boolean)state.func_177229_b((IProperty)tabbed)).booleanValue()) {
            return 0;
        }
        return 1 + ((EnumFacing)state.func_177229_b((IProperty)allFacings)).func_176736_b();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityBarrel) {
            return ((TileEntityBarrel)tile).getBarrelStack();
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(Ic2Items.woodenScaffold.func_77946_l());
        list.add(Ic2Items.barrel.func_77946_l());
        return list;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (!(tile instanceof TileEntityBarrel)) {
            return false;
        }
        TileEntityBarrel barrel = (TileEntityBarrel)tile;
        ItemStack stack = playerIn.func_184586_b(hand);
        if (StackUtil.isStackEqual(stack, Ic2Items.emptyMug)) {
            int want;
            if (barrel.treeTabSide != -1 && facing.func_176736_b() == barrel.treeTabSide && !worldIn.field_72995_K && (want = Math.min(barrel.getStoredAmount(), playerIn.func_70093_af() ? Math.min(16, stack.func_190916_E()) : 1)) > 0) {
                ItemStack drained = barrel.drainAmount(want);
                stack.func_190918_g(want);
                if (!playerIn.field_71071_by.func_70441_a(drained)) {
                    StackUtil.dropAsEntity(worldIn, playerIn.func_180425_c(), drained);
                }
                return true;
            }
            return true;
        }
        return barrel.onRigthClick(playerIn, hand);
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (!(tile instanceof TileEntityBarrel)) {
            return;
        }
        TileEntityBarrel barrel = (TileEntityBarrel)tile;
        if (barrel.treeTabSide >= 0) {
            barrel.treeTabSide = -1;
            barrel.updateBlock();
            barrel.drainAmount(1);
            if (IC2.platform.isSimulating()) {
                StackUtil.dropAsEntity(worldIn, pos, Ic2Items.treeTap.func_77946_l());
            }
            return;
        }
        if (IC2.platform.isSimulating()) {
            StackUtil.dropAsEntity(worldIn, pos, barrel.getBarrelStack());
        }
        worldIn.func_175656_a(pos, Ic2States.woodenScaffold);
    }

    @Override
    public List<IBlockState> getValidStates(IBlockState defaultState) {
        this.func_180632_j(defaultState.func_177226_a((IProperty)tabbed, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)allFacings, (Comparable)EnumFacing.NORTH));
        ArrayList<IBlockState> states = new ArrayList<IBlockState>();
        for (int i = 0; i < 6; ++i) {
            states.add(this.func_176203_a(i));
        }
        return states;
    }

    @Deprecated
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof TileEntityBarrel) {
            TileEntityBarrel barrel = (TileEntityBarrel)tile;
            state = barrel.treeTabSide == -1 ? state.func_177226_a((IProperty)tabbed, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)allFacings, (Comparable)EnumFacing.NORTH) : state.func_177226_a((IProperty)tabbed, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)allFacings, (Comparable)EnumFacing.func_176731_b((int)barrel.treeTabSide));
        }
        return state;
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
    }
}

