/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.recipes.entries;

import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.core.platform.registry.Ic2Items;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ScrapOutput
extends MachineOutput {
    double boost;

    public ScrapOutput() {
        super(ScrapOutput.create(), new ArrayList<ItemStack>());
    }

    private static NBTTagCompound create() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("consume_containers", true);
        return nbt;
    }

    @Override
    public List<ItemStack> getRecipeOutput(Random rand, NBTTagCompound subData) {
        ItemStack stack;
        int chance = Math.max(1, this.getBaseChance() - (int)this.boost);
        if (rand.nextInt(chance) == 0 && (stack = this.getItem(rand)).func_190916_E() > 0) {
            return Arrays.asList(stack);
        }
        return new ArrayList<ItemStack>();
    }

    @Override
    public List<ItemStack> getAllOutputs() {
        return Arrays.asList(this.getItem(null));
    }

    @Override
    public boolean canApplyEfficiency(MachineOutput.EfficiencyType type, MachineOutput.EfficiencyEffect effect) {
        return effect != MachineOutput.EfficiencyEffect.SubProducts;
    }

    @Override
    public void applyEfficiency(MachineOutput.EfficiencyType type, MachineOutput.EfficiencyEffect effect, int amount) {
        this.boost = type != MachineOutput.EfficiencyType.Technology ? (this.boost += (double)(amount / 2)) : (this.boost += (double)(amount * 2));
    }

    @Override
    public MachineOutput copy() {
        return new ScrapOutput();
    }

    public int getBaseChance() {
        return 8;
    }

    public ItemStack getItem(Random rand) {
        return Ic2Items.scrap.func_77946_l();
    }

    @Override
    public boolean canOverride() {
        return false;
    }
}

