/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low.logic.miner;

import ic2.core.block.machine.low.TileEntityMiner;
import ic2.core.block.machine.low.logic.miner.IMiningTarget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;

public class NormalMiningTarget
implements IMiningTarget {
    IBlockState state;
    BlockPos pos;
    List<ItemStack> drops = new ArrayList<ItemStack>();

    public NormalMiningTarget() {
    }

    public NormalMiningTarget(IBlockState state, BlockPos pos) {
        this.state = state;
        this.pos = pos;
    }

    @Override
    public BlockPos getTargetPos() {
        return this.pos;
    }

    @Override
    public IBlockState getMemoryState() {
        return this.state;
    }

    @Override
    public boolean validateTarget(TileEntityMiner miner) {
        return miner.func_145831_w().func_180495_p(this.pos) == this.state;
    }

    @Override
    public boolean canMine(TileEntityMiner miner) {
        try {
            return miner.canMine(this.pos, this.state);
        }
        catch (Exception e) {
            this.state = miner.func_145831_w().func_180495_p(this.pos);
            return this.canMine(miner);
        }
    }

    @Override
    public boolean canContinue(TileEntityMiner miner) {
        return true;
    }

    @Override
    public void createDrops(TileEntityMiner miner) {
        this.drops = new ArrayList<ItemStack>();
        World world = miner.func_145831_w();
        IBlockState state = world.func_180495_p(this.pos);
        FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world));
        if (this.hasEnchantment((ItemStack)miner.inventory.get(3), Enchantments.field_185306_r) && state.func_177230_c().canSilkHarvest(world, this.pos, state, (EntityPlayer)fakePlayer)) {
            ArrayList<ItemStack> result = new ArrayList<ItemStack>();
            ItemStack stack = this.createStackBlock(state);
            if (stack != null) {
                result.add(stack);
            }
            ForgeEventFactory.fireBlockHarvesting(result, (World)world, (BlockPos)this.pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)fakePlayer);
            this.drops.addAll(result);
        } else {
            int fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)((ItemStack)miner.inventory.get(3)));
            List result = state.func_177230_c().getDrops((IBlockAccess)world, this.pos, state, fortune);
            ForgeEventFactory.fireBlockHarvesting((List)result, (World)world, (BlockPos)this.pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)fakePlayer);
            this.drops.addAll(result);
        }
    }

    public boolean hasEnchantment(ItemStack stack, Enchantment ench) {
        return EnchantmentHelper.func_77506_a((Enchantment)ench, (ItemStack)stack) > 0;
    }

    public ItemStack createStackBlock(IBlockState state) {
        Item item = Item.func_150898_a((Block)state.func_177230_c());
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        int i = 0;
        if (item.func_77614_k()) {
            i = state.func_177230_c().func_176201_c(state);
        }
        return new ItemStack(item, 1, i);
    }

    @Override
    public List<ItemStack> getDrops() {
        return this.drops;
    }

    @Override
    public NBTTagCompound save() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("BlockID", this.state.func_177230_c().getRegistryName().toString());
        nbt.func_74768_a("Metadata", this.state.func_177230_c().func_176201_c(this.state));
        nbt.func_74772_a("Location", this.pos.func_177986_g());
        return nbt;
    }

    @Override
    public boolean loadFromNBT(NBTTagCompound nbt) {
        Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(nbt.func_74779_i("BlockID")));
        if (block == Blocks.field_150350_a || block == null) {
            return false;
        }
        this.pos = BlockPos.func_177969_a((long)nbt.func_74763_f("Location"));
        this.state = block.func_176203_a(nbt.func_74762_e("Metadata"));
        return true;
    }

    @Override
    public byte getID() {
        return 1;
    }
}

