/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low.logic.crafter;

import ic2.api.classic.network.INetworkFieldData;
import ic2.api.classic.network.adv.IInputBuffer;
import ic2.api.classic.network.adv.IOutputBuffer;
import ic2.core.block.machine.low.TileEntityIndustrialWorktable;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.filters.IFilter;
import ic2.core.inventory.filters.SpecialItemFilter;
import ic2.core.util.misc.StackUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;

public class CraftingRecipe
implements INetworkFieldData {
    NonNullList<ItemStack> displayItems = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    boolean oreDict;
    boolean nbtData;
    boolean ignoreDurability;
    IRecipe recipe;
    ItemStack outputDisplay = ItemStack.field_190927_a;
    boolean valid = false;
    Map<IFilter, int[]> filters;

    public CraftingRecipe copy() {
        CraftingRecipe result = new CraftingRecipe();
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        result.readFromNBT(nbt.func_74737_b());
        return result;
    }

    public boolean validate(World world) {
        boolean bl = this.valid = this.getRecipe(world) != null;
        if (this.valid) {
            this.outputDisplay = this.getRecipe(world).func_77571_b().func_77946_l();
            this.getFilters();
        }
        return this.valid;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.displayItems = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
        this.nbtData = false;
        this.oreDict = false;
        this.outputDisplay = ItemStack.field_190927_a;
        this.clearFilters();
        this.valid = nbt.func_74767_n("isValid");
        if (!this.valid) {
            return;
        }
        this.oreDict = nbt.func_74767_n("OreDict");
        this.nbtData = nbt.func_74767_n("NBT");
        this.ignoreDurability = nbt.func_74767_n("Damage");
        NBTTagList list = nbt.func_150295_c("Input", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            ItemStack stack = new ItemStack(data);
            this.displayItems.set(data.func_74762_e("Index"), (Object)stack);
            if (!stack.func_190926_b()) continue;
            this.valid = false;
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("isValid", this.valid);
        if (!this.valid) {
            return;
        }
        nbt.func_74757_a("OreDict", this.oreDict);
        nbt.func_74757_a("NBT", this.nbtData);
        nbt.func_74757_a("Damage", this.ignoreDurability);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < 9; ++i) {
            if (((ItemStack)this.displayItems.get(i)).func_190926_b()) continue;
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("Index", (byte)i);
            ((ItemStack)this.displayItems.get(i)).func_77955_b(data);
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("Input", (NBTBase)list);
    }

    @Override
    public void read(IInputBuffer buffer) {
        this.ignoreDurability = buffer.readBoolean();
        this.nbtData = buffer.readBoolean();
        this.oreDict = buffer.readBoolean();
    }

    @Override
    public void write(IOutputBuffer buffer) {
        buffer.writeBoolean(this.ignoreDurability);
        buffer.writeBoolean(this.nbtData);
        buffer.writeBoolean(this.oreDict);
    }

    public boolean isValidRecipe() {
        return this.valid;
    }

    public boolean useNBT() {
        return this.nbtData;
    }

    public boolean useOreDict() {
        return this.oreDict;
    }

    public boolean ignoreDurability() {
        return this.ignoreDurability;
    }

    public void clearRecipe() {
        this.recipe = null;
    }

    public void changeValue(int value) {
        if (value == 0) {
            this.nbtData = !this.nbtData;
        } else if (value == 1) {
            this.oreDict = !this.oreDict;
        } else if (value == 2) {
            this.ignoreDurability = !this.ignoreDurability;
        }
        this.filters = null;
        this.getFilters();
    }

    public Map<IFilter, int[]> getFilters() {
        if (this.filters == null) {
            this.filters = new LinkedHashMap<IFilter, int[]>();
            for (int i = 0; i < 9; ++i) {
                if (((ItemStack)this.displayItems.get(i)).func_190926_b()) continue;
                boolean damageable = ((ItemStack)this.displayItems.get(i)).func_77984_f() && this.ignoreDurability;
                this.filters.put(new SpecialItemFilter(damageable ? StackUtil.copyWithWildCard((ItemStack)this.displayItems.get(i)) : (ItemStack)this.displayItems.get(i), true, this.nbtData, this.oreDict), new int[]{i, ((ItemStack)this.displayItems.get(i)).func_190916_E()});
            }
        }
        return this.filters;
    }

    public void clearFilters() {
        if (this.filters != null) {
            this.filters = null;
        }
    }

    public void clear() {
        for (int i = 0; i < 9; ++i) {
            this.displayItems.set(i, (Object)ItemStack.field_190927_a);
        }
        this.clearFilters();
        this.recipe = null;
        this.outputDisplay = ItemStack.field_190927_a;
        this.valid = false;
    }

    public void validate(IRecipe recipe, IHasInventory inv) {
        for (int i = 0; i < 9; ++i) {
            this.displayItems.set(i, (Object)inv.getStackInSlot(i).func_77946_l());
        }
        this.recipe = recipe;
        this.valid = true;
        this.clearFilters();
        this.outputDisplay = recipe.func_77571_b().func_77946_l();
    }

    public void applyTo(IHasInventory inv, World world) {
        for (int i = 0; i < 9; ++i) {
            inv.setStackInSlot(i, ((ItemStack)this.displayItems.get(i)).func_77946_l());
        }
        inv.setStackInSlot(9, this.getFakeOutput(world).func_77946_l());
    }

    public ItemStack getFakeOutput(World world) {
        InventoryCrafting craft = TileEntityIndustrialWorktable.crafting;
        craft.func_174888_l();
        for (int i = 0; i < 9; ++i) {
            craft.func_70299_a(i, ((ItemStack)this.displayItems.get(i)).func_77946_l());
        }
        ItemStack result = this.getOutput(craft, world).func_77946_l();
        craft.func_174888_l();
        return result;
    }

    public ItemStack getOutput(InventoryCrafting crafting, World world) {
        IRecipe entry = this.getRecipe(world);
        if (entry != null && entry.func_77569_a(crafting, world)) {
            return entry.func_77572_b(crafting).func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public IRecipe getRecipe(World world) {
        if (!this.valid) {
            return null;
        }
        if (this.recipe == null) {
            this.recipe = this.findMatchingRecipe(world);
        }
        return this.recipe;
    }

    public NonNullList<ItemStack> getRemainingItems(InventoryCrafting crafting, World world) {
        IRecipe entry = this.getRecipe(world);
        if (entry != null && entry.func_77569_a(crafting, world)) {
            return entry.func_179532_b(crafting);
        }
        return NonNullList.func_191196_a();
    }

    public IRecipe findMatchingRecipe(World world) {
        InventoryCrafting crafting = new InventoryCrafting(new Container(){

            public boolean func_75145_c(EntityPlayer playerIn) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            crafting.func_70299_a(i, ((ItemStack)this.displayItems.get(i)).func_77946_l());
        }
        for (IRecipe recipe : CraftingManager.field_193380_a) {
            if (!recipe.func_77569_a(crafting, world)) continue;
            return recipe;
        }
        return null;
    }

    public ItemStack getDisplayItem() {
        return this.outputDisplay;
    }

    public String getDisplayName() {
        return this.outputDisplay == null ? "Unknown Item" : this.outputDisplay.func_82833_r();
    }

    public String getDisplayItemName(int index) {
        ItemStack stack = (ItemStack)this.displayItems.get(index);
        if (stack.func_190926_b()) {
            return "Unknown Item";
        }
        return stack.func_82833_r();
    }
}

