/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low;

import com.google.common.base.Strings;
import ic2.api.classic.crops.ClassicCrops;
import ic2.api.classic.network.INetworkClientTileEventListener;
import ic2.api.classic.network.adv.IBitLevelOverride;
import ic2.api.classic.network.adv.NetworkField;
import ic2.api.crops.CropCard;
import ic2.api.crops.Crops;
import ic2.api.crops.ICropSeed;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.block.crop.Ic2Crops;
import ic2.core.block.machine.low.container.ContainerSeedManager;
import ic2.core.block.machine.low.logic.crops.CropSorters;
import ic2.core.block.machine.low.logic.crops.CropTypeSyncer;
import ic2.core.block.machine.low.logic.crops.SeedEntry;
import ic2.core.block.machine.low.logic.crops.SeedStorage;
import ic2.core.block.machine.med.logic.encoder.ByteShifter;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.inventory.transport.TransporterManager;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySeedManager
extends TileEntityElecMachine
implements INetworkClientTileEventListener,
IHasGui,
ITickable,
IBitLevelOverride {
    public SeedStorage storage = new SeedStorage();
    public List<CropCard> crops = new ArrayList<CropCard>();
    @NetworkField(index=12)
    public CropTypeSyncer syncer = new CropTypeSyncer();
    @NetworkField(index=7)
    public int currentIndex = 0;
    @NetworkField(index=8)
    public int currentID = -1;
    @NetworkField(index=9)
    public boolean sorting;
    @NetworkField(index=10, compression=NetworkField.BitLevel.Bit8)
    public String comparator = "";
    @NetworkField(index=11)
    public boolean inverted;

    public TileEntitySeedManager() {
        super(4, 32);
        this.addGuiFields("currentID", "comparator", "sorting", "inverted", "currentIndex", "syncer");
        this.maxEnergy = 10000;
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        int[] slots = new int[]{0, 1, 2, 3};
        handler.registerDefaultSideAccess(AccessRule.Import, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Import, slots);
        handler.registerDefaultSlotsForSide(RotationList.ALL, slots);
        handler.registerInputFilter(CommonFilters.SeedFilterScanned, slots);
        handler.registerSlotType(SlotType.Input, slots);
    }

    @Override
    public NetworkField.BitLevel getOverride(int fieldID, String fieldName) {
        return NetworkField.BitLevel.Bit16;
    }

    @Override
    public boolean hasOverride(int fieldID, String fieldName) {
        return fieldID == 3 || fieldID == 4;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.currentID = nbt.func_74762_e("CurrentID");
        this.comparator = nbt.func_74779_i("Comparator");
        this.sorting = nbt.func_74767_n("Sorting");
        this.inverted = nbt.func_74767_n("Inverted");
        this.storage.readFromNBT(nbt.func_74775_l("Storage"));
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("Storage", (NBTBase)this.storage.writeToNBT());
        nbt.func_74778_a("Comparator", this.comparator);
        nbt.func_74768_a("CurrentID", this.currentID);
        nbt.func_74757_a("Sorting", this.sorting);
        nbt.func_74757_a("Inverted", this.inverted);
        return nbt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiFieldSynced(String field) {
        GuiScreen screen;
        if (field.equals("sorting") && (screen = Minecraft.func_71410_x().field_71462_r) instanceof GuiIC2) {
            ((GuiIC2)screen).requestGuiReload();
        }
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.cropLibrary;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.crops.add(null);
        this.crops.addAll(ClassicCrops.instance.getCrops());
        this.crops.remove(Ic2Crops.weed);
        if (this.currentID == -1) {
            this.currentID = this.storage.getFirstWithIndex(this.crops);
            this.getNetwork().updateTileGuiField(this, "currentID");
        } else if (!this.storage.contains(this.getCurrentCrop())) {
            this.currentID = 0;
            this.getNetwork().updateTileGuiField(this, "currentID");
        }
        if (!this.storage.contains(null)) {
            this.storage.updateNull();
            this.storage.addSingleWork(null);
        }
        if (Strings.isNullOrEmpty((String)this.comparator)) {
            this.comparator = CropSorters.instance.getNextEntry(this.comparator);
        }
        this.storage.updateDisplay(this.getCurrentCrop());
        this.updateDisplayCrops();
    }

    public void updateDisplayCrops() {
        LinkedList<CropCard> cards = new LinkedList<CropCard>(this.crops);
        LinkedHashSet<CropCard> keep = new LinkedHashSet<CropCard>(this.storage.getCards());
        keep.add(null);
        cards.retainAll(keep);
        this.syncer.addCrops(cards);
        this.getNetwork().updateTileGuiField(this, "syncer");
    }

    public Comparator<SeedEntry> getSorter() {
        if (this.sorting) {
            return CropSorters.instance.getComparator(this.comparator);
        }
        return null;
    }

    public CropCard getCurrentCrop() {
        if (this.currentID < 0 || this.currentID >= this.crops.size()) {
            this.currentID = 0;
        }
        if (this.currentID < this.crops.size()) {
            return this.crops.get(this.currentID);
        }
        return Crops.weed;
    }

    @Override
    public boolean supportsNotify() {
        return false;
    }

    public void func_73660_a() {
        if (this.hasEnergy(1)) {
            this.useEnergy(1);
            if (this.storage.enable()) {
                this.storage.updateDisplay(this.getCurrentCrop());
            }
            if (this.storage.hasWork()) {
                CropCard card = this.getCurrentCrop();
                if (this.storage.processWork(this.getSorter(), this.inverted, card)) {
                    this.storage.updateDisplay(card);
                }
            }
            this.setActive(true);
        } else {
            this.storage.dissable();
            this.setActive(false);
        }
        if (this.field_145850_b.func_82737_E() % 5L == 0L && this.hasEnergy(20)) {
            CropCard currentCard = this.getCurrentCrop();
            boolean update = false;
            for (int i = 0; i < 4; ++i) {
                Tuple<CropCard, SeedEntry> seed = this.getValidCrop((ItemStack)this.inventory.get(i));
                if (seed == null || !this.storage.storeSeeds(seed)) continue;
                this.inventory.set(i, (Object)ItemStack.field_190927_a);
                if (currentCard == seed.func_76341_a() || currentCard == null) {
                    this.storage.addSingleWork(currentCard);
                    update = true;
                }
                if ("StatAmount".equals(this.comparator)) {
                    this.storage.addSingleWork((CropCard)seed.func_76341_a());
                    this.storage.addSingleWork(null);
                }
                this.useEnergy(5);
            }
            if (update) {
                this.storage.updateDisplay(currentCard);
                this.updateDisplayCrops();
            }
        }
    }

    private Tuple<CropCard, SeedEntry> getValidCrop(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ICropSeed)) {
            return null;
        }
        ICropSeed seed = (ICropSeed)stack.func_77973_b();
        if (seed.getScannedFromStack(stack) >= 4) {
            CropCard card = seed.getCropFromStack(stack);
            if (card != null) {
                return new Tuple((Object)card, (Object)new SeedEntry(seed.getGrowthFromStack(stack), seed.getGainFromStack(stack), seed.getResistanceFromStack(stack), stack.func_190916_E()));
            }
            return null;
        }
        return null;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event, int value) {
        if (event == 0) {
            this.currentIndex = MathHelper.func_76125_a((int)(this.currentIndex + value), (int)0, (int)Math.max(0, this.syncer.size() / 5));
            this.getNetwork().updateTileGuiField(this, "currentIndex");
        } else if (event == 1) {
            this.currentID = this.crops.indexOf(this.syncer.getEntry(this.currentIndex * 5 + value).func_76340_b());
            this.getNetwork().updateTileGuiField(this, "currentID");
            this.storage.clearOffset();
            this.storage.updateDisplay(this.getCurrentCrop());
            player.field_71070_bA.func_75142_b();
        } else if (event == 2) {
            this.storage.moveOffset(this.getCurrentCrop(), value);
            this.storage.updateDisplay(this.getCurrentCrop());
            player.field_71070_bA.func_75142_b();
        } else if (event == 3) {
            ItemStack result;
            ByteShifter shifter = new ByteShifter(value);
            int slot = shifter.readInt(5);
            int amount = shifter.readInt(7);
            CropCard current = this.getCurrentCrop();
            ItemStack stack = this.storage.drain(current, slot, amount, false);
            if (!stack.func_190926_b() && (result = TransporterManager.manager.getTransporter(player, true).addItem(stack.func_77946_l(), EnumFacing.DOWN, true)).func_190916_E() > 0) {
                this.storage.drain(current, slot, result.func_190916_E(), true);
                this.storage.addSingleWork(current);
                this.storage.updateDisplay(current);
                player.field_71070_bA.func_75142_b();
                this.updateDisplayCrops();
                this.currentIndex = MathHelper.func_76125_a((int)this.currentIndex, (int)0, (int)Math.max(0, this.syncer.size() / 5));
                this.getNetwork().updateTileGuiField(this, "currentIndex");
            }
        } else if (event == 4) {
            if (value == 0) {
                this.sorting = !this.sorting;
                this.getNetwork().updateTileGuiField(this, "sorting");
            } else if (value == 1) {
                this.inverted = !this.inverted;
                this.getNetwork().updateTileGuiField(this, "inverted");
                this.storage.addWork(this.crops);
                this.storage.addSingleWork(null);
                this.storage.addSingleWorkFirst(this.getCurrentCrop());
            }
        } else if (event == 5) {
            this.comparator = CropSorters.instance.getNextEntry(this.comparator);
            this.getNetwork().updateTileGuiField(this, "comparator");
            this.storage.addWork(this.crops);
            this.storage.addSingleWork(null);
            this.storage.addSingleWorkFirst(this.getCurrentCrop());
        }
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerSeedManager(this, player.field_71071_by);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }
}

