/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.low;

import ic2.api.classic.network.adv.IBitLevelOverride;
import ic2.api.classic.network.adv.NetworkField;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityElecMachine;
import ic2.core.block.crop.TileEntityCrop;
import ic2.core.block.machine.low.container.ContainerCropmatron;
import ic2.core.fluid.IC2Tank;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.util.helpers.ToolHelper;
import ic2.core.util.math.MathUtil;
import ic2.core.util.misc.StackUtil;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TileEntityCropmatron
extends TileEntityElecMachine
implements ITickable,
IHasGui,
IFluidHandler,
IBitLevelOverride {
    public IC2Tank waterTank = new IC2Tank(16000);
    public int scanX = -4;
    public int scanY = -2;
    public int scanZ = -4;
    public Set<BlockPos> farmlands = new LinkedHashSet<BlockPos>();

    public TileEntityCropmatron() {
        super(9, 32);
        this.maxEnergy = 1000;
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        int[] array = MathUtil.fromTo(0, 9);
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Import, array);
        handler.registerDefaultSlotsForSide(RotationList.VERTICAL, 0, 1, 2);
        handler.registerDefaultSlotsForSide(RotationList.X_AXIS, 3, 4, 5);
        handler.registerDefaultSlotsForSide(RotationList.Z_AXIS, 6, 7, 8);
        handler.registerInputFilter(CommonFilters.Fertilizer, 0, 1, 2);
        handler.registerInputFilter(CommonFilters.Hydration, 3, 4, 5);
        handler.registerInputFilter(CommonFilters.WeedEx, 6, 7, 8);
        handler.registerSlotType(SlotType.Fertilzer, 0, 1, 2);
        handler.registerSlotType(SlotType.Hydration, 3, 4, 5);
        handler.registerSlotType(SlotType.WeedEx, 6, 7, 8);
    }

    @Override
    public NetworkField.BitLevel getOverride(int fieldID, String fieldName) {
        return NetworkField.BitLevel.Bit16;
    }

    @Override
    public boolean hasOverride(int fieldID, String fieldName) {
        return fieldID == 3 || fieldID == 4;
    }

    @Override
    public boolean supportsNotify() {
        return false;
    }

    public void func_73660_a() {
        if (this.energy >= 41) {
            this.scan();
        }
    }

    public void scan() {
        Iterator<BlockPos> iter;
        ++this.scanX;
        if (this.scanX > 4) {
            this.scanX = -4;
            ++this.scanZ;
            if (this.scanZ > 4) {
                this.scanZ = -4;
                ++this.scanY;
                if (this.scanY > 2) {
                    this.scanY = -2;
                }
            }
        }
        this.useEnergy(1);
        if (this.farmlands.size() > 0 && this.waterTank.getFluidAmount() >= 1000 && (iter = this.farmlands.iterator()).hasNext()) {
            BlockPos target = iter.next();
            iter.remove();
            IBlockState below = this.field_145850_b.func_180495_p(target);
            if (below.func_177230_c() == Blocks.field_150458_ak) {
                int needed = 7 - (Integer)below.func_177229_b((IProperty)BlockFarmland.field_176531_a);
                if (needed > 0) {
                    this.waterTank.drain(100 * needed, true);
                    this.field_145850_b.func_180501_a(target, below.func_177226_a((IProperty)BlockFarmland.field_176531_a, (Comparable)Integer.valueOf(7)), 2);
                    this.useEnergy(10);
                }
                this.farmlands.add(target);
            }
        }
        BlockPos targetPos = this.func_174877_v().func_177982_a(this.scanX, this.scanY, this.scanZ);
        TileEntity tile = this.func_145831_w().func_175625_s(targetPos);
        if (tile instanceof TileEntityCrop) {
            TileEntityCrop crop = (TileEntityCrop)tile;
            this.farmlands.add(tile.func_174877_v().func_177977_b());
            if (StackUtil.isStackEqual((ItemStack)this.inventory.get(0), Ic2Items.fertilizer) && crop.applyFertilizer(false)) {
                this.useEnergy(10);
                ((ItemStack)this.inventory.get(0)).func_190918_g(1);
                this.checkStackSizeZero(0);
            }
            if (((ItemStack)this.inventory.get(3)).func_77973_b() == Ic2Items.hydrationCell.func_77973_b() && crop.applyAutomatedHyrdation((ItemStack)this.inventory.get(3))) {
                this.useEnergy(10);
                this.refillFromTank();
                this.checkStackSizeZero(3);
            }
            if (((ItemStack)this.inventory.get(6)).func_77973_b() == Ic2Items.weedEx.func_77973_b() && crop.applyWeedEx(false)) {
                this.useEnergy(10);
                if (ToolHelper.damageItem((ItemStack)this.inventory.get(6), 1, null)) {
                    ((ItemStack)this.inventory.get(6)).func_190918_g(1);
                    this.checkStackSizeZero(6);
                }
            }
        } else {
            this.farmlands.remove(targetPos);
            this.farmlands.remove(targetPos.func_177977_b());
        }
    }

    public void refillFromTank() {
        FluidStack drained;
        int room = ToolHelper.getDamage((ItemStack)this.inventory.get(3));
        if (room > 0 && (drained = this.waterTank.drain(room, true)) != null && drained.amount > 0) {
            ToolHelper.setDamage((ItemStack)this.inventory.get(3), room - drained.amount);
        }
    }

    public void checkStackSizeZero(int x) {
        this.sortSlot(x, x + 1);
        this.sortSlot(x + 1, x + 2);
    }

    public void sortSlot(int to, int from) {
        if (((ItemStack)this.inventory.get(to)).func_190926_b() && !((ItemStack)this.inventory.get(from)).func_190926_b()) {
            this.inventory.set(to, this.inventory.get(from));
            this.inventory.set(from, (Object)ItemStack.field_190927_a);
        } else if (StackUtil.isStackEqual((ItemStack)this.inventory.get(to), (ItemStack)this.inventory.get(from), false, false)) {
            int left = ((ItemStack)this.inventory.get(to)).func_77976_d() - ((ItemStack)this.inventory.get(to)).func_190916_E();
            if (left <= 0) {
                return;
            }
            if (left >= ((ItemStack)this.inventory.get(from)).func_190916_E()) {
                ((ItemStack)this.inventory.get(to)).func_190917_f(((ItemStack)this.inventory.get(from)).func_190916_E());
                this.inventory.set(from, (Object)ItemStack.field_190927_a);
            } else {
                ((ItemStack)this.inventory.get(to)).func_190920_e(((ItemStack)this.inventory.get(to)).func_77976_d());
                ((ItemStack)this.inventory.get(from)).func_190918_g(from);
            }
        }
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerCropmatron(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.cropmatron;
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.waterTank.getTankProperties();
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && resource.getFluid() == FluidRegistry.WATER) {
            return this.waterTank.fill(resource, doFill);
        }
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.waterTank;
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagList list = new NBTTagList();
        for (BlockPos pos : this.farmlands) {
            list.func_74742_a((NBTBase)new NBTTagLong(pos.func_177986_g()));
        }
        nbt.func_74782_a("Farmlands", (NBTBase)list);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.farmlands.clear();
        NBTTagList list = nbt.func_150295_c("Farmlands", 4);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            this.farmlands.add(BlockPos.func_177969_a((long)((NBTTagLong)list.func_179238_g(i)).func_150291_c()));
        }
    }
}

