/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.high.logic.terraformer;

import ic2.api.item.ITerraformingBP;
import ic2.core.RotationList;
import ic2.core.block.machine.high.TileEntityTerraformer;
import ic2.core.block.machine.high.logic.terraformer.ITerraformerLogic;
import ic2.core.util.helpers.AabbUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class NewTerraformLogic
implements ITerraformerLogic {
    int lastRange = -1;
    LinkedList<BlockPos> workList = new LinkedList();
    Set<BlockPos> bigRange = new LinkedHashSet<BlockPos>();

    @Override
    public void reset() {
        this.lastRange = -1;
        this.workList.clear();
        this.bigRange.clear();
    }

    @Override
    public boolean canRun() {
        return this.lastRange == -1 || this.workList.size() > 0 || this.bigRange.size() > 0;
    }

    @Override
    public boolean work(World world, BlockPos pos, ItemStack bluePrint, ITerraformingBP bp) {
        int newRange = bp.getRange(bluePrint);
        if (this.lastRange != newRange) {
            this.init(newRange, world, pos);
            return false;
        }
        if (this.workList.size() > 0) {
            BlockPos target = this.workList.poll();
            if (bp.terraform(bluePrint, world, target)) {
                this.workList.addLast(target);
                return true;
            }
            return false;
        }
        if (this.bigRange.size() > 0) {
            this.workList.addAll(this.bigRange);
            this.bigRange.clear();
            Collections.shuffle(this.workList);
        }
        return false;
    }

    public void init(int newRange, World world, BlockPos pos) {
        this.reset();
        this.lastRange = newRange;
        this.workList.addAll(AabbUtil.getTargets(world, pos, new AabbUtil.BoundingBox(pos, Math.max(1, newRange / 10)), TileEntityTerraformer.AnyFilter.filter, true, true, false, RotationList.HORIZONTAL));
        this.bigRange.addAll(AabbUtil.getTargets(world, pos, new AabbUtil.BoundingBox(pos, newRange), TileEntityTerraformer.AnyFilter.filter, true, true, false, RotationList.HORIZONTAL));
        this.bigRange.removeAll(this.workList);
        Collections.shuffle(this.workList);
    }
}

