/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tile;

import ic2.api.classic.network.adv.NetworkField;
import ic2.core.IC2;
import ic2.core.RotationList;
import ic2.core.block.base.tile.TileEntityFuelGeneratorBase;
import ic2.core.block.generator.container.ContainerThermalGenerator;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.filters.CommonFilters;
import ic2.core.inventory.filters.FluidFilter;
import ic2.core.inventory.filters.InvertedFilter;
import ic2.core.inventory.management.AccessRule;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.inventory.management.SlotType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2BlockLang;
import ic2.core.platform.registry.Ic2GuiComp;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Resources;
import ic2.core.util.helpers.AabbUtil;
import ic2.core.util.math.Box2D;
import ic2.core.util.misc.FluidHelper;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.IClickable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityThermalGenerator
extends TileEntityFuelGeneratorBase
implements IFluidHandler,
IClickable {
    public static AabbUtil.IBlockFilter filter = new ThermalFilter();
    public static int maxLava = 30000;
    @NetworkField(index=7, compression=NetworkField.BitLevel.Bit24)
    public int heatPoints = -1;
    public float generatedEU = 0.0f;
    public int config;
    public float passiveConfig;

    public TileEntityThermalGenerator() {
        super(2);
        this.addGuiFields("heatPoints");
        this.addNetworkFields("fuel");
        this.config = IC2.config.getInt("thermalEnergy");
        this.passiveConfig = IC2.config.getFloat("thermalEnergyPassive");
        this.production = this.config;
        this.maxStorage = 8000;
    }

    @Override
    protected void addSlots(InventoryHandler handler) {
        FluidFilter filter = new FluidFilter(FluidRegistry.LAVA);
        handler.registerDefaultSideAccess(AccessRule.Both, RotationList.ALL);
        handler.registerDefaultSlotAccess(AccessRule.Both, 0, 1);
        handler.registerDefaultSlotsForSide(RotationList.ALL, 0);
        handler.registerDefaultSlotsForSide(RotationList.DOWN, 1);
        handler.registerInputFilter(filter, 1);
        handler.registerOutputFilter(new InvertedFilter(filter), 1);
        handler.registerInputFilter(CommonFilters.ChargeEU, 0);
        handler.registerSlotType(SlotType.Charge, 0);
        handler.registerSlotType(SlotType.FluidFuel, 1);
    }

    @Override
    public Box2D getEnergyBox() {
        return Ic2GuiComp.generatorEnergyBox;
    }

    @Override
    public Box2D getFuelBox() {
        return Ic2GuiComp.generatorFuelBox;
    }

    @Override
    public ResourceLocation getTexture() {
        return Ic2Resources.thermalGenerator;
    }

    @Override
    public LocaleComp getBlockName() {
        return Ic2BlockLang.thermalGen;
    }

    @Override
    public boolean delayActiveUpdate() {
        return true;
    }

    @Override
    public int getDelay() {
        return 60;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.generatedEU = nbt.func_74760_g("Buffer");
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74776_a("Buffer", this.generatedEU);
        return nbt;
    }

    @Override
    public void onNetworkUpdate(String field) {
        super.onNetworkUpdate(field);
        if (field.equals("fuel")) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerThermalGenerator(player.field_71071_by, this);
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !this.func_145837_r();
    }

    public void updateFuel() {
        if (this.heatPoints == -1 || this.field_145850_b.func_82737_E() % 200L == 0L) {
            this.heatPoints = 0;
            List<BlockPos> positions = AabbUtil.getTargets(this.field_145850_b, this.func_174877_v(), 7, filter, false, RotationList.ALL);
            if (positions.size() > 0) {
                positions.remove(this.func_174877_v());
                for (BlockPos position : positions) {
                    IBlockState state = this.field_145850_b.func_180495_p(position);
                    Block block = state.func_177230_c();
                    Material mat = state.func_185904_a();
                    if (block == Blocks.field_150356_k) {
                        this.heatPoints += 3;
                        continue;
                    }
                    if (mat == Material.field_151587_i || mat == Material.field_151581_o) {
                        this.heatPoints += 10;
                        continue;
                    }
                    if (block == Blocks.field_189877_df) {
                        this.heatPoints += 7;
                        continue;
                    }
                    if (block == Blocks.field_150343_Z) {
                        this.heatPoints += 5;
                        continue;
                    }
                    if (mat == Material.field_151576_e || mat == Material.field_151573_f) {
                        this.heatPoints += 2;
                        continue;
                    }
                    if (mat == Material.field_151586_h) {
                        this.heatPoints -= 3;
                        continue;
                    }
                    if (mat == Material.field_151596_z || mat == Material.field_151597_y) {
                        this.heatPoints -= 5;
                        continue;
                    }
                    if (mat != Material.field_151588_w && mat != Material.field_151598_x) continue;
                    this.heatPoints -= 10;
                }
            }
            if (this.heatPoints < 0) {
                this.heatPoints = 0;
            }
            this.getNetwork().updateTileGuiField(this, "heatPoints");
        }
        if (this.heatPoints > 0) {
            this.generatedEU += (float)this.heatPoints / (2000.0f * this.passiveConfig);
        }
    }

    @Override
    public boolean gainEnergy() {
        if (this.fuel <= 0) {
            int toAdd = (int)this.generatedEU;
            if (toAdd > 0) {
                this.storage += toAdd;
                this.generatedEU -= (float)toAdd;
            }
            return this.heatPoints > 0;
        }
        if (this.isConverting()) {
            this.storage += this.production;
            boolean lastFuel = this.fuel > 0;
            --this.fuel;
            if (lastFuel != this.fuel > 0) {
                this.getNetwork().updateTileEntityField(this, "fuel");
            }
            this.getNetwork().updateTileGuiField(this, "fuel");
            return true;
        }
        return false;
    }

    @Override
    public boolean hasRightClick() {
        return true;
    }

    @Override
    public boolean onRightClick(EntityPlayer player, EnumHand hand, EnumFacing face, Side side) {
        if (30000 - this.fuel < 1250) {
            return false;
        }
        ItemStack playerStack = player.func_184586_b(hand);
        if (!playerStack.func_190926_b()) {
            if (StackUtil.isStackEqual(playerStack, Ic2Items.lavaCell)) {
                playerStack.func_190918_g(1);
                this.fuel += 1250;
                this.getNetwork().updateTileGuiField(this, "fuel");
                return true;
            }
            ItemStack result = FluidUtil.tryEmptyContainer((ItemStack)playerStack, (IFluidHandler)this, (int)(30000 - this.fuel), (EntityPlayer)player, (boolean)true).getResult();
            if (!result.func_190926_b()) {
                playerStack.func_190918_g(1);
                if (!player.field_71071_by.func_70441_a(result)) {
                    player.func_71019_a(result, false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasLeftClick() {
        return false;
    }

    @Override
    public void onLeftClick(EntityPlayer player, Side side) {
    }

    @Override
    public boolean needsFuel() {
        return this.fuel < maxLava;
    }

    @Override
    public boolean gainFuel() {
        if (this.fuel >= maxLava || maxLava - this.fuel < 1250) {
            if (this.heatPoints == -1) {
                this.updateFuel();
            }
            return false;
        }
        if (!((ItemStack)this.inventory.get(1)).func_190926_b()) {
            if (StackUtil.isStackEqual((ItemStack)this.inventory.get(1), Ic2Items.lavaCell)) {
                boolean lastFuel = this.fuel > 0;
                this.fuel += 1250;
                if (lastFuel != this.fuel > 0) {
                    this.getNetwork().updateTileEntityField(this, "fuel");
                }
                this.production = 25;
                ((ItemStack)this.inventory.get(1)).func_190918_g(1);
                return true;
            }
            return FluidHelper.drainContainers(this, this, 1);
        }
        if (this.fuel <= 0) {
            this.updateFuel();
        }
        return false;
    }

    @Override
    public float getMaxFuel() {
        return maxLava;
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new FluidTankProperties(new FluidStack(FluidRegistry.LAVA, this.fuel), maxLava)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource == null || resource.getFluid() != FluidRegistry.LAVA) {
            return 0;
        }
        int realAmount = (int)((double)resource.amount / 1000.0 * 1250.0);
        int toAdd = Math.min(realAmount, maxLava - this.fuel);
        if (doFill) {
            boolean lastFuel = this.fuel > 0;
            this.fuel += toAdd;
            if (lastFuel != this.fuel > 0) {
                this.getNetwork().updateTileEntityField(this, "fuel");
            }
            this.production = this.config;
        }
        return toAdd;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource != null && resource.getFluid() == FluidRegistry.LAVA) {
            return this.drain(resource.amount, doDrain);
        }
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        int amount = (int)Math.min((double)maxDrain * 1.25, (double)this.fuel);
        if (amount <= 0) {
            return null;
        }
        if (doDrain) {
            this.fuel -= amount;
            this.getNetwork().updateTileGuiField(this, "fuel");
        }
        return new FluidStack(FluidRegistry.LAVA, (int)((double)amount / 1.25));
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? this : super.getCapability(capability, facing));
    }

    @Override
    public int getMaxSendingEnergy() {
        return (int)(25.0f * (float)this.config);
    }

    public static class ThermalFilter
    implements AabbUtil.IBlockFilter {
        public static Set<Material> materials = new HashSet<Material>(Arrays.asList(Material.field_151587_i, Material.field_151586_h, Material.field_151581_o, Material.field_151576_e, Material.field_151573_f, Material.field_151588_w, Material.field_151597_y, Material.field_151596_z, Material.field_151598_x));

        @Override
        public boolean isValidBlock(IBlockState state) {
            Block block = state.func_177230_c();
            if (block == Blocks.field_150357_h) {
                return false;
            }
            if (block == Blocks.field_150343_Z || block == Blocks.field_189877_df) {
                return true;
            }
            return materials.contains(state.func_185904_a());
        }

        @Override
        public boolean isValidBlock(World world, BlockPos pos) {
            return this.isValidBlock(world.func_180495_p(pos));
        }

        @Override
        public boolean forceChunkLoad() {
            return false;
        }
    }
}

