/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.shader;

import codechicken.lib.render.OpenGLUtils;
import codechicken.lib.render.shader.ShaderObject;
import codechicken.lib.vec.Matrix4;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.nio.FloatBuffer;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.opengl.GL20;

public class ShaderProgram {
    public static final IUniformCallback NULL_UNIFORM_CONSUMER = cache -> {};
    public static final IntConsumer NULL_INT_CONSUMER = i -> {};
    private Set<ShaderObject> shaderObjects = new LinkedHashSet<ShaderObject>();
    private int programID;
    private UniformCache uniformCache = new UniformCache();
    private boolean isInvalid;
    private IUniformCallback globalUniformCallback = NULL_UNIFORM_CONSUMER;
    private IntConsumer onLink;

    public ShaderProgram() {
        this(NULL_INT_CONSUMER);
    }

    public ShaderProgram(IntConsumer onLink) {
        this.onLink = onLink;
        this.programID = GL20.glCreateProgram();
        if (this.programID == 0) {
            throw new RuntimeException("Unable to create new ShaderProgram! GL Allocation has failed.");
        }
    }

    public void attachShader(ShaderObject shaderObject) {
        if (this.shaderObjects.contains(shaderObject)) {
            throw new IllegalStateException("Unable to attach ShaderObject. Object is already attached!");
        }
        this.shaderObjects.add(shaderObject);
        GL20.glAttachShader((int)this.programID, (int)shaderObject.shaderID);
        this.isInvalid = true;
    }

    public void checkValidation() {
        if (this.isInvalid) {
            this.uniformCache.invalidateCache();
            GL20.glLinkProgram((int)this.programID);
            this.onLink.accept(this.programID);
            this.shaderObjects.forEach(shaderObject -> shaderObject.onShaderLink(this.programID));
            if (GL20.glGetProgrami((int)this.programID, (int)35714) == 0) {
                throw new RuntimeException(String.format("ShaderProgram validation has failed!\n%s", OpenGLUtils.glGetProgramInfoLog(this.programID)));
            }
            this.isInvalid = false;
        }
    }

    public void addGlobalUniformCallback(IUniformCallback callback) {
        this.globalUniformCallback = this.globalUniformCallback.with(callback);
    }

    public void useShader() {
        this.useShader(NULL_UNIFORM_CONSUMER);
    }

    public void useShader(IUniformCallback callback) {
        this.shaderObjects.forEach(ShaderObject::compileShader);
        this.checkValidation();
        GL20.glUseProgram((int)this.programID);
        this.shaderObjects.forEach(shaderObject -> shaderObject.onShaderUse(this.uniformCache));
        this.globalUniformCallback.apply(this.uniformCache);
        callback.apply(this.uniformCache);
    }

    public void releaseShader() {
        GL20.glUseProgram((int)0);
    }

    @FunctionalInterface
    public static interface IUniformCallback {
        public void apply(UniformCache var1);

        default public IUniformCallback with(IUniformCallback callback) {
            return cache -> {
                this.apply(cache);
                callback.apply(cache);
            };
        }
    }

    private static interface IGLUniformCallback {
        public void apply(int var1);
    }

    public static abstract class UniformEntry<T> {
        public static Predicate<UniformEntry> IS_INT = uniformEntry -> uniformEntry instanceof IntUniformEntry;
        public static Predicate<UniformEntry> IS_FLOAT = uniformEntry -> uniformEntry instanceof FloatUniformEntry;
        public static Predicate<UniformEntry> IS_MATRIX = uniformEntry -> uniformEntry instanceof MatrixUniformEntry;
        public static Predicate<UniformEntry> IS_BOOLEAN = uniformEntry -> uniformEntry instanceof BooleanUniformEntry;

        public abstract boolean check(T var1);

        public static class BooleanUniformEntry
        extends UniformEntry<Boolean> {
            public static Function<Boolean, UniformEntry<Boolean>> NEW = BooleanUniformEntry::new;
            private boolean bool;

            public BooleanUniformEntry(boolean bool) {
                this.bool = bool;
            }

            @Override
            public boolean check(Boolean other) {
                return this.bool == other;
            }
        }

        public static class MatrixUniformEntry
        extends UniformEntry<Pair<FloatBuffer, Boolean>> {
            public static Function<Pair<FloatBuffer, Boolean>, UniformEntry<Pair<FloatBuffer, Boolean>>> NEW = MatrixUniformEntry::new;
            FloatBuffer matrix;
            boolean transpose;

            public MatrixUniformEntry(Pair<FloatBuffer, Boolean> other) {
                this.matrix = (FloatBuffer)other.getKey();
                this.transpose = (Boolean)other.getValue();
            }

            @Override
            public boolean check(Pair<FloatBuffer, Boolean> other) {
                return this.matrix.equals(other.getKey()) && this.transpose == (Boolean)other.getValue();
            }
        }

        public static class FloatUniformEntry
        extends UniformEntry<float[]> {
            public static Function<float[], UniformEntry<float[]>> NEW = FloatUniformEntry::new;
            private float[] cache;

            public FloatUniformEntry(float ... cache) {
                this.cache = cache;
            }

            @Override
            public boolean check(float ... other) {
                if (this.cache.length != other.length) {
                    return false;
                }
                for (int i = 0; i < this.cache.length; ++i) {
                    if (this.cache[i] == other[i]) continue;
                    return false;
                }
                return true;
            }
        }

        public static class IntUniformEntry
        extends UniformEntry<int[]> {
            public static Function<int[], UniformEntry<int[]>> NEW = IntUniformEntry::new;
            private int[] cache;

            public IntUniformEntry(int ... cache) {
                this.cache = cache;
            }

            @Override
            public boolean check(int ... other) {
                if (this.cache.length != other.length) {
                    return false;
                }
                for (int i = 0; i < this.cache.length; ++i) {
                    if (this.cache[i] == other[i]) continue;
                    return false;
                }
                return true;
            }
        }
    }

    public class UniformCache {
        private TIntObjectHashMap<UniformEntry> uniformObjectCache = new TIntObjectHashMap();
        private TObjectIntHashMap<String> uniformLocationCache = new TObjectIntHashMap();

        private void invalidateCache() {
            this.uniformLocationCache.clear();
            this.uniformObjectCache.clear();
        }

        private int getUniformLocation(String name) {
            int uniformLocation;
            if (this.uniformLocationCache.containsKey((Object)name)) {
                uniformLocation = this.uniformLocationCache.get((Object)name);
            } else {
                uniformLocation = GL20.glGetUniformLocation((int)ShaderProgram.this.programID, (CharSequence)name);
                this.uniformLocationCache.put((Object)name, uniformLocation);
            }
            return uniformLocation;
        }

        public void glUniform1F(String location, float v0) {
            this.glUniformF(location, loc -> GL20.glUniform1f((int)loc, (float)v0), v0);
        }

        public void glUniform2F(String location, float v0, float v1) {
            this.glUniformF(location, loc -> GL20.glUniform2f((int)loc, (float)v0, (float)v1), v0, v1);
        }

        public void glUniform3F(String location, float v0, float v1, float v2) {
            this.glUniformF(location, loc -> GL20.glUniform3f((int)loc, (float)v0, (float)v1, (float)v2), v0, v1, v2);
        }

        public void glUniform4F(String location, float v0, float v1, float v2, float v3) {
            this.glUniformF(location, loc -> GL20.glUniform4f((int)loc, (float)v0, (float)v1, (float)v2, (float)v3), v0, v1, v2, v3);
        }

        private void glUniformF(String location, IGLUniformCallback callback, float ... values) {
            this.glUniform(location, UniformEntry.IS_FLOAT, UniformEntry.FloatUniformEntry.NEW, callback, values);
        }

        public void glUniform1I(String location, int v0) {
            this.glUniformI(location, loc -> GL20.glUniform1i((int)loc, (int)v0), v0);
        }

        public void glUniform2I(String location, int v0, int v1) {
            this.glUniformI(location, loc -> GL20.glUniform2i((int)loc, (int)v0, (int)v1), v0, v1);
        }

        public void glUniform3I(String location, int v0, int v1, int v2) {
            this.glUniformI(location, loc -> GL20.glUniform3i((int)loc, (int)v0, (int)v1, (int)v2), v0, v1, v2);
        }

        public void glUniform4I(String location, int v0, int v1, int v2, int v3) {
            this.glUniformI(location, loc -> GL20.glUniform4i((int)loc, (int)v0, (int)v1, (int)v2, (int)v3), v0, v1, v2, v3);
        }

        private void glUniformI(String location, IGLUniformCallback callback, int ... values) {
            this.glUniform(location, UniformEntry.IS_INT, UniformEntry.IntUniformEntry.NEW, callback, values);
        }

        public void glUniformMatrix2(String location, boolean transpose, FloatBuffer matrix) {
            this.glUniformMatrix(location, loc -> GL20.glUniformMatrix2((int)loc, (boolean)transpose, (FloatBuffer)matrix), transpose, matrix);
        }

        public void glUniformMatrix4(String location, boolean transpose, Matrix4 matrix) {
            this.glUniformMatrix(location, loc -> GL20.glUniformMatrix4((int)loc, (boolean)transpose, (FloatBuffer)matrix.toFloatBuffer()), transpose, matrix.toFloatBuffer());
        }

        public void glUniformMatrix4(String location, boolean transpose, FloatBuffer matrix) {
            this.glUniformMatrix(location, loc -> GL20.glUniformMatrix4((int)loc, (boolean)transpose, (FloatBuffer)matrix), transpose, matrix);
        }

        public void glUniformMatrix(String location, IGLUniformCallback callback, boolean transpose, FloatBuffer matrix) {
            this.glUniform(location, UniformEntry.IS_MATRIX, UniformEntry.MatrixUniformEntry.NEW, callback, ImmutablePair.of((Object)matrix, (Object)transpose));
        }

        public void glUniformBoolean(String location, boolean value) {
            this.glUniform(location, UniformEntry.IS_BOOLEAN, UniformEntry.BooleanUniformEntry.NEW, loc -> GL20.glUniform1i((int)loc, (int)(value ? 1 : 0)), value);
        }

        private <T> void glUniform(String location, Predicate<UniformEntry> isType, Function<T, UniformEntry<T>> createUniform, IGLUniformCallback applyCallback, T value) {
            UniformEntry uniformEntry;
            int loc = this.getUniformLocation(location);
            boolean update = true;
            if (this.uniformObjectCache.containsKey(loc) && isType.test(uniformEntry = (UniformEntry)this.uniformObjectCache.get(loc))) {
                boolean bl = update = !uniformEntry.check(value);
            }
            if (update) {
                UniformEntry<T> entry = createUniform.apply(value);
                applyCallback.apply(loc);
                this.uniformObjectCache.put(loc, entry);
            }
        }
    }
}

