/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.gui.book.element;

import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.client.book.action.StringActionProcessor;
import slimeknights.mantle.client.gui.book.element.SizedBookElement;

@SideOnly(value=Side.CLIENT)
public class ElementItem
extends SizedBookElement {
    public static final int ITEM_SIZE_HARDCODED = 16;
    public static final int ITEM_SWITCH_TICKS = 90;
    public NonNullList<ItemStack> itemCycle;
    public float scale;
    public String action;
    public List<String> tooltip;
    public int renderTick = 0;
    public int currentItem = 0;

    public ElementItem(int x, int y, float scale, Item item) {
        this(x, y, scale, new ItemStack(item));
    }

    public ElementItem(int x, int y, float scale, Block item) {
        this(x, y, scale, new ItemStack(item));
    }

    public ElementItem(int x, int y, float scale, ItemStack item) {
        this(x, y, scale, new ItemStack[]{item});
    }

    public ElementItem(int x, int y, float scale, Collection<ItemStack> itemCycle) {
        this(x, y, scale, itemCycle.toArray(new ItemStack[itemCycle.size()]));
    }

    public ElementItem(int x, int y, float scale, Collection<ItemStack> itemCycle, String action) {
        this(x, y, scale, itemCycle.toArray(new ItemStack[itemCycle.size()]), action);
    }

    public ElementItem(int x, int y, float scale, ItemStack ... itemCycle) {
        this(x, y, scale, itemCycle, (String)null);
    }

    public ElementItem(int x, int y, float scale, ItemStack[] itemCycle, String action) {
        super(x, y, MathHelper.func_76141_d((float)(16.0f * scale)), MathHelper.func_76141_d((float)(16.0f * scale)));
        NonNullList nonNullStacks = NonNullList.func_191197_a((int)itemCycle.length, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < itemCycle.length; ++i) {
            if (itemCycle[i].func_190926_b()) continue;
            nonNullStacks.set(i, (Object)itemCycle[i].func_77946_l());
        }
        this.itemCycle = nonNullStacks;
        this.scale = scale;
        this.action = action;
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTicks, FontRenderer fontRenderer) {
        ++this.renderTick;
        if (this.renderTick > 90) {
            this.renderTick = 0;
            ++this.currentItem;
            if (this.currentItem >= this.itemCycle.size()) {
                this.currentItem = 0;
            }
        }
        RenderHelper.func_74520_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.x, (float)this.y, (float)0.0f);
        GlStateManager.func_179152_a((float)this.scale, (float)this.scale, (float)1.0f);
        if (this.currentItem < this.itemCycle.size()) {
            this.mc.func_175599_af().func_180450_b((ItemStack)this.itemCycle.get(this.currentItem), 0, 0);
        }
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
    }

    @Override
    public void drawOverlay(int mouseX, int mouseY, float partialTicks, FontRenderer fontRenderer) {
        if (this.isHovered(mouseX, mouseY) && this.currentItem < this.itemCycle.size()) {
            if (this.tooltip != null) {
                this.drawHoveringText(this.tooltip, mouseX, mouseY, fontRenderer);
            } else {
                this.renderToolTip(fontRenderer, (ItemStack)this.itemCycle.get(this.currentItem), mouseX, mouseY);
            }
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (mouseButton == 0 && this.isHovered(mouseX, mouseY) && this.currentItem < this.itemCycle.size()) {
            if (this.action != null) {
                StringActionProcessor.process(this.action, this.parent);
            } else {
                this.parent.itemClicked((ItemStack)this.itemCycle.get(this.currentItem));
            }
        }
    }
}

