/*
 * Decompiled with CFR 0.152.
 */
package crafttweaker.mc1120.world;

import crafttweaker.api.entity.IEntityLivingBase;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.util.Position3f;
import crafttweaker.api.world.IBlockPos;
import crafttweaker.api.world.IExplosion;
import crafttweaker.api.world.IVector3d;
import crafttweaker.api.world.IWorld;
import crafttweaker.mc1120.player.MCPlayer;
import crafttweaker.mc1120.util.MCPosition3f;
import crafttweaker.mc1120.world.MCBlockPos;
import crafttweaker.mc1120.world.MCVector3d;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class MCExplosion
implements IExplosion {
    private final Explosion explosion;

    public MCExplosion(Explosion explosion) {
        this.explosion = explosion;
    }

    @Override
    public IWorld getWorld() {
        return CraftTweakerMC.getIWorld(this.explosion.field_77287_j);
    }

    @Override
    public IEntityLivingBase getExplosivePlacedBy() {
        return CraftTweakerMC.getIEntityLivingBase(this.explosion.func_94613_c());
    }

    @Override
    public Position3f getPosition() {
        return new MCPosition3f((float)this.explosion.getPosition().field_72450_a, (float)this.explosion.getPosition().field_72448_b, (float)this.explosion.getPosition().field_72449_c);
    }

    @Override
    public List<IBlockPos> getAffectedBlockPositions() {
        return this.explosion.func_180343_e().stream().map(MCBlockPos::new).collect(Collectors.toList());
    }

    @Override
    public void setAffectedBlockPositions(List<IBlockPos> affectedBlockPositions) {
        this.explosion.field_77281_g = affectedBlockPositions.stream().filter(x -> x instanceof BlockPos).map(x -> (BlockPos)x.getInternal()).collect(Collectors.toList());
    }

    @Override
    public void clearAffectedBlockPositions() {
        this.explosion.func_180342_d();
    }

    @Override
    public Map<IPlayer, IVector3d> getPlayerKnockbackMap() {
        return this.explosion.func_77277_b().entrySet().stream().map(e -> new AbstractMap.SimpleEntry<MCPlayer, MCVector3d>(new MCPlayer((EntityPlayer)e.getKey()), new MCVector3d((Vec3d)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public boolean onExplosionStart(IWorld world) {
        return ForgeEventFactory.onExplosionStart((World)CraftTweakerMC.getWorld(world), (Explosion)this.explosion);
    }

    @Override
    public void doExplosionA() {
        this.explosion.func_77278_a();
    }

    @Override
    public void doExplosionB(boolean spawnParticles) {
        this.explosion.func_77279_a(spawnParticles);
    }

    @Override
    public Object getInternal() {
        return this.explosion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MCExplosion that = (MCExplosion)o;
        return Objects.equals(this.explosion, that.explosion);
    }

    public int hashCode() {
        return Objects.hash(this.explosion);
    }
}

