/*
 * Decompiled with CFR 0.152.
 */
package trackapi.compat;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import trackapi.lib.ITrack;

public class MinecraftRail
implements ITrack {
    private static Map<BlockRailBase.EnumRailDirection, Vec3d> vectors = new HashMap<BlockRailBase.EnumRailDirection, Vec3d>();
    private static Map<BlockRailBase.EnumRailDirection, Vec3d> centers = new HashMap<BlockRailBase.EnumRailDirection, Vec3d>();
    private BlockRailBase.EnumRailDirection direction;
    private BlockPos pos;

    public MinecraftRail(World world, BlockPos pos) {
        this.pos = pos;
        IBlockState state = world.func_180495_p(pos);
        BlockRailBase blockrailbase = (BlockRailBase)state.func_177230_c();
        this.direction = blockrailbase.getRailDirection((IBlockAccess)world, pos, state, null);
    }

    @Override
    public double getTrackGauge() {
        return 0.632;
    }

    @Override
    public Vec3d getNextPosition(Vec3d currentPosition, Vec3d motion) {
        Vec3d trackMovement = vectors.get(this.direction);
        Vec3d trackCenter = centers.get(this.direction);
        Vec3d posRelativeToCenter = currentPosition.func_72444_a(new Vec3d((Vec3i)this.pos).func_178787_e(trackCenter));
        double distanceToCenter = posRelativeToCenter.func_72433_c();
        boolean trackPosMotionInverted = posRelativeToCenter.func_72438_d(trackMovement) < posRelativeToCenter.func_186678_a(-1.0).func_72438_d(trackMovement);
        boolean trackMotionInverted = motion.func_72438_d(trackMovement) > motion.func_186678_a(-1.0).func_72438_d(trackMovement);
        Vec3d newPosition = new Vec3d((Vec3i)this.pos).func_178787_e(trackCenter);
        newPosition = newPosition.func_178787_e(trackMovement.func_186678_a(trackPosMotionInverted ? -distanceToCenter : distanceToCenter));
        newPosition = newPosition.func_178787_e(trackMovement.func_186678_a(trackMotionInverted ? -motion.func_72433_c() : motion.func_72433_c()));
        return newPosition;
    }

    public static boolean isRail(World world, BlockPos pos) {
        return BlockRailBase.func_176562_d((World)world, (BlockPos)pos);
    }

    static {
        Vec3d north = new Vec3d(0.0, 0.0, 1.0);
        Vec3d south = new Vec3d(0.0, 0.0, -1.0);
        Vec3d east = new Vec3d(1.0, 0.0, 0.0);
        Vec3d west = new Vec3d(-1.0, 0.0, 0.0);
        Vec3d ascending = new Vec3d(0.0, 1.0, 0.0);
        vectors.put(BlockRailBase.EnumRailDirection.ASCENDING_EAST, east.func_178787_e(ascending).func_72432_b());
        vectors.put(BlockRailBase.EnumRailDirection.ASCENDING_NORTH, north.func_178787_e(ascending).func_72432_b());
        vectors.put(BlockRailBase.EnumRailDirection.ASCENDING_SOUTH, south.func_178787_e(ascending).func_72432_b());
        vectors.put(BlockRailBase.EnumRailDirection.ASCENDING_WEST, west.func_178787_e(ascending).func_72432_b());
        vectors.put(BlockRailBase.EnumRailDirection.EAST_WEST, east.func_72432_b());
        vectors.put(BlockRailBase.EnumRailDirection.NORTH_EAST, north.func_178787_e(east).func_72432_b());
        vectors.put(BlockRailBase.EnumRailDirection.NORTH_SOUTH, north.func_72432_b());
        vectors.put(BlockRailBase.EnumRailDirection.NORTH_WEST, north.func_178787_e(west).func_72432_b());
        vectors.put(BlockRailBase.EnumRailDirection.SOUTH_EAST, south.func_178787_e(east).func_72432_b());
        vectors.put(BlockRailBase.EnumRailDirection.SOUTH_WEST, south.func_178787_e(west).func_72432_b());
        centers.put(BlockRailBase.EnumRailDirection.ASCENDING_EAST, new Vec3d(0.5, 0.5, 0.5));
        centers.put(BlockRailBase.EnumRailDirection.ASCENDING_NORTH, new Vec3d(0.5, 0.5, 0.5));
        centers.put(BlockRailBase.EnumRailDirection.ASCENDING_SOUTH, new Vec3d(0.5, 0.5, 0.5));
        centers.put(BlockRailBase.EnumRailDirection.ASCENDING_WEST, new Vec3d(0.5, 0.5, 0.5));
        centers.put(BlockRailBase.EnumRailDirection.EAST_WEST, new Vec3d(0.5, 0.1, 0.5));
        centers.put(BlockRailBase.EnumRailDirection.NORTH_EAST, new Vec3d(0.75, 0.1, 0.25));
        centers.put(BlockRailBase.EnumRailDirection.NORTH_SOUTH, new Vec3d(0.5, 0.1, 0.5));
        centers.put(BlockRailBase.EnumRailDirection.NORTH_WEST, new Vec3d(0.25, 0.1, 0.25));
        centers.put(BlockRailBase.EnumRailDirection.SOUTH_EAST, new Vec3d(0.75, 0.1, 0.75));
        centers.put(BlockRailBase.EnumRailDirection.SOUTH_WEST, new Vec3d(0.25, 0.1, 0.75));
    }
}

