/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture.render;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.EnumFacing;
import team.chisel.ctm.api.texture.ISubmap;
import team.chisel.ctm.api.texture.ITextureContext;
import team.chisel.ctm.api.util.TextureInfo;
import team.chisel.ctm.client.texture.ctx.TextureContextCTMV;
import team.chisel.ctm.client.texture.render.AbstractTexture;
import team.chisel.ctm.client.texture.type.TextureTypeCTMV;
import team.chisel.ctm.client.util.Quad;
import team.chisel.ctm.client.util.Submap;

public class TextureCTMV
extends AbstractTexture<TextureTypeCTMV> {
    public TextureCTMV(TextureTypeCTMV type, TextureInfo info) {
        super(type, info);
    }

    @Override
    public List<BakedQuad> transformQuad(BakedQuad quad, ITextureContext context, int quadGoal) {
        if (context == null) {
            if (quad.func_178210_d() != null && quad.func_178210_d().func_176740_k().func_176720_b()) {
                return Lists.newArrayList((Object[])new BakedQuad[]{this.makeQuad(quad, context).transformUVs(this.sprites[0]).rebake()});
            }
            return Lists.newArrayList((Object[])new BakedQuad[]{this.makeQuad(quad, context).transformUVs(this.sprites[1], Submap.X2[0][0]).rebake()});
        }
        return Lists.newArrayList((Object[])new BakedQuad[]{this.getQuad(quad, context)});
    }

    private BakedQuad getQuad(BakedQuad in, ITextureContext context) {
        boolean connected;
        Quad q = this.makeQuad(in, context);
        TextureContextCTMV.ConnectionData data = ((TextureContextCTMV)context).getData();
        TextureContextCTMV.Connections cons = data.getConnections();
        EnumSet<EnumFacing> realConnections = EnumSet.copyOf(data.getConnections().getConnections());
        if (cons.connectedOr(EnumFacing.UP, EnumFacing.DOWN)) {
            realConnections.removeIf(f -> f.func_176740_k().func_176722_c());
        } else if (cons.connectedOr(EnumFacing.EAST, EnumFacing.WEST)) {
            realConnections.removeIf(f -> f == EnumFacing.NORTH || f == EnumFacing.SOUTH);
            realConnections.removeIf(f -> this.blockConnectionZ((EnumFacing)f, data));
        } else {
            realConnections.removeIf(f -> this.blockConnectionY((EnumFacing)f, data));
        }
        cons = new TextureContextCTMV.Connections(realConnections);
        int rotation = 0;
        ISubmap uvs = Submap.X2[0][0];
        if (in.func_178210_d().func_176740_k().func_176722_c() && cons.connectedOr(EnumFacing.UP, EnumFacing.DOWN)) {
            uvs = this.getUVs(EnumFacing.UP, EnumFacing.DOWN, cons);
        } else if (cons.connectedOr(EnumFacing.EAST, EnumFacing.WEST)) {
            rotation = 1;
            uvs = this.getUVs(EnumFacing.EAST, EnumFacing.WEST, cons);
        } else if (cons.connectedOr(EnumFacing.NORTH, EnumFacing.SOUTH)) {
            uvs = this.getUVs(EnumFacing.NORTH, EnumFacing.SOUTH, cons);
            if (in.func_178210_d() == EnumFacing.DOWN) {
                rotation += 2;
            }
        }
        boolean bl = connected = !cons.getConnections().isEmpty();
        if (connected && !cons.connectedOr(EnumFacing.UP, EnumFacing.DOWN)) {
            if (in.func_178210_d() == EnumFacing.EAST) {
                ++rotation;
            }
            if (in.func_178210_d() == EnumFacing.NORTH) {
                rotation += 2;
            }
            if (in.func_178210_d() == EnumFacing.WEST) {
                rotation += 3;
            }
        }
        if (cons.connected(in.func_178210_d().func_176734_d())) {
            connected = false;
        }
        if (cons.getConnections().isEmpty() && in.func_178210_d().func_176740_k().func_176722_c()) {
            connected = true;
        }
        q = q.rotate(rotation);
        if (connected) {
            return q.transformUVs(this.sprites[1], uvs).rebake();
        }
        return q.transformUVs(this.sprites[0]).rebake();
    }

    private ISubmap getUVs(EnumFacing face1, EnumFacing face2, TextureContextCTMV.Connections cons) {
        ISubmap uvs = cons.connectedAnd(face1, face2) ? Submap.X2[1][0] : (cons.connected(face1) ? Submap.X2[1][1] : Submap.X2[0][1]);
        return uvs;
    }

    private boolean blockConnectionY(EnumFacing dir, TextureContextCTMV.ConnectionData data) {
        return this.blockConnection(dir, EnumFacing.Axis.Y, data) || this.blockConnection(dir, dir.func_176732_a(EnumFacing.Axis.Y).func_176740_k(), data);
    }

    private boolean blockConnectionZ(EnumFacing dir, TextureContextCTMV.ConnectionData data) {
        return this.blockConnection(dir, EnumFacing.Axis.Z, data);
    }

    private boolean blockConnection(EnumFacing dir, EnumFacing.Axis axis, TextureContextCTMV.ConnectionData data) {
        EnumFacing rot = dir.func_176732_a(axis);
        return data.getConnections(dir).connectedOr(rot, rot.func_176734_d());
    }
}

