/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.misc;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketChat;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fluids.FluidStack;
import shetiphian.core.client.Localization;
import shetiphian.core.common.NameHelper;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public class TankInfoHelper {
    private static final TankInfoHelper INSTANCE = new TankInfoHelper();

    public static void sendTankInfo(EntityPlayer player, FluidStack stack, String ownerName, String ownerID, String code) {
        String message = "\u00a76" + INSTANCE.localize("info.endertanks.bucket.header.txt") + ":\u00a7r";
        message = message + INSTANCE.infoTankFluidData(stack, TankHelper.getTank(ownerID, code, player.func_130014_f_().field_72995_K).getCapacity());
        message = message + INSTANCE.infoTankOwner(ownerName, false, true);
        INSTANCE.sendInfo(player, message);
    }

    public static void sendTankInfo(EntityPlayer player, TileEntityEnderTank tile) {
        FluidStack fluidStack = TankHelper.getTank(tile.getOwnerID(), tile.getCode(), tile.func_145831_w().field_72995_K).getFluid();
        String message = "\u00a76" + INSTANCE.localize("info.endertanks.tank.header.txt") + ":\u00a7r";
        message = message + INSTANCE.infoTankFluidData(fluidStack, TankHelper.getTank(tile.getOwnerID(), tile.getCode(), tile.func_145831_w().field_72995_K).getCapacity());
        message = message + INSTANCE.infoPump(tile.getPumpCapacity(), true);
        message = message + INSTANCE.infoTankOwner(tile.getOwnerName(), false, true);
        INSTANCE.sendInfo(player, message);
    }

    public static void wailaGetTankInfo(List<String> tooltip, TileEntityEnderTank tile, FluidStack fluidStack, int capacity) {
        if (tile == null) {
            return;
        }
        tooltip.add("\u00a77" + INSTANCE.infoTankFluidData(fluidStack, capacity) + "\u00a7r");
        tooltip.add("\u00a77" + INSTANCE.infoPump(tile.getPumpCapacity(), false) + "\u00a77");
        tooltip.add(INSTANCE.infoTankOwner(tile.getOwnerName(), true, false));
    }

    public static void sendCapacityInfo(EntityPlayer player, TileEntityEnderTank tankTile) {
        String message = INSTANCE.localize("info.endertanks.tank.capacity.txt");
        message = message + " " + TankHelper.getTank(tankTile.getOwnerID(), tankTile.getCode(), tankTile.func_145831_w().field_72995_K).getCapacity();
        INSTANCE.sendInfo(player, message);
    }

    public static void sendPumpInfo(EntityPlayer player, TileEntityEnderTank tile) {
        String message = INSTANCE.localize("info.endertanks.tank.pump.upgrade.txt");
        message = message + " " + tile.getPumpCapacity() + "mB";
        INSTANCE.sendInfo(player, message);
    }

    public static void sendLinkError(EntityPlayer player, int error) {
        String message = "\u00a7c\u00a7l" + INSTANCE.localize("error.endertanks.bucket.nolink" + error + ".txt") + "\u00a7r";
        INSTANCE.sendInfo(player, message);
    }

    public static void sendError(EntityPlayer player, String error) {
        String message = "\u00a7c\u00a7l" + INSTANCE.localize("error." + error + ".txt") + "\u00a7r";
        INSTANCE.sendInfo(player, message);
    }

    private String infoTankFluidData(FluidStack stack, int capacity) {
        String info = " ";
        if (stack == null || stack.amount < 1) {
            info = info + this.localize("info.endertanks.tank.empty.txt") + " [0";
        } else {
            info = info + this.localize(stack.getFluid().getUnlocalizedName(stack));
            info = info + " [" + (float)stack.amount / 1000.0f;
        }
        info = info + "K/" + capacity / 1000 + "K mB]";
        return info;
    }

    private String infoPump(int capacity, boolean comma) {
        if (capacity >= 1000) {
            return (comma ? ", " : " ") + (float)capacity / 1000.0f + "K mB " + this.localize("info.endertanks.tank.pump.txt");
        }
        return (comma ? ", " : " ") + capacity + "mB " + this.localize("info.endertanks.tank.pump.txt");
    }

    private String infoTankOwner(String owner, boolean displayPublic, boolean comma) {
        if (Strings.isNullOrEmpty((String)owner) || owner.equalsIgnoreCase("all")) {
            return displayPublic ? " \u00a76[-" + this.localize("info.endertanks.tank.public.txt") + "-]\u00a7r" : "";
        }
        String color = !Strings.isNullOrEmpty((String)owner) && owner.startsWith("#") ? "a" : "b";
        return (comma ? ", " : " ") + "\u00a7" + color + "[-" + owner + "-]\u00a7r";
    }

    public static String formatTankOwner(String owner) {
        return INSTANCE.infoTankOwner(owner, false, false);
    }

    private String localize(String string) {
        return Localization.get((String)string);
    }

    private void sendInfo(EntityPlayer player, String message) {
        if (player instanceof EntityPlayerMP) {
            message = message.replace("<br>", " ");
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketChat((ITextComponent)new TextComponentString(message), ChatType.GAME_INFO));
        } else {
            String[] split;
            for (String line : split = message.split("<br>")) {
                player.func_146105_b((ITextComponent)new TextComponentString(line), true);
            }
        }
    }

    public static String getDisplayNameFromOwnerID(String ownerID) {
        if (Strings.isNullOrEmpty((String)ownerID) || ownerID.equalsIgnoreCase("all")) {
            return "all";
        }
        return NameHelper.getDisplayNameFor((String)(ownerID.startsWith("#") ? ownerID.substring(1) : ownerID));
    }
}

