/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.path.task;

import buildcraft.lib.misc.WorkerThreadUtil;
import buildcraft.lib.path.MiniChunkGraph;
import buildcraft.lib.path.task.AnalysedChunk;
import buildcraft.lib.path.task.FilledChunk;
import buildcraft.lib.path.task.TaskMiniChunkAnalyser;
import buildcraft.lib.path.task.TaskMiniChunkFiller;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TaskMiniChunkManager
implements Callable<MiniChunkGraph> {
    private World world;
    private final BlockPos offset;
    private final Consumer<MiniChunkGraph> setter;

    public TaskMiniChunkManager(World world, BlockPos offset, Consumer<MiniChunkGraph> setter) {
        this.world = world;
        this.offset = offset;
        this.setter = setter;
    }

    private static <T> T execute(Callable<T> callable) throws InterruptedException {
        return WorkerThreadUtil.executeWorkTaskWaiting(callable);
    }

    @Override
    public MiniChunkGraph call() throws Exception {
        FilledChunk filled = TaskMiniChunkManager.execute(new TaskMiniChunkFiller(this.world, this.offset));
        this.world = null;
        AnalysedChunk analysed = TaskMiniChunkManager.execute(new TaskMiniChunkAnalyser(filled));
        MiniChunkGraph graph = null;
        this.setter.accept(graph);
        return graph;
    }
}

