/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.nbt;

import buildcraft.api.core.InvalidInputDataException;
import buildcraft.lib.nbt.NbtSquishMap;
import buildcraft.lib.nbt.NbtSquishMapReader;
import buildcraft.lib.nbt.NbtSquishMapWriter;
import buildcraft.lib.nbt.WrittenType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.profiler.Profiler;

public class NbtSquisher {
    public static final Profiler profiler = new Profiler();
    public static Function<ByteBuf, PacketBuffer> debugBuffer = null;
    private static final int TYPE_MC_GZIP = 1;
    private static final int TYPE_MC = 0;
    private static final int TYPE_BC_1_GZIP = 3;
    private static final int TYPE_BC_1 = 2;

    public static byte[] squish(NBTTagCompound nbt, int type) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            NbtSquisher.squish(nbt, type, baos);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to write to a perfectly good ByteArrayOutputStream", e);
        }
        return baos.toByteArray();
    }

    public static void squish(NBTTagCompound nbt, int type, ByteBuf buf) {
        try (ByteBufOutputStream bbos = new ByteBufOutputStream(buf);){
            NbtSquisher.squish(nbt, type, (OutputStream)bbos);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to write to a perfectly good ByteBufOutputStream", e);
        }
    }

    public static void squish(NBTTagCompound nbt, int type, OutputStream stream) throws IOException {
        switch (type) {
            case 0: {
                NbtSquisher.squishVanillaUncompressed(nbt, new DataOutputStream(stream));
                return;
            }
            case 1: {
                NbtSquisher.squishVanilla(nbt, stream);
                return;
            }
            case 2: {
                NbtSquisher.squishBuildCraftV1Uncompressed(nbt, new DataOutputStream(stream));
                return;
            }
            case 3: {
                NbtSquisher.squishBuildCraftV1(nbt, stream);
                return;
            }
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    public static void squishVanilla(NBTTagCompound nbt, OutputStream to) throws IOException {
        to.write(188);
        to.write(161);
        to.write(1);
        CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)to);
    }

    public static void squishVanillaUncompressed(NBTTagCompound nbt, DataOutput to) throws IOException {
        to.writeShort(48289);
        to.write(0);
        CompressedStreamTools.func_74800_a((NBTTagCompound)nbt, (DataOutput)to);
    }

    public static void squishBuildCraftV1(NBTTagCompound nbt, OutputStream to) throws IOException {
        to.write(188);
        to.write(161);
        to.write(3);
        try (GZIPOutputStream gzip = new GZIPOutputStream(to, true);){
            NbtSquisher.squishBuildCraftV1Direct(nbt, new DataOutputStream(gzip));
        }
    }

    public static void squishBuildCraftV1Uncompressed(NBTTagCompound nbt, DataOutput to) throws IOException {
        to.write(188);
        to.write(161);
        to.write(2);
        NbtSquisher.squishBuildCraftV1Direct(nbt, to);
    }

    public static NBTTagCompound expand(byte[] bytes) throws IOException {
        return NbtSquisher.expand(new ByteArrayInputStream(bytes));
    }

    public static NBTTagCompound expand(ByteBuf buf) throws IOException {
        return NbtSquisher.expand((InputStream)new ByteBufInputStream(buf));
    }

    public static NBTTagCompound expand(InputStream stream) throws IOException {
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        stream.mark(5);
        int byte1 = stream.read();
        int byte2 = stream.read();
        if (byte1 == 188 && byte2 == 161) {
            int type = stream.read();
            if (type == 0) {
                return CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(stream));
            }
            if (type == 1) {
                return CompressedStreamTools.func_74796_a((InputStream)stream);
            }
            if (type == 2) {
                return NbtSquisher.readBuildCraftV1Direct(new DataInputStream(stream));
            }
            if (type == 3) {
                return NbtSquisher.readBuildCraftV1Direct(new DataInputStream(new GZIPInputStream(stream)));
            }
            throw new InvalidInputDataException("Cannot handle BuildCraft saved NBT type " + type);
        }
        if (byte1 == 31 && byte2 == 139) {
            stream.reset();
            return CompressedStreamTools.func_74796_a((InputStream)stream);
        }
        stream.reset();
        stream.mark(5);
        int type = stream.read();
        if (type == 0) {
            return CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(stream));
        }
        if (type == 1) {
            return CompressedStreamTools.func_74796_a((InputStream)stream);
        }
        if (type == 2) {
            return NbtSquisher.readBuildCraftV1Direct(new DataInputStream(stream));
        }
        if (type == 3) {
            return NbtSquisher.readBuildCraftV1Direct(new DataInputStream(new GZIPInputStream(stream)));
        }
        if (type == 10) {
            stream.reset();
            return CompressedStreamTools.func_74794_a((DataInputStream)new DataInputStream(stream));
        }
        throw new InvalidInputDataException("Cannot handle unknown saved NBT type " + type);
    }

    private static NBTTagCompound readBuildCraftV1Direct(DataInput in) throws IOException {
        NbtSquishMap map = NbtSquishMapReader.read(in);
        WrittenType type = map.getWrittenType();
        int index = type.readIndex(in);
        return map.getFullyReadComp(index);
    }

    private static void squishBuildCraftV1Direct(NBTTagCompound nbt, DataOutput to) throws IOException {
        NbtSquishMap map = new NbtSquishMap();
        map.addTag((NBTBase)nbt);
        NbtSquishMapWriter.debug = debugBuffer != null;
        NbtSquishMapWriter.write(map, to);
        WrittenType type = map.getWrittenType();
        type.writeIndex(to, map.indexOfTag((NBTBase)nbt));
    }
}

