/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc.data;

import gnu.trove.list.array.TByteArrayList;

public class CompactingBitSet {
    public final int bits;
    private final TByteArrayList bytes = new TByteArrayList();
    private int bitIndex = 0;

    public CompactingBitSet(int bits) {
        this.bits = bits;
    }

    public void ensureCapacityValues(int values) {
        this.ensureCapacityBits(values * this.bits);
    }

    public void ensureCapacityBits(int totalBits) {
        this.bytes.ensureCapacity(totalBits / 8 + 1);
    }

    private void appendBit(int bit) {
        if (this.bitIndex == 0) {
            this.bytes.add((byte)0);
        }
        int offset = this.bytes.size() - 1;
        byte current = this.bytes.get(offset);
        if ((bit & 1) == 1) {
            current = (byte)(current | 1 << this.bitIndex);
            this.bytes.set(offset, current);
        }
        ++this.bitIndex;
        if (this.bitIndex == 8) {
            this.bitIndex = 0;
        }
    }

    public void append(int value) {
        for (int i = this.bits - 1; i >= 0; --i) {
            int bit = value >> i & 1;
            this.appendBit(bit);
        }
    }

    public byte[] getBytes() {
        return this.bytes.toArray();
    }
}

