/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import buildcraft.api.inventory.IItemTransactor;
import buildcraft.api.transport.IInjectable;
import buildcraft.lib.inventory.ItemTransactorHelper;
import buildcraft.lib.misc.StackUtil;
import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class InventoryUtil {
    public static void dropAll(World world, Vec3d vec, IItemHandlerModifiable handler) {
        InventoryUtil.dropAll(world, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, handler);
    }

    public static void dropAll(World world, BlockPos pos, IItemHandlerModifiable handler) {
        InventoryUtil.dropAll(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), handler);
    }

    public static void dropAll(World world, double x, double y, double z, IItemHandlerModifiable handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            InventoryUtil.drop(world, x, y, z, handler.extractItem(i, Integer.MAX_VALUE, false));
        }
    }

    public static void dropAll(World world, BlockPos pos, NonNullList<ItemStack> toDrop) {
        for (ItemStack stack : toDrop) {
            if (stack == null) {
                throw new NullPointerException("Null stack!");
            }
            InventoryUtil.drop(world, pos, stack);
        }
    }

    public static void drop(World world, BlockPos pos, @Nonnull ItemStack stack) {
        Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack);
    }

    public static void drop(World world, Vec3d vec, @Nonnull ItemStack stack) {
        InventoryUtil.drop(world, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, stack);
    }

    public static void drop(World world, double x, double y, double z, @Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return;
        }
        EntityItem entity = new EntityItem(world, x, y, z, stack);
        world.func_72838_d((Entity)entity);
    }

    @Nonnull
    public static ItemStack addToRandomInventory(World world, BlockPos pos, @Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return StackUtil.EMPTY;
        }
        ArrayList toTry = new ArrayList(6);
        Collections.addAll(toTry, EnumFacing.field_82609_l);
        Collections.shuffle(toTry);
        for (EnumFacing face : toTry) {
            TileEntity tile = world.func_175625_s(pos.func_177972_a(face));
            IItemTransactor transactor = ItemTransactorHelper.getTransactor((ICapabilityProvider)tile, face.func_176734_d());
            stack = transactor.insert(stack, false, false);
            if (!stack.func_190926_b()) continue;
            return StackUtil.EMPTY;
        }
        return stack;
    }

    @Nonnull
    public static ItemStack addToRandomInjectable(World world, BlockPos pos, EnumFacing ignore, @Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return StackUtil.EMPTY;
        }
        ArrayList toTry = new ArrayList(6);
        Collections.addAll(toTry, EnumFacing.field_82609_l);
        Collections.shuffle(toTry);
        for (EnumFacing face : toTry) {
            TileEntity tile;
            IInjectable injectable;
            if (face == ignore || !(stack = (injectable = ItemTransactorHelper.getInjectable((ICapabilityProvider)(tile = world.func_175625_s(pos.func_177972_a(face))), face.func_176734_d())).injectItem(stack, true, face.func_176734_d(), null, 0.0)).func_190926_b()) continue;
            return StackUtil.EMPTY;
        }
        return stack;
    }

    public static void addToBestAcceptor(World world, BlockPos pos, EnumFacing ignore, @Nonnull ItemStack stack) {
        stack = InventoryUtil.addToRandomInjectable(world, pos, ignore, stack);
        stack = InventoryUtil.addToRandomInventory(world, pos, stack);
        InventoryUtil.drop(world, pos, stack);
    }

    public static void addAll(IItemHandler src, NonNullList<ItemStack> dst) {
        for (int i = 0; i < src.getSlots(); ++i) {
            ItemStack stack = src.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            dst.add((Object)stack);
        }
    }

    public static void addToPlayer(EntityPlayer player, ItemStack stack) {
        if (player.field_71071_by.func_70441_a(stack)) {
            player.field_71069_bz.func_75142_b();
        } else {
            player.func_146097_a(stack, false, false);
        }
    }
}

