/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.json;

import buildcraft.api.core.BCLog;
import buildcraft.lib.client.model.ResourceLoaderContext;
import buildcraft.lib.expression.DefaultContexts;
import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.expression.GenericExpressionCompiler;
import buildcraft.lib.expression.api.InvalidExpressionException;
import buildcraft.lib.expression.node.value.NodeVariableDouble;
import buildcraft.lib.gui.BuildCraftGui;
import buildcraft.lib.gui.IContainingElement;
import buildcraft.lib.gui.IGuiElement;
import buildcraft.lib.gui.json.ElementType;
import buildcraft.lib.gui.json.JsonGuiElement;
import buildcraft.lib.gui.json.JsonGuiInfo;
import buildcraft.lib.gui.json.JsonGuiTypeRegistry;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.misc.collect.TypedKeyMap;
import buildcraft.lib.misc.data.ModelVariableData;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;

public class BuildCraftJsonGui
extends BuildCraftGui {
    public final ResourceLocation jsonGuiDefinition;
    public final TypedKeyMap<String, Object> properties = TypedKeyMap.createHierachy();
    public final FunctionContext context = DefaultContexts.createWithAll();
    final ModelVariableData varData = new ModelVariableData();
    private final NodeVariableDouble time;
    private int timeOpen;
    private int sizeX;
    private int sizeY;

    public BuildCraftJsonGui(GuiScreen gui, ResourceLocation jsonGuiDefinition) {
        super(gui);
        this.context.putConstant("gui.mouse", IGuiPosition.class, this.mouse);
        this.context.putConstant("gui.area", IGuiArea.class, this.rootElement);
        this.context.putConstant("gui.pos", IGuiPosition.class, this.rootElement);
        this.time = this.context.putVariableDouble("time");
        this.jsonGuiDefinition = jsonGuiDefinition;
    }

    public BuildCraftJsonGui(GuiScreen gui, IGuiArea rootElement, ResourceLocation jsonGuiDefinition) {
        super(gui, rootElement);
        this.context.putConstant("gui.mouse", IGuiPosition.class, this.mouse);
        this.context.putConstant("gui.area", IGuiArea.class, this.rootElement);
        this.context.putConstant("gui.pos", IGuiPosition.class, this.rootElement);
        this.time = this.context.putVariableDouble("time");
        this.jsonGuiDefinition = jsonGuiDefinition;
    }

    public final void load() {
        ResourceLoaderContext loadHistory = new ResourceLoaderContext();
        try (InputStreamReader reader = loadHistory.startLoading(this.jsonGuiDefinition);){
            JsonObject obj = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
            JsonGuiInfo info = new JsonGuiInfo(obj, this.context, loadHistory);
            this.sizeX = (int)GenericExpressionCompiler.compileExpressionLong(info.sizeX, this.context).evaluate();
            this.sizeY = (int)GenericExpressionCompiler.compileExpressionLong(info.sizeY, this.context).evaluate();
            this.varData.setNodes(info.createTickableNodes());
            for (JsonGuiElement elem : info.elements) {
                String typeName = elem.properties.get("type");
                ElementType type = JsonGuiTypeRegistry.TYPES.get(typeName);
                if (type == null) {
                    BCLog.logger.warn("Unknown type " + typeName);
                    continue;
                }
                IGuiElement e = type.deserialize(this, this.rootElement, info, elem);
                String parent = elem.properties.get("parent");
                IContainingElement p = this.properties.get("custom." + parent, IContainingElement.class);
                this.properties.put("custom." + elem.name, e);
                if (p == null) {
                    this.shownElements.add(e);
                    continue;
                }
                p.getChildElements().add(e);
                p.calculateSizes();
            }
        }
        catch (InvalidExpressionException iee) {
            throw new JsonSyntaxException("Failed to resolve the size of " + this.jsonGuiDefinition, (Throwable)iee);
        }
        catch (IOException e) {
            throw new Error(e);
        }
        loadHistory.finishLoading();
    }

    public int getSizeX() {
        return this.sizeX;
    }

    public int getSizeY() {
        return this.sizeY;
    }

    @Override
    public void tick() {
        super.tick();
        ++this.timeOpen;
        this.varData.tick();
    }

    @Override
    public void drawBackgroundLayer(float partialTicks, int mouseX, int mouseY, Runnable backgroundRenderer) {
        this.time.value = (float)this.timeOpen + partialTicks;
        this.varData.refresh();
        super.drawBackgroundLayer(partialTicks, mouseX, mouseY, backgroundRenderer);
    }
}

