/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui;

import buildcraft.lib.BCLibSprites;
import buildcraft.lib.expression.api.IVariableNode;
import buildcraft.lib.gui.GuiSpriteScaled;
import buildcraft.lib.gui.IGuiElement;
import buildcraft.lib.gui.IInteractionElement;
import buildcraft.lib.gui.IMenuElement;
import buildcraft.lib.gui.ITooltipElement;
import buildcraft.lib.gui.config.GuiConfigManager;
import buildcraft.lib.gui.elem.ToolTip;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.gui.pos.MousePosition;
import buildcraft.lib.misc.GuiUtil;
import gnu.trove.set.hash.TIntHashSet;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.ResourceLocation;

public class BuildCraftGui {
    public static final IVariableNode.IVariableNodeBoolean isDebuggingEnabled;
    public static final IVariableNode.IVariableNodeBoolean isDebuggingShown;
    public static final GuiSpriteScaled SPRITE_DEBUG;
    public final Minecraft mc = Minecraft.func_71410_x();
    public final GuiScreen gui;
    public final MousePosition mouse = new MousePosition();
    public final IGuiArea screenElement;
    public final IGuiArea rootElement;
    public final List<IGuiElement> shownElements = new ArrayList<IGuiElement>();
    public IMenuElement currentMenu;
    public IGuiPosition lowerLeftLedgerPos;
    public IGuiPosition lowerRightLedgerPos;
    private float lastPartialTicks;

    public BuildCraftGui(GuiScreen gui, IGuiArea rootElement) {
        this.gui = gui;
        this.screenElement = GuiUtil.AREA_WHOLE_SCREEN;
        this.rootElement = rootElement;
        this.lowerLeftLedgerPos = rootElement.offset(0.0, 5.0);
        this.lowerRightLedgerPos = rootElement.getPosition(1, -1).offset(0.0, 5.0);
    }

    public BuildCraftGui(GuiScreen gui) {
        this.gui = gui;
        this.rootElement = this.screenElement = GuiUtil.AREA_WHOLE_SCREEN;
        this.lowerLeftLedgerPos = this.screenElement.getPosition(1, -1).offset(-5.0, 5.0);
        this.lowerRightLedgerPos = this.screenElement.offset(5.0, 5.0);
    }

    public static IGuiArea createWindowedArea(GuiContainer gui) {
        return IGuiArea.create(() -> ((GuiContainer)gui).getGuiLeft(), () -> ((GuiContainer)gui).getGuiTop(), () -> ((GuiContainer)gui).getXSize(), () -> ((GuiContainer)gui).getYSize());
    }

    public final float getLastPartialTicks() {
        return this.lastPartialTicks;
    }

    public void tick() {
        if (this.currentMenu != null) {
            this.currentMenu.tick();
        }
        for (IGuiElement element : this.shownElements) {
            element.tick();
        }
    }

    public List<IGuiElement> getElementsAt(double x, double y) {
        ArrayList<IGuiElement> elements = new ArrayList<IGuiElement>();
        IMenuElement m = this.currentMenu;
        if (m != null) {
            elements.addAll(m.getThisAndChildrenAt(x, y));
            if (m.shouldFullyOverride()) {
                return elements;
            }
        }
        for (IGuiElement elem : this.shownElements) {
            elements.addAll(elem.getThisAndChildrenAt(x, y));
        }
        return elements;
    }

    private List<ToolTip> getAllTooltips() {
        ArrayList<ToolTip> tooltips = new ArrayList<ToolTip>();
        IMenuElement m = this.currentMenu;
        if (m != null) {
            m.addToolTips(tooltips);
            if (m.shouldFullyOverride()) {
                return tooltips;
            }
        }
        if (this.gui instanceof ITooltipElement) {
            ((ITooltipElement)this.gui).addToolTips(tooltips);
        }
        for (IGuiElement elem : this.shownElements) {
            elem.addToolTips(tooltips);
        }
        return tooltips;
    }

    private int drawTooltip(ToolTip tooltip, double x, double y) {
        int _x = (int)Math.round(x);
        int _y = (int)Math.round(y);
        int _w = (int)Math.round(this.screenElement.getWidth());
        int _h = (int)Math.round(this.screenElement.getHeight());
        return 4 + GuiUtil.drawHoveringText((List<String>)((Object)tooltip), _x, _y, _w, _h, -1, this.mc.field_71466_p);
    }

    public void drawBackgroundLayer(float partialTicks, int mouseX, int mouseY, Runnable menuBackgroundRenderer) {
        partialTicks = this.mc.func_184121_ak();
        RenderHelper.func_74518_a();
        this.lastPartialTicks = partialTicks;
        this.mouse.setMousePosition(mouseX, mouseY);
        if (this.currentMenu == null || !this.currentMenu.shouldFullyOverride()) {
            menuBackgroundRenderer.run();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (isDebuggingShown.evaluate()) {
            SPRITE_DEBUG.drawAt(0.0, 0.0);
            if (isDebuggingEnabled.evaluate()) {
                Gui.func_73734_a((int)0, (int)0, (int)16, (int)16, (int)0x33FFFFFF);
                if (this.rootElement != this.screenElement) {
                    int w = 320;
                    int h = 240;
                    int sx = (int)((this.rootElement.getWidth() - (double)w) / 2.0);
                    int sy = (int)((this.rootElement.getHeight() - (double)h) / 2.0);
                    int ex = sx + w + 1;
                    int ey = sy + h + 1;
                    Gui.func_73734_a((int)(--sx), (int)(--sy), (int)(ex + 1), (int)(sy + 1), (int)-1);
                    Gui.func_73734_a((int)sx, (int)ey, (int)(ex + 1), (int)(ey + 1), (int)-1);
                    Gui.func_73734_a((int)sx, (int)sy, (int)(sx + 1), (int)(ey + 1), (int)-1);
                    Gui.func_73734_a((int)ex, (int)sy, (int)(ex + 1), (int)(ey + 1), (int)-1);
                }
            }
        }
    }

    public void drawElementBackgrounds() {
        for (IGuiElement element : this.shownElements) {
            if (element == this.currentMenu) continue;
            element.drawBackground(this.lastPartialTicks);
        }
    }

    public void preDrawForeground() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-this.rootElement.getX()), (double)(-this.rootElement.getY()), (double)0.0);
    }

    public void postDrawForeground() {
        GlStateManager.func_179121_F();
    }

    public void drawElementForegrounds(Runnable menuBackgroundRenderer) {
        for (IGuiElement element : this.shownElements) {
            if (element == this.currentMenu) continue;
            element.drawForeground(this.lastPartialTicks);
        }
        IMenuElement m = this.currentMenu;
        if (m != null) {
            if (m.shouldFullyOverride() && menuBackgroundRenderer != null) {
                GlStateManager.func_179097_i();
                menuBackgroundRenderer.run();
                GlStateManager.func_179126_j();
            }
            m.drawBackground(this.lastPartialTicks);
            m.drawForeground(this.lastPartialTicks);
        }
        GuiUtil.drawVerticallyAppending(this.mouse, this.getAllTooltips(), this::drawTooltip);
        if (isDebuggingEnabled.evaluate()) {
            int x = 6;
            int y = 18;
            ArrayList<String> info = new ArrayList<String>();
            TIntHashSet xAxisFilled = new TIntHashSet();
            FontRenderer fr = this.mc.field_71466_p;
            for (IGuiElement elem : this.getElementsAt(this.mouse.getX(), this.mouse.getY())) {
                int mx;
                String name = elem.getDebugInfo(info);
                int sx = (int)elem.getX();
                int sy = (int)elem.getY();
                int ex = sx + (int)elem.getWidth() + 1;
                int ey = sy + (int)elem.getHeight() + 1;
                int colour = name.hashCode() | 0xFF000000;
                float[] hsb = Color.RGBtoHSB(colour & 0xFF, colour >> 8 & 0xFF, colour >> 16 & 0xFF, null);
                int colourDark = Color.HSBtoRGB(hsb[0], hsb[1], Math.max(hsb[2] - 0.25f, 0.0f)) | 0xFF000000;
                Gui.func_73734_a((int)(--sx), (int)(--sy), (int)(ex + 1), (int)(sy + 1), (int)colour);
                Gui.func_73734_a((int)sx, (int)ey, (int)(ex + 1), (int)(ey + 1), (int)colour);
                Gui.func_73734_a((int)sx, (int)sy, (int)(sx + 1), (int)(ey + 1), (int)colour);
                Gui.func_73734_a((int)ex, (int)sy, (int)(ex + 1), (int)(ey + 1), (int)colour);
                Gui.func_73734_a((int)(sx - 1), (int)(sy - 1), (int)(ex + 2), (int)sy, (int)colourDark);
                Gui.func_73734_a((int)(sx - 1), (int)(ey + 1), (int)(ex + 2), (int)(ey + 2), (int)colourDark);
                Gui.func_73734_a((int)(sx - 1), (int)(sy - 1), (int)sx, (int)(ey + 2), (int)colourDark);
                Gui.func_73734_a((int)(ex + 1), (int)(sy - 1), (int)(ex + 2), (int)(ey + 2), (int)colourDark);
                fr.func_175063_a(name, (float)x, (float)y, -1);
                int w = fr.func_78256_a(name) + 3;
                for (int x2 = mx = sx + 3 >> 2 << 2; x2 < ex; x2 += 4) {
                    if (!xAxisFilled.add(x2)) continue;
                    mx = x2;
                    break;
                }
                GuiUtil.drawHorizontalLine(x + w, mx, y + 4, colour);
                GuiUtil.drawVerticalLine(mx, y + 4, sy, colour);
                y += fr.field_78288_b + 2;
                for (String line : info) {
                    fr.func_175063_a(line, (float)(x + 7), (float)y, -1);
                    y += fr.field_78288_b + 2;
                }
                info.clear();
            }
        }
    }

    public boolean onMouseClicked(int mouseX, int mouseY, int mouseButton) {
        IMenuElement m;
        GuiRectangle debugRect;
        this.mouse.setMousePosition(mouseX, mouseY);
        if (isDebuggingShown.evaluate() && (debugRect = new GuiRectangle(0.0, 0.0, 16.0, 16.0)).contains(this.mouse)) {
            isDebuggingEnabled.set(!isDebuggingEnabled.evaluate());
        }
        if ((m = this.currentMenu) != null) {
            m.onMouseClicked(mouseButton);
            if (m.shouldFullyOverride()) {
                return true;
            }
        }
        for (IGuiElement element : this.shownElements) {
            if (!(element instanceof IInteractionElement)) continue;
            ((IInteractionElement)element).onMouseClicked(mouseButton);
        }
        return false;
    }

    public void onMouseDragged(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        this.mouse.setMousePosition(mouseX, mouseY);
        IMenuElement m = this.currentMenu;
        if (m != null) {
            m.onMouseDragged(clickedMouseButton, timeSinceLastClick);
            if (m.shouldFullyOverride()) {
                return;
            }
        }
        for (IGuiElement element : this.shownElements) {
            if (!(element instanceof IInteractionElement)) continue;
            ((IInteractionElement)element).onMouseDragged(clickedMouseButton, timeSinceLastClick);
        }
    }

    public void onMouseReleased(int mouseX, int mouseY, int state) {
        this.mouse.setMousePosition(mouseX, mouseY);
        IMenuElement m = this.currentMenu;
        if (m != null) {
            m.onMouseReleased(state);
            if (m.shouldFullyOverride()) {
                return;
            }
        }
        for (IGuiElement element : this.shownElements) {
            if (!(element instanceof IInteractionElement)) continue;
            ((IInteractionElement)element).onMouseReleased(state);
        }
    }

    public boolean onKeyTyped(char typedChar, int keyCode) {
        boolean action = false;
        IMenuElement m = this.currentMenu;
        if (m != null && (action = m.onKeyPress(typedChar, keyCode)) && m.shouldFullyOverride()) {
            return true;
        }
        for (IGuiElement element : this.shownElements) {
            if (!(element instanceof IInteractionElement)) continue;
            action |= ((IInteractionElement)element).onKeyPress(typedChar, keyCode);
        }
        return action;
    }

    static {
        ResourceLocation debugDef = new ResourceLocation("buildcraftlib", "base");
        isDebuggingShown = GuiConfigManager.getOrAddBoolean(debugDef, "debugging_is_shown", false);
        isDebuggingEnabled = GuiConfigManager.getOrAddBoolean(debugDef, "debugging_is_enabled", false);
        SPRITE_DEBUG = new GuiSpriteScaled(BCLibSprites.DEBUG, 16.0, 16.0);
    }
}

