/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.delta;

import buildcraft.lib.delta.DeltaInt;
import buildcraft.lib.net.IPayloadWriter;
import buildcraft.lib.net.PacketBufferBC;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public class DeltaManager {
    private final IDeltaMessageSender sender;
    private final Map<EnumNetworkVisibility, List<DeltaInt>> deltas = new EnumMap<EnumNetworkVisibility, List<DeltaInt>>(EnumNetworkVisibility.class);

    public DeltaManager(IDeltaMessageSender sender) {
        this.sender = sender;
        this.deltas.put(EnumNetworkVisibility.NONE, new ArrayList());
        this.deltas.put(EnumNetworkVisibility.GUI_ONLY, new ArrayList());
        this.deltas.put(EnumNetworkVisibility.RENDER, new ArrayList());
    }

    public DeltaInt addDelta(String name, EnumNetworkVisibility visibility) {
        DeltaInt delta = new DeltaInt(name, visibility, this);
        this.deltas.get((Object)visibility).add(delta);
        return delta;
    }

    public void tick() {
        for (List<DeltaInt> innerList : this.deltas.values()) {
            for (DeltaInt delta : innerList) {
                delta.tick();
            }
        }
    }

    public void receiveDeltaData(boolean gui, EnumDeltaMessage type, PacketBuffer buffer) {
        EnumNetworkVisibility visibility;
        EnumNetworkVisibility enumNetworkVisibility = visibility = gui ? EnumNetworkVisibility.GUI_ONLY : EnumNetworkVisibility.RENDER;
        if (type == EnumDeltaMessage.CURRENT_STATE) {
            for (DeltaInt delta : this.deltas.get((Object)visibility)) {
                delta.receiveData(EnumDeltaMessage.CURRENT_STATE, buffer);
            }
        } else {
            short index = buffer.readUnsignedByte();
            DeltaInt delta = this.deltas.get((Object)visibility).get(index);
            delta.receiveData(type, buffer);
        }
    }

    void sendDeltaMessage(EnumDeltaMessage type, DeltaInt from, IPayloadWriter writer) {
        EnumNetworkVisibility visibility = from.visibility;
        if (visibility == EnumNetworkVisibility.NONE) {
            return;
        }
        boolean gui = visibility == EnumNetworkVisibility.GUI_ONLY;
        int index = this.deltas.get((Object)from.visibility).indexOf(from);
        if (index == -1) {
            throw new IllegalArgumentException("Unknown delta!");
        }
        this.sender.sendDeltaMessage(gui, type, (PacketBufferBC buffer) -> {
            buffer.writeByte(index);
            writer.write(buffer);
        });
    }

    public void writeDeltaState(boolean gui, PacketBuffer buffer) {
        EnumNetworkVisibility visibility = gui ? EnumNetworkVisibility.GUI_ONLY : EnumNetworkVisibility.RENDER;
        for (DeltaInt delta : this.deltas.get((Object)visibility)) {
            delta.writeState(buffer);
        }
    }

    public void readFromNBT(NBTTagCompound nbt) {
        for (List<DeltaInt> innerList : this.deltas.values()) {
            for (DeltaInt delta : innerList) {
                delta.readFromNBT(nbt.func_74775_l(delta.name));
            }
        }
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        for (List<DeltaInt> innerList : this.deltas.values()) {
            for (DeltaInt delta : innerList) {
                nbt.func_74782_a(delta.name, (NBTBase)delta.writeToNBT());
            }
        }
        return nbt;
    }

    public static interface IDeltaMessageSender {
        public void sendDeltaMessage(boolean var1, EnumDeltaMessage var2, IPayloadWriter var3);
    }

    public static enum EnumNetworkVisibility {
        NONE,
        GUI_ONLY,
        RENDER;

    }

    public static enum EnumDeltaMessage {
        ADD_SINGLE,
        SET_VALUE,
        CURRENT_STATE;

    }
}

