/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.model.json;

import buildcraft.lib.client.model.ResourceLoaderContext;
import buildcraft.lib.client.model.json.JsonModelPart;
import buildcraft.lib.misc.JsonUtil;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class JsonModel {
    public final boolean ambientOcclusion;
    public final Map<String, String> textures;
    public final JsonModelPart[] cutoutElements;
    public final JsonModelPart[] translucentElements;

    public static JsonModel deserialize(ResourceLocation from) throws JsonParseException, IOException {
        return JsonModel.deserialize(from, new ResourceLoaderContext());
    }

    /*
     * Loose catch block
     */
    public static JsonModel deserialize(ResourceLocation from, ResourceLoaderContext ctx) throws JsonParseException, IOException {
        try {
            try (InputStreamReader isr = ctx.startLoading(from);){
                JsonModel jsonModel = new JsonModel((JsonObject)new Gson().fromJson((Reader)isr, JsonObject.class), ctx);
                return jsonModel;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ctx.finishLoading();
        }
    }

    public static void deserializePart(List<JsonModelPart> to, boolean translucent, JsonElement json, ResourceLoaderContext ctx) throws JsonParseException, IOException {
        if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
            String str = json.getAsString();
            ResourceLocation parent = new ResourceLocation(str);
            JsonModel model = JsonModel.deserialize(parent, ctx);
            if (translucent) {
                Collections.addAll(to, model.translucentElements);
            } else {
                Collections.addAll(to, model.cutoutElements);
            }
        } else {
            to.add(new JsonModelPart(json, ctx));
        }
    }

    private static JsonModelPart[] deserializePartArray(JsonObject json, String member, boolean translucent, ResourceLoaderContext ctx) throws JsonParseException, IOException {
        if (!json.has(member)) {
            throw new JsonSyntaxException("Did not have '" + member + "' in '" + json + "'");
        }
        JsonElement elem = json.get(member);
        if (!elem.isJsonArray()) {
            throw new JsonSyntaxException("Expected an array, got '" + elem + "'");
        }
        JsonArray array = elem.getAsJsonArray();
        ArrayList<JsonModelPart> to = new ArrayList<JsonModelPart>(array.size());
        for (int i = 0; i < array.size(); ++i) {
            JsonModel.deserializePart(to, translucent, array.get(i), ctx);
        }
        return to.toArray(new JsonModelPart[to.size()]);
    }

    public JsonModel(JsonObject obj, ResourceLoaderContext ctx) throws JsonParseException, IOException {
        this.ambientOcclusion = JsonUtils.func_151209_a((JsonObject)obj, (String)"ambientocclusion", (boolean)false);
        this.textures = JsonUtil.getSubAsImmutableMap(obj, "textures", new TypeToken<HashMap<String, String>>(){});
        if (obj.has("elements")) {
            this.cutoutElements = JsonModel.deserializePartArray(obj, "elements", false, ctx);
            this.translucentElements = new JsonModelPart[0];
        } else {
            this.cutoutElements = JsonModel.deserializePartArray(obj, "cutout", false, ctx);
            this.translucentElements = JsonModel.deserializePartArray(obj, "translucent", true, ctx);
        }
    }
}

