/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.model;

import buildcraft.lib.client.model.IModelCache;
import buildcraft.lib.client.model.ModelCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;

public class ModelCacheMultipleSame<K, T>
implements IModelCache<K> {
    private final IModelCache<K> mainCache = new ModelCache<Object>(this::load);
    private final IModelKeyMultipleSameMapper<K, T> mapper;
    private final IModelCache<T> separateCache;

    public ModelCacheMultipleSame(IModelKeyMultipleSameMapper<K, T> mapper, IModelCache<T> separateCache) {
        this.mapper = mapper;
        this.separateCache = separateCache;
    }

    private List<BakedQuad> load(K key) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (T to : this.mapper.map(key)) {
            quads.addAll(this.separateCache.bake(to));
        }
        return quads;
    }

    @Override
    public List<BakedQuad> bake(K key) {
        if (ModelCache.cacheJoined) {
            return this.mainCache.bake(key);
        }
        return this.load(key);
    }

    @Override
    public void clear() {
        this.mainCache.clear();
        this.separateCache.clear();
    }

    public static interface IModelKeyMultipleSameMapper<F, T> {
        public Collection<T> map(F var1);
    }
}

