/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.chunkload;

import buildcraft.api.core.BCLog;
import buildcraft.lib.BCLib;
import buildcraft.lib.BCLibConfig;
import buildcraft.lib.chunkload.IChunkLoadingTile;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.data.WorldPos;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class ChunkLoaderManager {
    private static final Map<WorldPos, ForgeChunkManager.Ticket> TICKETS = new HashMap<WorldPos, ForgeChunkManager.Ticket>();

    public static <T extends TileEntity> void loadChunksForTile(T tile) {
        if (!ChunkLoaderManager.canLoadFor((IChunkLoadingTile)tile)) {
            ChunkLoaderManager.releaseChunksFor(tile);
            return;
        }
        ChunkLoaderManager.updateChunksFor(tile);
    }

    public static <T extends TileEntity> void releaseChunksFor(T tile) {
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)TICKETS.remove(new WorldPos(tile)));
    }

    private static <T extends TileEntity> void updateChunksFor(T tile) {
        WorldPos wPos = new WorldPos(tile);
        ForgeChunkManager.Ticket ticket = TICKETS.get(wPos);
        if (ticket == null) {
            ticket = ForgeChunkManager.requestTicket((Object)BCLib.INSTANCE, (World)tile.func_145831_w(), (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
            if (ticket == null) {
                BCLog.logger.warn("[lib.chunkloading] Failed to chunkload " + tile.getClass().getName() + " at " + tile.func_174877_v());
                return;
            }
            ticket.getModData().func_74782_a("location", (NBTBase)NBTUtilBC.writeBlockPos(tile.func_174877_v()));
            TICKETS.put(wPos, ticket);
        }
        Set<ChunkPos> chunks = ChunkLoaderManager.getChunksToLoad(tile);
        for (ChunkPos pos : ticket.getChunkList()) {
            if (chunks.contains(pos)) continue;
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)pos);
        }
        for (ChunkPos pos : chunks) {
            if (ticket.getChunkList().contains((Object)pos)) continue;
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)pos);
        }
    }

    public static <T extends TileEntity> Set<ChunkPos> getChunksToLoad(T tile) {
        Set<ChunkPos> chunksToLoad = ((IChunkLoadingTile)tile).getChunksToLoad();
        HashSet<ChunkPos> chunkPoses = new HashSet<ChunkPos>(chunksToLoad != null ? chunksToLoad : Collections.emptyList());
        chunkPoses.add(new ChunkPos(tile.func_174877_v()));
        return chunkPoses;
    }

    public static void rebindTickets(List<ForgeChunkManager.Ticket> tickets, World world) {
        TICKETS.clear();
        if (BCLibConfig.chunkLoadingLevel != BCLibConfig.ChunkLoaderLevel.NONE) {
            for (ForgeChunkManager.Ticket ticket : tickets) {
                BlockPos pos = NBTUtilBC.readBlockPos(ticket.getModData().func_74781_a("location"));
                if (pos == null) {
                    ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
                    continue;
                }
                WorldPos wPos = new WorldPos(world, pos);
                if (TICKETS.containsKey(wPos)) {
                    ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
                    continue;
                }
                TileEntity tile = world.func_175625_s(pos);
                if (tile == null || !(tile instanceof IChunkLoadingTile) || !ChunkLoaderManager.canLoadFor((IChunkLoadingTile)tile)) {
                    TICKETS.remove(wPos);
                    ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
                    continue;
                }
                TICKETS.put(wPos, ticket);
                for (ChunkPos chunkPos : ChunkLoaderManager.getChunksToLoad((TileEntity)((IChunkLoadingTile)tile))) {
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)chunkPos);
                }
            }
        }
    }

    private static boolean canLoadFor(IChunkLoadingTile tile) {
        return BCLibConfig.chunkLoadingLevel.canLoad(tile.getLoadType());
    }
}

