/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;
import slimeknights.mantle.client.CreativeTab;

public final class RecipeUtil {
    private static String[] orePreferences = new String[0];
    private static Map<String, ItemStack> preferenceCache = new HashMap<String, ItemStack>();

    private RecipeUtil() {
    }

    public static void setOrePreferences(String[] preferences) {
        orePreferences = preferences;
    }

    public static ItemStack getPreference(String oreName) {
        return preferenceCache.computeIfAbsent(oreName, RecipeUtil::cachePreference);
    }

    private static ItemStack cachePreference(String oreName) {
        NonNullList items = OreDictionary.getOres((String)oreName, (boolean)false);
        if (items.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack preference = null;
        for (String mod : orePreferences) {
            Optional<ItemStack> optional = items.stream().filter(stack -> stack.func_77973_b().getRegistryName().func_110624_b().equals(mod)).findFirst();
            if (!optional.isPresent()) continue;
            preference = optional.get();
            break;
        }
        if (preference == null) {
            preference = (ItemStack)items.get(0);
        }
        if (preference.func_77960_j() == Short.MAX_VALUE) {
            NonNullList subItems = NonNullList.func_191196_a();
            preference.func_77973_b().func_150895_a(CreativeTab.field_78027_g, subItems);
            if (subItems.isEmpty()) {
                preference = preference.func_77946_l();
                preference.func_77964_b(0);
            } else {
                preference = (ItemStack)subItems.get(0);
            }
        }
        return preference;
    }
}

