/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ShapedFallbackRecipe
extends ShapedOreRecipe {
    private Ingredient[] ignore;
    private int need;

    public ShapedFallbackRecipe(ResourceLocation group, ItemStack result, CraftingHelper.ShapedPrimer primer, Ingredient[] ignore, int need) {
        super(group, result, primer);
        this.ignore = ignore;
        this.need = need;
    }

    public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World world) {
        if (!super.func_77569_a(inv, world)) {
            return false;
        }
        int[] matches = new int[this.ignore.length];
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            for (int s = 0; s < this.ignore.length; ++s) {
                if (!this.ignore[s].apply(stack)) continue;
                int n = s;
                matches[n] = matches[n] + 1;
                if (matches[s] < this.need) continue;
                return false;
            }
        }
        return true;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            ShapedOreRecipe recipe = ShapedOreRecipe.factory((JsonContext)context, (JsonObject)json);
            CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
            primer.width = recipe.getRecipeWidth();
            primer.height = recipe.getRecipeHeight();
            primer.mirrored = JsonUtils.func_151209_a((JsonObject)json, (String)"mirrored", (boolean)true);
            primer.input = recipe.func_192400_c();
            ResourceLocation group = recipe.func_193358_e().isEmpty() ? null : new ResourceLocation(recipe.func_193358_e());
            JsonArray elements = JsonUtils.func_151214_t((JsonObject)json, (String)"ignore");
            Ingredient[] ignore = new Ingredient[elements.size()];
            int i = 0;
            for (JsonElement ele : elements) {
                ignore[i++] = CraftingHelper.getIngredient((JsonElement)ele, (JsonContext)context);
            }
            int need = JsonUtils.func_151208_a((JsonObject)json, (String)"need", (int)1);
            return new ShapedFallbackRecipe(group, recipe.func_77571_b(), primer, ignore, need);
        }
    }
}

