/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.debug;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.utils.ToolHelper;
import slimeknights.tconstruct.tools.harvest.TinkerHarvestTools;

public class FindBestTool
extends CommandBase {
    public int func_82362_a() {
        return 0;
    }

    public String func_71517_b() {
        return "findBestTool";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/findBestTool [number of tools to display] <filter type>";
    }

    public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
        StringBuilder text;
        Triple foo;
        int i;
        Collection best;
        int filtertype;
        int num;
        if (args.length < 1) {
            throw new CommandException("Too few arguments", new Object[0]);
        }
        if (args.length < 2) {
            num = 100;
            filtertype = Integer.valueOf(args[0]);
        } else {
            num = Integer.valueOf(args[0]);
            filtertype = Integer.valueOf(args[1]);
        }
        Predicate[] filter = new Predicate[3];
        if (num < 0 || filtertype < 0 || filtertype > filter.length) {
            throw new CommandException("Inavlid arguments", new Object[0]);
        }
        ToolCore tool = TinkerHarvestTools.pickaxe;
        ArrayList results = Lists.newArrayList();
        Function[] functions = new Function[]{new Function<ItemStack, Integer>(){

            public Integer apply(ItemStack itemStack) {
                return ToolHelper.getDurabilityStat(itemStack);
            }
        }, new Function<ItemStack, Float>(){

            public Float apply(ItemStack itemStack) {
                return Float.valueOf(ToolHelper.getMiningSpeedStat(itemStack));
            }
        }, new Function<ItemStack, Float>(){

            public Float apply(ItemStack itemStack) {
                return Float.valueOf(ToolHelper.getAttackStat(itemStack));
            }
        }};
        this.recurse(tool, (ImmutableList<Material>)ImmutableList.of(), results, functions);
        List durabilities = Lists.transform((List)results, (Function)new Function<Triple<ItemStack, ImmutableList<Material>, Object[]>, Integer>(){

            @Nullable
            public Integer apply(Triple<ItemStack, ImmutableList<Material>, Object[]> input) {
                return (Integer)((Object[])input.getRight())[0];
            }
        });
        List speeds = Lists.transform((List)results, (Function)new Function<Triple<ItemStack, ImmutableList<Material>, Object[]>, Float>(){

            @Nullable
            public Float apply(Triple<ItemStack, ImmutableList<Material>, Object[]> input) {
                return (Float)((Object[])input.getRight())[1];
            }
        });
        List attacks = Lists.transform((List)results, (Function)new Function<Triple<ItemStack, ImmutableList<Material>, Object[]>, Float>(){

            @Nullable
            public Float apply(Triple<ItemStack, ImmutableList<Material>, Object[]> input) {
                return (Float)((Object[])input.getRight())[2];
            }
        });
        float percentile = 0.5f;
        int durPercentile = (int)this.getPercentile(Ordering.natural().reverse().sortedCopy((Iterable)durabilities), percentile);
        float speedPercentile = (float)this.getPercentile(Ordering.natural().reverse().sortedCopy((Iterable)speeds), percentile);
        float attackPercentile = (float)this.getPercentile(Ordering.natural().reverse().sortedCopy((Iterable)attacks), percentile);
        do {
            final int durPercentile2 = (int)this.getPercentile(Ordering.natural().reverse().sortedCopy((Iterable)durabilities), percentile /= 2.0f);
            final float speedPercentile2 = (float)this.getPercentile(Ordering.natural().reverse().sortedCopy((Iterable)speeds), percentile);
            final float attackPercentile2 = (float)this.getPercentile(Ordering.natural().reverse().sortedCopy((Iterable)attacks), percentile);
            durPercentile = durPercentile2;
            speedPercentile = speedPercentile2;
            attackPercentile = attackPercentile2;
            filter[0] = new Predicate<Triple<ItemStack, ImmutableList<Material>, Object[]>>(){

                public boolean apply(@Nullable Triple<ItemStack, ImmutableList<Material>, Object[]> entry) {
                    return (Integer)((Object[])entry.getRight())[0] > durPercentile2 && ((Float)((Object[])entry.getRight())[1]).floatValue() > speedPercentile2;
                }
            };
            filter[1] = new Predicate<Triple<ItemStack, ImmutableList<Material>, Object[]>>(){

                public boolean apply(@Nullable Triple<ItemStack, ImmutableList<Material>, Object[]> entry) {
                    return (Integer)((Object[])entry.getRight())[0] > durPercentile2 && ((Float)((Object[])entry.getRight())[2]).floatValue() > attackPercentile2;
                }
            };
            filter[2] = new Predicate<Triple<ItemStack, ImmutableList<Material>, Object[]>>(){

                public boolean apply(@Nullable Triple<ItemStack, ImmutableList<Material>, Object[]> entry) {
                    return (Integer)((Object[])entry.getRight())[0] > durPercentile2 && ((Float)((Object[])entry.getRight())[1]).floatValue() > speedPercentile2 && ((Float)((Object[])entry.getRight())[2]).floatValue() > attackPercentile2;
                }
            };
        } while ((best = Collections2.filter((Collection)results, (Predicate)filter[filtertype])).size() > num);
        sender.func_145747_a((ITextComponent)new TextComponentString(String.format("%d are in the top %d percentile of stats (%d; %f; %f)", best.size(), (int)(percentile * 100.0f), durPercentile, Float.valueOf(speedPercentile), Float.valueOf(attackPercentile))));
        List sortedDurability = new Ordering<Triple<ItemStack, ImmutableList<Material>, Object[]>>(){

            public int compare(@Nullable Triple<ItemStack, ImmutableList<Material>, Object[]> left, @Nullable Triple<ItemStack, ImmutableList<Material>, Object[]> right) {
                return (Integer)((Object[])right.getRight())[0] - (Integer)((Object[])left.getRight())[0];
            }
        }.sortedCopy((Iterable)best);
        List sortedSpeed = new Ordering<Triple<ItemStack, ImmutableList<Material>, Object[]>>(){

            public int compare(@Nullable Triple<ItemStack, ImmutableList<Material>, Object[]> left, @Nullable Triple<ItemStack, ImmutableList<Material>, Object[]> right) {
                return (int)(((Float)((Object[])right.getRight())[1]).floatValue() * 10.0f) - (int)(((Float)((Object[])left.getRight())[1]).floatValue() * 10.0f);
            }
        }.sortedCopy((Iterable)best);
        List sortedAttack = new Ordering<Triple<ItemStack, ImmutableList<Material>, Object[]>>(){

            public int compare(@Nullable Triple<ItemStack, ImmutableList<Material>, Object[]> left, @Nullable Triple<ItemStack, ImmutableList<Material>, Object[]> right) {
                return (int)(((Float)((Object[])right.getRight())[2]).floatValue() * 10.0f) - (int)(((Float)((Object[])left.getRight())[2]).floatValue() * 10.0f);
            }
        }.sortedCopy((Iterable)best);
        for (Triple foo2 : best) {
            StringBuilder text2 = new StringBuilder();
            text2.append("Materials: ");
            for (Material mat : (ImmutableList)foo2.getMiddle()) {
                text2.append(mat.getIdentifier());
                text2.append(" ");
            }
            text2.append("- ");
            text2.append("Dur: ");
            text2.append(((Object[])foo2.getRight())[0]);
            text2.append(" Speed: ");
            text2.append(((Float)((Object[])foo2.getRight())[1]).floatValue() * tool.miningSpeedModifier());
            text2.append(" Dmg: ");
            text2.append(((Float)((Object[])foo2.getRight())[2]).floatValue() * tool.damagePotential());
            sender.func_145747_a(((ItemStack)foo2.getLeft()).func_151000_E().func_150257_a((ITextComponent)new TextComponentString(text2.toString())));
        }
        sender.func_145747_a((ITextComponent)new TextComponentString("Top 5 Durability:"));
        Iterator iter = sortedDurability.iterator();
        for (i = 0; i < 5 && iter.hasNext(); ++i) {
            foo = (Triple)iter.next();
            text = new StringBuilder();
            text.append(((Object[])foo.getRight())[0]);
            text.append(" - ");
            for (Material mat : (ImmutableList)foo.getMiddle()) {
                text.append(mat.getIdentifier());
                text.append(" ");
            }
            sender.func_145747_a(((ItemStack)foo.getLeft()).func_151000_E().func_150257_a((ITextComponent)new TextComponentString(text.toString())));
        }
        sender.func_145747_a((ITextComponent)new TextComponentString("Top 5 Speed:"));
        iter = sortedSpeed.iterator();
        for (i = 0; i < 5 && iter.hasNext(); ++i) {
            foo = (Triple)iter.next();
            text = new StringBuilder();
            text.append(((Object[])foo.getRight())[1]);
            text.append(" - ");
            for (Material mat : (ImmutableList)foo.getMiddle()) {
                text.append(mat.getIdentifier());
                text.append(" ");
            }
            sender.func_145747_a(((ItemStack)foo.getLeft()).func_151000_E().func_150257_a((ITextComponent)new TextComponentString(text.toString())));
        }
        sender.func_145747_a((ITextComponent)new TextComponentString("Top 5 Attack:"));
        iter = sortedAttack.iterator();
        for (i = 0; i < 5 && iter.hasNext(); ++i) {
            foo = (Triple)iter.next();
            text = new StringBuilder();
            text.append(((Object[])foo.getRight())[2]);
            text.append(" - ");
            for (Material mat : (ImmutableList)foo.getMiddle()) {
                text.append(mat.getIdentifier());
                text.append(" ");
            }
            sender.func_145747_a(((ItemStack)foo.getLeft()).func_151000_E().func_150257_a((ITextComponent)new TextComponentString(text.toString())));
        }
    }

    public void recurse(ToolCore tool, ImmutableList<Material> materials, List<Triple<ItemStack, ImmutableList<Material>, Object[]>> results, Function<ItemStack, ?>[] fns) {
        if (tool.getRequiredComponents().size() > materials.size()) {
            for (Material mat : TinkerRegistry.getAllMaterials()) {
                if (!mat.hasStats("head")) continue;
                ImmutableList.Builder mats = ImmutableList.builder();
                mats.addAll(materials);
                mats.add((Object)mat);
                this.recurse(tool, (ImmutableList<Material>)mats.build(), results, fns);
            }
        } else {
            ItemStack stack = tool.buildItem((List<Material>)materials);
            Object[] values = new Object[fns.length];
            for (int i = 0; i < fns.length; ++i) {
                values[i] = fns[i].apply((Object)stack);
            }
            results.add((Triple<ItemStack, ImmutableList<Material>, Object[]>)Triple.of((Object)stack, materials, (Object)values));
        }
    }

    private <T extends Number> double getPercentile(List<T> entries, float percentile) {
        int coeff = (int)(1.0f / percentile);
        if (entries.size() % 2 == 1) {
            return ((Number)entries.get(entries.size() / coeff)).doubleValue();
        }
        Number v1 = (Number)entries.get(entries.size() / coeff);
        Number v2 = (Number)entries.get(entries.size() / coeff + 1);
        return (v1.doubleValue() + v2.doubleValue()) / 2.0;
    }

    private static enum Comp implements Comparator<Pair<ImmutableList<Material>, Integer>>
    {
        INSTANCE;


        @Override
        public int compare(Pair<ImmutableList<Material>, Integer> o1, Pair<ImmutableList<Material>, Integer> o2) {
            return (Integer)o2.getRight() - (Integer)o1.getRight();
        }
    }
}

