/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.common;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.item.ItemBlockMeta;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.ClientProxy;
import slimeknights.tconstruct.library.client.model.MaterialModelLoader;
import slimeknights.tconstruct.library.client.model.ToolModelLoader;
import slimeknights.tconstruct.library.modifiers.IModifier;
import slimeknights.tconstruct.library.tools.IToolPart;
import slimeknights.tconstruct.library.tools.ToolCore;

@SideOnly(value=Side.CLIENT)
public final class ModelRegisterUtil {
    public static final String VARIANT_INVENTORY = "inventory";

    public static void registerItemModel(ItemStack itemStack, ResourceLocation name) {
        if (!itemStack.func_190926_b() && name != null) {
            ModelLoader.registerItemVariants((Item)itemStack.func_77973_b(), (ResourceLocation[])new ResourceLocation[]{name});
            ModelLoader.setCustomModelResourceLocation((Item)itemStack.func_77973_b(), (int)itemStack.func_77960_j(), (ModelResourceLocation)new ModelResourceLocation(name, VARIANT_INVENTORY));
        }
    }

    public static ResourceLocation registerItemModel(Item item) {
        ResourceLocation itemLocation = null;
        if (item != null) {
            itemLocation = item.getRegistryName();
        }
        if (itemLocation != null) {
            itemLocation = ModelRegisterUtil.registerIt(item, itemLocation);
        }
        return itemLocation;
    }

    public static ResourceLocation registerItemModel(Block block) {
        return ModelRegisterUtil.registerItemModel(Item.func_150898_a((Block)block));
    }

    public static void registerItemBlockMeta(Block block) {
        if (block != null) {
            Item item = Item.func_150898_a((Block)block);
            if (item instanceof ItemBlockMeta) {
                ((ItemBlockMeta)item).registerItemModels();
            } else {
                TConstruct.log.error("Trying to register an ItemBlockMeta model for a non itemblockmeta block: " + block.getRegistryName());
            }
        }
    }

    public static void registerItemModel(Item item, int meta) {
        ModelRegisterUtil.registerItemModel(item, meta, VARIANT_INVENTORY);
    }

    public static void registerItemModel(Item item, int meta, String variant) {
        if (item != null) {
            ModelRegisterUtil.registerItemModel(item, meta, item.getRegistryName(), variant);
        }
    }

    public static void registerItemModel(Item item, int meta, ResourceLocation location, String variant) {
        if (item != null && !StringUtils.func_151246_b((String)variant)) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), variant));
        }
    }

    public static ResourceLocation registerToolModel(ToolCore tool) {
        if (tool == null || tool.getRegistryName() == null) {
            return null;
        }
        ResourceLocation itemLocation = tool.getRegistryName();
        String path = "tools/" + itemLocation.func_110623_a() + ToolModelLoader.EXTENSION;
        ResourceLocation location = new ResourceLocation(itemLocation.func_110624_b(), path);
        ToolModelLoader.addPartMapping(location, tool);
        return ModelRegisterUtil.registerToolModel(tool, location);
    }

    public static ResourceLocation registerToolModel(Item item, ResourceLocation location) {
        if (!location.func_110623_a().endsWith(ToolModelLoader.EXTENSION)) {
            TConstruct.log.error("The material-model " + location.toString() + " does not end with '" + ToolModelLoader.EXTENSION + "' and will therefore not be loaded by the custom model loader!");
        }
        return ModelRegisterUtil.registerIt(item, location);
    }

    public static <T extends Item> ResourceLocation registerPartModel(T item) {
        if (item == null || item.getRegistryName() == null) {
            return null;
        }
        ResourceLocation itemLocation = item.getRegistryName();
        String path = "parts/" + itemLocation.func_110623_a() + MaterialModelLoader.EXTENSION;
        ResourceLocation location = new ResourceLocation(itemLocation.func_110624_b(), path);
        MaterialModelLoader.addPartMapping(location, (IToolPart)item);
        return ModelRegisterUtil.registerMaterialModel(item, location);
    }

    public static ResourceLocation registerMaterialItemModel(Item item) {
        if (item == null || item.getRegistryName() == null) {
            return null;
        }
        ResourceLocation itemLocation = item.getRegistryName();
        itemLocation = new ResourceLocation(itemLocation.func_110624_b(), itemLocation.func_110623_a() + MaterialModelLoader.EXTENSION);
        return ModelRegisterUtil.registerMaterialModel(item, itemLocation);
    }

    static ResourceLocation registerMaterialModel(Item item, ResourceLocation location) {
        if (!location.func_110623_a().endsWith(MaterialModelLoader.EXTENSION)) {
            TConstruct.log.error("The material-model " + location.toString() + " does not end with '" + MaterialModelLoader.EXTENSION + "' and will therefore not be loaded by the custom model loader!");
        }
        return ModelRegisterUtil.registerIt(item, location);
    }

    public static void registerModifierModel(IModifier modifier, ResourceLocation location) {
        ClientProxy.modifierLoader.registerModifierFile(modifier.getIdentifier(), location);
    }

    private static ResourceLocation registerIt(Item item, final ResourceLocation location) {
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)new ItemMeshDefinition(){

            @Nonnull
            public ModelResourceLocation func_178113_a(@Nonnull ItemStack stack) {
                return new ModelResourceLocation(location, ModelRegisterUtil.VARIANT_INVENTORY);
            }
        });
        ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{location});
        return location;
    }

    private ModelRegisterUtil() {
    }
}

