/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.rail;

import cam72cam.immersiverailroading.render.ExpireableMap;
import cam72cam.immersiverailroading.track.TrackBase;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.render.StandardModel;
import cam72cam.mod.render.opengl.RenderState;
import java.util.List;
import util.Matrix4;

public class RailBaseRender {
    private static final ExpireableMap<String, StandardModel> models = new ExpireableMap();

    private static StandardModel getModel(RailInfo info, List<TrackBase> tracks) {
        StandardModel model = new StandardModel();
        if (!info.settings.railBed.isEmpty()) {
            for (TrackBase base : tracks) {
                Vec3i basePos = base.getPos();
                model.addItemBlock(info.settings.railBed, new Matrix4().translate((double)basePos.x, (double)basePos.y, (double)basePos.z).scale(1.0, (double)(base.getBedHeight() + 0.1f * (float)info.settings.gauge.scale()), 1.0));
            }
        }
        return model;
    }

    public static void draw(RailInfo info, List<TrackBase> tracks, RenderState state) {
        StandardModel model = models.get(info.uniqueID);
        if (model == null) {
            model = RailBaseRender.getModel(info, tracks);
            models.put(info.uniqueID, model);
        }
        model.render(state);
    }
}

