/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.render.item;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.items.ItemRollingStockComponent;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.model.StockModel;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.render.ItemRender;
import cam72cam.mod.render.StandardModel;
import cam72cam.mod.render.obj.OBJRender;
import cam72cam.mod.render.opengl.BlendMode;
import cam72cam.mod.render.opengl.RenderState;
import cam72cam.mod.world.World;
import java.util.ArrayList;
import java.util.List;

public class StockItemComponentModel
implements ItemRender.IItemModel {
    public StandardModel getModel(World world, ItemStack stack) {
        return new StandardModel().addCustom((state, pt) -> StockItemComponentModel.render(stack, state));
    }

    public static void render(ItemStack stack, RenderState state) {
        ItemRollingStockComponent.Data data = new ItemRollingStockComponent.Data(stack);
        double itemScale = data.gauge.scale();
        if (data.def == null) {
            ImmersiveRailroading.error((String)"Item %s missing definition!", (Object[])new Object[]{stack});
            stack.setCount(0);
            return;
        }
        StockModel<?, ?> model = data.def.getModel();
        ArrayList<String> groups = new ArrayList<String>();
        for (ModelComponentType r : data.componentType.render) {
            List<ModelComponent> comp = data.def.getComponents(r);
            if (comp == null || r == ModelComponentType.CARGO_FILL_X || r == ModelComponentType.CARGO_FILL_POS_X) continue;
            groups.addAll(comp.get((int)0).modelIDs);
        }
        if (groups.isEmpty()) {
            ImmersiveRailroading.error((String)"Invalid item %s", (Object[])new Object[]{stack.toTag()});
            return;
        }
        Vec3d center = model.centerOfGroups(groups);
        double width = model.heightOfGroups(groups);
        double length = model.lengthOfGroups(groups);
        double scale = 1.0;
        if (width != 0.0 || length != 0.0) {
            scale = 0.95 / Math.max(width, length);
        }
        state.blend(BlendMode.OPAQUE).cull_face(false).lighting(false).translate(0.5, 0.5, 0.5).scale(scale *= Math.sqrt(itemScale), scale, scale).translate(-center.x, -center.y, -center.z);
        try (OBJRender.Binding vbo = model.binder().bind(state);){
            vbo.draw(groups);
        }
    }
}

