/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.physics;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.thirdparty.trackapi.ITrack;
import cam72cam.immersiverailroading.tile.TileRail;
import cam72cam.immersiverailroading.tile.TileRailBase;
import cam72cam.immersiverailroading.track.IIterableTrack;
import cam72cam.immersiverailroading.track.PosStep;
import cam72cam.immersiverailroading.util.VecUtil;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.util.Facing;
import cam72cam.mod.world.World;
import java.util.List;

public class MovementTrack {
    public static ITrack findTrack(World world, Vec3d currentPosition, float trainYaw, double gauge) {
        Vec3d[] positions = new Vec3d[]{currentPosition, currentPosition.add(VecUtil.fromWrongYaw(1.0, trainYaw)), currentPosition.add(VecUtil.fromWrongYaw(-1.0, trainYaw))};
        double[] heightSkew = new double[]{0.0, 0.25, -0.25, 0.5, -0.5, 0.75, -0.75};
        for (Vec3d pos : positions) {
            for (double height : heightSkew) {
                ITrack te = ITrack.get(world, pos.add(0.0, height + currentPosition.y % 1.0, 0.0), true);
                if (te != null && Gauge.from(te.getTrackGauge()) == Gauge.from(gauge)) {
                    return te;
                }
                TileRailBase rail = (TileRailBase)world.getBlockEntity(new Vec3i(pos).add(new Vec3i(0, (int)(height + currentPosition.y % 1.0), 0)), TileRailBase.class);
                if (rail == null || rail.getParentReplaced() == null) continue;
                return rail;
            }
        }
        return null;
    }

    public static Vec3d iterativePathing(World world, Vec3d currentPosition, ITrack te, double gauge, Vec3d motion, double maxDistance) {
        Vec3d startPos = currentPosition;
        Vec3d prevPosition = currentPosition;
        double totalDistance = motion.length();
        double maxDistanceSquared = maxDistance * maxDistance;
        double motionLengthSquared = motion.lengthSquared();
        Vec3i teBlockPosition = new Vec3i(currentPosition);
        for (double currentDistance = 0.0; currentDistance < totalDistance; currentDistance += maxDistance) {
            Vec3i currentBlockPosition = new Vec3i(currentPosition);
            if (!currentBlockPosition.equals((Object)teBlockPosition)) {
                teBlockPosition = currentBlockPosition;
                te = MovementTrack.findTrack(world, currentPosition, VecUtil.toWrongYaw(motion), gauge);
                if (te == null) {
                    return currentPosition;
                }
            }
            if (motionLengthSquared > maxDistanceSquared || motionLengthSquared < maxDistanceSquared * 0.95) {
                motion = motion.scale(maxDistance / Math.sqrt(motionLengthSquared));
            }
            if ((motionLengthSquared = (motion = (currentPosition = te instanceof TileRailBase ? ((TileRailBase)te).getNextPositionShort(currentPosition, motion) : te.getNextPosition(currentPosition, motion)).subtract(prevPosition = currentPosition)).lengthSquared()) != 0.0) continue;
            return prevPosition;
        }
        currentPosition = startPos.add(currentPosition.subtract(startPos).normalize().scale(totalDistance));
        return currentPosition;
    }

    public static Vec3d nextPositionDirect(World world, Vec3d currentPosition, TileRail rail, Vec3d delta) {
        if (rail == null) {
            if (world.isServer) {
                return null;
            }
            return currentPosition.add(delta);
        }
        double railHeight = rail.info.getTrackHeight();
        double distance = delta.length();
        double heightOffset = railHeight * rail.info.settings.gauge.scale();
        if (rail.info.settings.type == TrackItems.CROSSING) {
            delta = VecUtil.fromWrongYaw(distance, Facing.fromAngle((float)VecUtil.toWrongYaw(delta)).getAngle());
            return currentPosition.add(delta);
        }
        if (rail.info.settings.type == TrackItems.TURNTABLE) {
            double tablePos = rail.getParentTile().info.tablePos;
            currentPosition = currentPosition.add(delta);
            Vec3d center = new Vec3d(rail.getParentTile().getPos()).add(0.5, 1.0 + heightOffset, 0.5);
            double fromCenter = currentPosition.distanceTo(center);
            float angle = (float)tablePos + rail.info.placementInfo.facing().getAngle();
            Vec3d forward = center.add(VecUtil.fromWrongYaw(fromCenter, angle));
            Vec3d backward = center.add(VecUtil.fromWrongYaw(fromCenter, angle + 180.0f));
            if (forward.distanceToSquared(currentPosition) < backward.distanceToSquared(currentPosition)) {
                return forward;
            }
            return backward;
        }
        if (rail.info.getBuilder(world) instanceof IIterableTrack) {
            List<PosStep> positions = ((IIterableTrack)((Object)rail.info.getBuilder(world))).getPath(0.25 * rail.info.settings.gauge.scale());
            Vec3d center = rail.info.placementInfo.placementPosition.add(rail.getPos()).add(0.0, heightOffset, 0.0);
            Vec3d target = currentPosition.add(delta);
            Vec3d relative = target.subtract(center);
            if (positions.isEmpty()) {
                ImmersiveRailroading.error((String)"Invalid track path %s", (Object[])new Object[]{rail.info.uniqueID});
                return currentPosition;
            }
            if (positions.size() == 1) {
                PosStep pos = positions.get(0);
                Vec3d offset = VecUtil.fromYaw(delta.length(), pos.yaw);
                Vec3d result = currentPosition.add(offset);
                Vec3d resultOpposite = currentPosition.subtract(offset);
                if (result.distanceToSquared(target) < resultOpposite.distanceToSquared(target)) {
                    return result;
                }
                return resultOpposite;
            }
            int left = 0;
            double leftDistance = positions.get(left).distanceToSquared(relative);
            int right = positions.size() - 1;
            double rightDistance = positions.get(right).distanceToSquared(relative);
            while (right - left > 1) {
                if (leftDistance > rightDistance) {
                    left = (int)Math.ceil((float)left + (float)(right - left) / 3.0f);
                    leftDistance = positions.get(left).distanceToSquared(relative);
                    continue;
                }
                right = (int)Math.floor((float)right + (float)(left - right) / 3.0f);
                rightDistance = positions.get(right).distanceToSquared(relative);
            }
            if (right == left) {
                ImmersiveRailroading.warn((String)"Correcting track pathing tree...", (Object[])new Object[0]);
                if (right == positions.size() - 1) {
                    --left;
                } else {
                    ++right;
                }
            }
            PosStep leftPos = positions.get(left);
            PosStep rightPos = positions.get(right);
            if (leftDistance < 1.0E-6) {
                return center.add((Vec3d)leftPos);
            }
            if (rightDistance < 1.0E-6) {
                return center.add((Vec3d)rightPos);
            }
            Vec3d between = rightPos.subtract(leftPos);
            Vec3d offset = between.scale(Math.sqrt(leftDistance) / between.length());
            Vec3d point = center.add((Vec3d)leftPos);
            Vec3d result = point.add(offset);
            Vec3d resultOpposite = point.subtract(offset);
            if (result.distanceToSquared(target) < resultOpposite.distanceToSquared(target)) {
                return result;
            }
            return resultOpposite;
        }
        return currentPosition.add(delta);
    }
}

