/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.items;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.items.ItemTabs;
import cam72cam.immersiverailroading.library.Permissions;
import cam72cam.immersiverailroading.net.SoundPacket;
import cam72cam.mod.entity.Entity;
import cam72cam.mod.entity.Player;
import cam72cam.mod.entity.boundingbox.IBoundingBox;
import cam72cam.mod.item.CreativeTab;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.item.Fuzzy;
import cam72cam.mod.item.Recipes;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.resource.Identifier;
import cam72cam.mod.world.World;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public class ItemConductorWhistle
extends CustomItem {
    private static HashMap<UUID, Integer> cooldown = new HashMap();

    public ItemConductorWhistle() {
        super("immersiverailroading", "item_conductor_whistle");
        Fuzzy gold = Fuzzy.GOLD_INGOT;
        Recipes.shapedRecipe((CustomItem)this, (int)2, (Fuzzy[])new Fuzzy[]{gold, gold, gold, gold, gold, gold});
    }

    public int getStackSize() {
        return 1;
    }

    public List<CreativeTab> getCreativeTabs() {
        return Collections.singletonList(ItemTabs.MAIN_TAB);
    }

    public void onClickAir(Player player, World world, Player.Hand hand) {
        block12: {
            if (!world.isServer || !player.hasPermission(Permissions.CONDUCTOR)) break block12;
            if (cooldown.containsKey(player.getUUID())) {
                int newtime = cooldown.get(player.getUUID());
                if (newtime < player.getTickCount() || newtime > player.getTickCount() + 40) {
                    cooldown.remove(player.getUUID());
                } else {
                    return;
                }
            }
            cooldown.put(player.getUUID(), player.getTickCount() + 40);
            SoundPacket packet = new SoundPacket(new Identifier("immersiverailroading", "sounds/conductor_whistle.ogg"), player.getPosition(), Vec3d.ZERO, 0.7f, (float)(Math.random() / 4.0 + 0.75), (int)(Config.ConfigBalance.villagerConductorDistance * (double)1.2f), 1.0f, SoundPacket.PacketSoundCategory.WHISTLE);
            packet.sendToAllAround(world, player.getPosition(), Config.ConfigBalance.villagerConductorDistance * (double)1.2f);
            IBoundingBox bb = player.getBounds().grow(new Vec3d(Config.ConfigBalance.villagerConductorDistance, 4.0, Config.ConfigBalance.villagerConductorDistance));
            List carsNearby = world.getEntities(stock -> bb.intersects(stock.getBounds()), EntityCoupleableRollingStock.class);
            Object closestToPlayer = null;
            for (Object car : carsNearby) {
                if (closestToPlayer == null) {
                    closestToPlayer = car;
                    continue;
                }
                if (!(closestToPlayer.getPosition().distanceTo(player.getPosition()) > car.getPosition().distanceTo(player.getPosition()))) continue;
                closestToPlayer = car;
            }
            if (closestToPlayer != null) {
                if (!player.isCrouching()) {
                    List villagers = world.getEntities(x -> x.isVillager() && bb.intersects(x.getBounds()), Entity.class);
                    for (Entity villager : villagers) {
                        EntityCoupleableRollingStock closest = null;
                        for (EntityCoupleableRollingStock car : ((EntityCoupleableRollingStock)((Object)closestToPlayer)).getTrain()) {
                            if (!car.canFitPassenger(villager) || !car.getDefinition().acceptsPassengers() || closest != null && !(closest.getPosition().distanceTo(villager.getPosition()) > car.getPosition().distanceTo(villager.getPosition()))) continue;
                            closest = car;
                        }
                        if (closest == null) continue;
                        closest.addPassenger(villager);
                    }
                } else {
                    for (Object car : ((EntityCoupleableRollingStock)((Object)closestToPlayer)).getTrain()) {
                        if (!(car.getPosition().distanceTo(player.getPosition()) < Config.ConfigBalance.villagerConductorDistance)) continue;
                        for (Entity passenger : car.getPassengers()) {
                            if (!passenger.isVillager()) continue;
                            car.removePassenger(passenger);
                        }
                    }
                }
            }
        }
    }
}

