/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading;

import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.mod.config.ConfigFile;
import cam72cam.mod.item.Fuzzy;
import cam72cam.mod.item.ItemStack;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@ConfigFile.Comment(value="Configuration File")
@ConfigFile.Name(value="general")
@ConfigFile.File(value="immersiverailroading.cfg")
public class Config {
    public static void init() {
        if (ConfigBalance.dieselFuels.size() == 0) {
            ConfigBalance.dieselFuels.put("oil", 100);
            ConfigBalance.dieselFuels.put("oil_heavy", 70);
            ConfigBalance.dieselFuels.put("oil_dense", 110);
            ConfigBalance.dieselFuels.put("oil_distilled", 50);
            ConfigBalance.dieselFuels.put("fuel_dense", 110);
            ConfigBalance.dieselFuels.put("fuel_mixed_heavy", 130);
            ConfigBalance.dieselFuels.put("fuel_light", 150);
            ConfigBalance.dieselFuels.put("fuel_mixed_light", 100);
            ConfigBalance.dieselFuels.put("diesel", 200);
            ConfigBalance.dieselFuels.put("biodiesel", 170);
            ConfigBalance.dieselFuels.put("biofuel", 170);
            ConfigBalance.dieselFuels.put("ethanol", 170);
            ConfigBalance.dieselFuels.put("gasoline", 100);
            ConfigBalance.dieselFuels.put("refined_fuel", 150);
            ConfigBalance.dieselFuels.put("refined_oil", 100);
            ConfigBalance.dieselFuels.put("lpg", 150);
            ConfigBalance.dieselFuels.put("kerosene", 180);
            ConfigBalance.dieselFuels.put("fuel", 180);
            ConfigBalance.dieselFuels.put("olive_oil", 40);
        }
    }

    public static boolean isFuelRequired(Gauge gauge) {
        return ConfigBalance.FuelRequired && (ConfigBalance.ModelFuelRequired || !gauge.isModel());
    }

    @ConfigFile.Name(value="debug")
    public static class ConfigDebug {
        @ConfigFile.Comment(value="Range between couplers to try coupling")
        @ConfigFile.Range(min=0.0, max=1.0)
        public static double couplerRange = 0.3;
        @ConfigFile.Comment(value="Deep Snow on tracks")
        public static boolean deepSnow = false;
        @ConfigFile.Comment(value="How fast snow should accumulate, 0 = disabled, 20 = fast, 400 = slow")
        @ConfigFile.Range(min=0.0, max=1000.0)
        public static int snowAccumulateRate = 400;
        @ConfigFile.Comment(value="How fast snow should melt, 0 = disabled, 20 = fast, 400 = slow")
        @ConfigFile.Range(min=0.0, max=1000.0)
        public static int snowMeltRate = 0;
        @ConfigFile.Comment(value="Keep rolling stock loaded even when it is not moving")
        public static boolean keepStockLoaded = true;
        @ConfigFile.Comment(value="Print extra chunk loading info")
        public static boolean debugLog = false;
        @ConfigFile.Comment(value="Announce the new livery in Chat when the paint brush is used")
        public static boolean debugPaintBrush = false;
        @ConfigFile.Comment(value="DEBUG: Buckets infinite fill/empty tanks")
        public static boolean debugInfiniteLiquids = false;
        @ConfigFile.Comment(value="Time between open computers poll ticks for augments")
        @ConfigFile.Range(min=0.0, max=10.0)
        public static int ocPollDelayTicks = 1;
        @ConfigFile.Comment(value="DEV ONLY: How much to artifically lag the server (per internal)")
        @ConfigFile.Range(min=0.0, max=100.0)
        public static int lagServer = 0;
        @ConfigFile.Comment(value="Old Narrow track placement (single width instead of 3)")
        public static boolean oldNarrowWidth = false;
        @ConfigFile.Comment(value="Default Augments to Computer Mode")
        public static boolean defaultAugmentComputer = false;
        @ConfigFile.Comment(value="Warn if a physics tick takes more than the given time in ms")
        @ConfigFile.Range(min=1.0, max=100.0)
        public static int physicsWarnThresholdMs = 20;
        @ConfigFile.Comment(value="Warn if a physics total iteration takes more than the given time in ms")
        @ConfigFile.Range(min=1.0, max=100.0)
        public static int physicsWarnTotalThresholdMs = 40;
        @ConfigFile.Comment(value="Number of physics steps to cache for future movement / send in packets.  DO NOT CHANGE UNLESS YOU KNOW WHAT YOU ARE DOING")
        @ConfigFile.Range(min=10.0, max=60.0)
        public static int physicsFutureTicks = 10;
    }

    @ConfigFile.Name(value="performance")
    public static class ConfigPerformance {
        @ConfigFile.Comment(value="Use multiple threads when loading stock. This is used on Minecraft's initial load or when manually reloading stocks.")
        public static boolean multithreadedStockLoading = true;
        @ConfigFile.Comment(value="How many MB of memory to reserve for stock loading per thread, higher numbers = safer but slower")
        public static int megabytesReservedPerStockLoadingThread = 1024;
    }

    @ConfigFile.Name(value="balance")
    public static class ConfigBalance {
        @ConfigFile.Comment(value="Models require fuel")
        public static boolean ModelFuelRequired = true;
        @ConfigFile.Comment(value="All gauges require fuel")
        public static boolean FuelRequired = true;
        @ConfigFile.Comment(value="Slope Multiplier: Higher numbers increase slowdown, lower numbers decrease slowdown")
        @ConfigFile.Range(min=0.0, max=2.0)
        public static double slopeMultiplier = 1.0;
        @ConfigFile.Comment(value="Brake Multiplier: Higher numbers increase slowdown, lower numbers decrease slowdown")
        @ConfigFile.Range(min=0.0, max=10.0)
        public static double brakeMultiplier = 1.0;
        @ConfigFile.Comment(value="Traction Multiplier: Higher numbers decreases wheel slip, lower numders increase wheel slip")
        @ConfigFile.Range(min=0.0, max=10.0)
        public static double tractionMultiplier = 1.0;
        @ConfigFile.Comment(value="How heavy is a single block in Kg")
        @ConfigFile.Range(min=0.0, max=100.0)
        public static int blockWeight = 10;
        @ConfigFile.Comment(value="MilliBuckets per Liter")
        public static int MB_PER_LITER = 1;
        @ConfigFile.Comment(value="Cost to place down a tie")
        @ConfigFile.Range(min=0.0, max=10.0)
        public static double TieCostMultiplier = 0.25;
        @ConfigFile.Comment(value="Cost to place down a rail")
        @ConfigFile.Range(min=0.0, max=10.0)
        public static double RailCostMultiplier = 0.25;
        @ConfigFile.Comment(value="Cost to place down rail bed")
        @ConfigFile.Range(min=0.0, max=10.0)
        public static double BedCostMultiplier = 0.25;
        @ConfigFile.Comment(value="If more than X% of the tracks are above non solid block, break the track")
        @ConfigFile.Range(min=0.0, max=1.0)
        public static double trackFloatingPercent = 0.05;
        @ConfigFile.Comment(value="Diesel Fuel Efficiency")
        @ConfigFile.Range(min=1.0, max=500.0)
        public static int locoDieselFuelEfficiency = 100;
        @ConfigFile.Comment(value="Steam Fuel Efficiency")
        @ConfigFile.Range(min=1.0, max=500.0)
        public static int locoSteamFuelEfficiency = 100;
        @ConfigFile.Comment(value="How fast the steam locomotive should heat up.  1 is real internal (slow), 72 is scaled to minecraft time")
        @ConfigFile.Range(min=0.0, max=500.0)
        public static int locoHeatTimeScale = 72;
        @ConfigFile.Comment(value="How fast the diesel locomotive should heat up. 1 is real internal (slow), 72 is scaled to minecraft time")
        @ConfigFile.Range(min=0.0, max=500.0)
        public static int dieselLocoHeatTimeScale = 72;
        @ConfigFile.Comment(value="How much water the locomotive should use")
        @ConfigFile.Range(min=0.0, max=100.0)
        public static float locoWaterUsage = 10.0f;
        @ConfigFile.Comment(value="How much you getContents payed per meter the villager traveled (default 1 emerald per km)")
        public static double villagerPayoutPerMeter = 0.001;
        @ConfigFile.Comment(value="Distance the villagers will hear the conductor's whistle")
        @ConfigFile.Range(min=0.0, max=200.0)
        public static double villagerConductorDistance = 50.0;
        @ConfigFile.Comment(value="Villager payout items (ore dict)")
        public static Fuzzy[] villagerPayoutItems = new Fuzzy[]{Fuzzy.EMERALD};
        @ConfigFile.Comment(value="Fuels for diesel Locomotives\nNote: Naphtha of Thermal Foundation is internally registered as 'refined oil'.")
        public static Map<String, Integer> dieselFuels = new HashMap<String, Integer>();
        @ConfigFile.Comment(value="Water Substitutes")
        public static String[] waterTypes = new String[]{"water", "dist_water", "hot_spring_water", "purified_water"};
        @ConfigFile.Comment(value="Allow diesel locomotive engine overheating")
        public static boolean canDieselEnginesOverheat = true;
        @ConfigFile.Comment(value="Only select Locomotives with suitable equipment can be radio-controlled")
        public static boolean RadioEquipmentRequired = true;
        @ConfigFile.Comment(value="Range of radio-control, positive integer")
        @ConfigFile.Range(min=0.0, max=1000.0)
        public static int RadioRange = 500;
        @ConfigFile.Comment(value="IEnergy cost (RF) per radio transmission per metre")
        @ConfigFile.Range(min=0.0, max=1000.0)
        public static int RadioCostPerMetre = 0;
        @ConfigFile.Comment(value="Prevent stock from being built outside the recommended and model gauges")
        public static boolean DesignGaugeLock = false;
        @ConfigFile.Comment(value="Angle Placement Segmentation")
        @ConfigFile.Range(min=1.0, max=90.0)
        public static int AnglePlacementSegmentation = 4;
        @ConfigFile.Comment(value="Machine power factor (0 means no power required)")
        @ConfigFile.Range(min=0.0, max=10.0)
        public static float machinePowerFactor = 1.0f;
        @ConfigFile.Comment(value="Angles per tick to rotate turntables (used server side)")
        @ConfigFile.Range(min=0.0, max=5.0)
        public static double TurnTableSpeed = 0.4;
        @ConfigFile.Comment(value="Diesel locomotive capacity multiplier, set to 10 for old functionality")
        @ConfigFile.Range(min=1.0, max=10.0)
        public static int DieselLocomotiveTankMultiplier = 1;
        @ConfigFile.Comment(value="Round to nearest bucket")
        public static boolean RoundStockTankToNearestBucket = true;

        public static List<ItemStack> getVillagerPayout() {
            return Arrays.stream(villagerPayoutItems).map(f -> f.example()).collect(Collectors.toList());
        }
    }

    @ConfigFile.Name(value="Immersion Level")
    public static class ImmersionConfig {
        @ConfigFile.Comment(value="Old style throttle/reverser control which uses the throttle as the reverser")
        @ConfigFile.Name(value="Disable Independent Throttle")
        public static boolean disableIndependentThrottle = true;
        @ConfigFile.Comment(value="Old style brake control")
        @ConfigFile.Name(value="Instant Brake Pressure")
        public static boolean instantBrakePressure = false;
        @ConfigFile.Comment(value="Enable coupler slack")
        public static boolean slackEnabled = true;
    }

    @ConfigFile.Name(value="damage")
    public static class ConfigDamage {
        @ConfigFile.Comment(value="Enable Boiler Explosions")
        public static boolean explosionsEnabled = true;
        @ConfigFile.Comment(value="Enable environmental damage of Boiler Explosions")
        public static boolean explosionEnvDamageEnabled = true;
        @ConfigFile.Comment(value="km/h to damage 1 heart on collision")
        @ConfigFile.Range(min=1.0, max=100.0)
        public static double entitySpeedDamage = 10.0;
        @ConfigFile.Comment(value="Trains should break block")
        public static boolean TrainsBreakBlocks = true;
        @ConfigFile.Comment(value="How hard are blocks to break by rolling stock?")
        @ConfigFile.Range(min=0.0, max=500.0)
        public static int blockHardness = 50;
        @ConfigFile.Comment(value="Break block around the border of the tracks in creative")
        public static boolean enableSideBlockClearing = true;
        @ConfigFile.Comment(value="Clear blocsk in creative mode when placing tracks")
        public static boolean creativePlacementClearsBlocks = true;
        @ConfigFile.Comment(value="Requires solid block to be placed under the rails")
        public static boolean requireSolidBlocks = true;
        @ConfigFile.Comment(value="Drop snowballs when the train can't push a block out of the way")
        public static boolean dropSnowBalls = false;
        @ConfigFile.Comment(value="Trains getContents destroyed by Mob explosions")
        public static boolean trainMobExplosionDamage = true;
    }
}

