/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker;

import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import com.google.common.collect.ArrayListMultimap;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveengineering.Blueprint")
public class Blueprint {
    @ZenMethod
    public static void addRecipe(String category, IItemStack output, IIngredient[] inputs) {
        Object[] oInputs = new Object[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            oInputs[i] = CraftTweakerHelper.toObject(inputs[i]);
        }
        BlueprintCraftingRecipe r = new BlueprintCraftingRecipe(category, CraftTweakerHelper.toStack(output), oInputs);
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toStack(output)));
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new RemoveAll());
    }

    private static class RemoveAll
    implements IAction {
        ArrayListMultimap<String, BlueprintCraftingRecipe> removedRecipes;

        public void apply() {
            this.removedRecipes = ArrayListMultimap.create(BlueprintCraftingRecipe.recipeList);
            BlueprintCraftingRecipe.recipeList.clear();
        }

        public String describe() {
            return "Removing all Blueprint Recipes";
        }
    }

    private static class Remove
    implements IAction {
        private final ItemStack output;
        List<BlueprintCraftingRecipe> removedRecipes;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            this.removedRecipes = new ArrayList<BlueprintCraftingRecipe>();
            Iterator<String> itCat = BlueprintCraftingRecipe.blueprintCategories.iterator();
            while (itCat.hasNext()) {
                String category = itCat.next();
                Iterator it = BlueprintCraftingRecipe.recipeList.get((Object)category).iterator();
                while (it.hasNext()) {
                    BlueprintCraftingRecipe ir = (BlueprintCraftingRecipe)it.next();
                    if (!OreDictionary.itemMatches((ItemStack)ir.output, (ItemStack)this.output, (boolean)true) || !ItemStack.func_77970_a((ItemStack)ir.output, (ItemStack)this.output)) continue;
                    this.removedRecipes.add(ir);
                    it.remove();
                }
                if (!BlueprintCraftingRecipe.recipeList.get((Object)category).isEmpty()) continue;
                itCat.remove();
            }
        }

        public String describe() {
            return "Removing Blueprint Recipe for " + this.output.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final BlueprintCraftingRecipe recipe;

        public Add(BlueprintCraftingRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            if (!BlueprintCraftingRecipe.blueprintCategories.contains(this.recipe.blueprintCategory)) {
                BlueprintCraftingRecipe.blueprintCategories.add(this.recipe.blueprintCategory);
            }
            BlueprintCraftingRecipe.recipeList.put((Object)this.recipe.blueprintCategory, (Object)this.recipe);
        }

        public String describe() {
            return "Adding Blueprint Recipe for " + this.recipe.output.func_82833_r();
        }
    }
}

