/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.crafttweaker;

import blusunrize.immersiveengineering.api.crafting.AlloyRecipe;
import blusunrize.immersiveengineering.common.util.compat.crafttweaker.CraftTweakerHelper;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.immersiveengineering.AlloySmelter")
public class AlloySmelter {
    @ZenMethod
    public static void addRecipe(IItemStack output, IIngredient first, IIngredient second, int time) {
        Object oFirst = CraftTweakerHelper.toObject(first);
        Object oSecond = CraftTweakerHelper.toObject(second);
        if (oFirst == null || oSecond == null) {
            return;
        }
        AlloyRecipe r = new AlloyRecipe(CraftTweakerHelper.toStack(output), oFirst, oSecond, time);
        CraftTweakerAPI.apply((IAction)new Add(r));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new Remove(CraftTweakerHelper.toStack(output)));
    }

    @ZenMethod
    public static void removeAll() {
        CraftTweakerAPI.apply((IAction)new RemoveAll());
    }

    private static class RemoveAll
    implements IAction {
        List<AlloyRecipe> removedRecipes;

        public void apply() {
            this.removedRecipes = new ArrayList<AlloyRecipe>(AlloyRecipe.recipeList);
            AlloyRecipe.recipeList.clear();
        }

        public String describe() {
            return "Removing all Alloy Smelter Recipes";
        }
    }

    private static class Remove
    implements IAction {
        private final ItemStack output;
        List<AlloyRecipe> removedRecipes;

        public Remove(ItemStack output) {
            this.output = output;
        }

        public void apply() {
            this.removedRecipes = AlloyRecipe.removeRecipes(this.output);
        }

        public String describe() {
            return "Removing Alloy Smelter Recipe for " + this.output.func_82833_r();
        }
    }

    private static class Add
    implements IAction {
        private final AlloyRecipe recipe;

        public Add(AlloyRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            AlloyRecipe.recipeList.add(this.recipe);
        }

        public String describe() {
            return "Adding Alloy Smelter Recipe for " + this.recipe.output.func_82833_r();
        }
    }
}

