/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.commands;

import blusunrize.immersiveengineering.api.tool.ExcavatorHandler;
import blusunrize.immersiveengineering.common.IESaveData;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.server.command.CommandTreeBase;
import net.minecraftforge.server.command.CommandTreeHelp;

public class CommandMineral
extends CommandTreeBase {
    public CommandMineral() {
        this.addSubcommand((ICommand)new CommandMineralList());
        this.addSubcommand((ICommand)new CommandMineralGet());
        this.addSubcommand((ICommand)new CommandMineralSet());
        this.addSubcommand((ICommand)new CommandMineralSetDepletion());
        this.addSubcommand((ICommand)new CommandTreeHelp((CommandTreeBase)this));
    }

    @Nonnull
    public String func_71517_b() {
        return "mineral";
    }

    @Nonnull
    public String func_71518_a(@Nonnull ICommandSender sender) {
        return "Use \"/ie mineral help\" for more information";
    }

    @Nonnull
    public List<String> func_184883_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, String[] args, BlockPos pos) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length > 1) {
            switch (args[0]) {
                case "set": {
                    if (args.length > 2) break;
                    for (ExcavatorHandler.MineralMix mineralMix : ExcavatorHandler.mineralList.keySet()) {
                        if (!args[1].isEmpty() && !mineralMix.name.toLowerCase(Locale.ENGLISH).startsWith(args[1].toLowerCase(Locale.ENGLISH))) continue;
                        list.add(mineralMix.name);
                    }
                    break;
                }
            }
            return list;
        }
        return super.func_184883_a(server, sender, args, pos);
    }

    public int func_82362_a() {
        return 4;
    }

    private class CommandMineralSetDepletion
    extends CommandBase {
        private CommandMineralSetDepletion() {
        }

        @Nonnull
        public String func_71517_b() {
            return "setDepletion";
        }

        @Nonnull
        public String func_71518_a(@Nonnull ICommandSender sender) {
            return "/mineral setDepletion <depletion>";
        }

        public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
            int depl;
            ExcavatorHandler.MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(sender.func_130014_f_(), sender.func_180425_c().func_177958_n() >> 4, sender.func_180425_c().func_177952_p() >> 4);
            if (args.length != 1) {
                throw new CommandException("Need exactly one parameter", new Object[0]);
            }
            info.depletion = depl = CommandMineralSetDepletion.func_175755_a((String)args[0].trim());
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.command." + CommandMineral.this.func_71517_b() + ".setDepletion.sucess", new Object[]{depl < 0 ? I18n.func_74838_a((String)"chat.immersiveengineering.info.coreDrill.infinite") : Integer.toString(depl)}));
            IESaveData.setDirty(sender.func_130014_f_().field_73011_w.getDimension());
        }
    }

    private class CommandMineralSet
    extends CommandBase {
        private CommandMineralSet() {
        }

        @Nonnull
        public String func_71517_b() {
            return "set";
        }

        @Nonnull
        public String func_71518_a(@Nonnull ICommandSender sender) {
            return "/mineral set <mineral name> (surround the name in <angle brackets> if it contains a space)";
        }

        public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) throws CommandException {
            ExcavatorHandler.MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(sender.func_130014_f_(), sender.func_180425_c().func_177958_n() >> 4, sender.func_180425_c().func_177952_p() >> 4);
            if (args.length < 1) {
                throw new CommandException("Need exactly one parameter", new Object[0]);
            }
            StringBuilder name = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                name.append(args[i]);
                if (i >= args.length - 1) continue;
                name.append(" ");
            }
            ExcavatorHandler.MineralMix mineral = null;
            for (ExcavatorHandler.MineralMix mm : ExcavatorHandler.mineralList.keySet()) {
                if (!mm.name.equalsIgnoreCase(name.toString())) continue;
                mineral = mm;
            }
            if (mineral == null) {
                throw new CommandException("chat.immersiveengineering.command." + CommandMineral.this.func_71517_b() + ".set.invalidMineral", new Object[]{name.toString()});
            }
            info.mineralOverride = mineral;
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.command." + CommandMineral.this.func_71517_b() + ".set.sucess", new Object[]{mineral.name}));
            IESaveData.setDirty(sender.func_130014_f_().field_73011_w.getDimension());
        }
    }

    private class CommandMineralGet
    extends CommandBase {
        private CommandMineralGet() {
        }

        @Nonnull
        public String func_71517_b() {
            return "get";
        }

        @Nonnull
        public String func_71518_a(@Nonnull ICommandSender sender) {
            return "/mineral get";
        }

        public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) {
            ExcavatorHandler.MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(sender.func_130014_f_(), sender.func_180425_c().func_177958_n() >> 4, sender.func_180425_c().func_177952_p() >> 4);
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("chat.immersiveengineering.command." + CommandMineral.this.func_71517_b() + ".get", new Object[]{TextFormatting.GOLD + (info.mineral != null ? info.mineral.name : "null") + TextFormatting.RESET, TextFormatting.GOLD + (info.mineralOverride != null ? info.mineralOverride.name : "null") + TextFormatting.RESET, TextFormatting.GOLD + "" + info.depletion + TextFormatting.RESET}));
        }
    }

    private class CommandMineralList
    extends CommandBase {
        private CommandMineralList() {
        }

        @Nonnull
        public String func_71517_b() {
            return "list";
        }

        @Nonnull
        public String func_71518_a(@Nonnull ICommandSender sender) {
            return "/mineral list";
        }

        public void func_184881_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender sender, @Nonnull String[] args) {
            StringBuilder s = new StringBuilder();
            int i = 0;
            for (ExcavatorHandler.MineralMix mm : ExcavatorHandler.mineralList.keySet()) {
                s.append(i++ > 0 ? ", " : "").append(mm.name);
            }
            sender.func_145747_a((ITextComponent)new TextComponentString(s.toString()));
        }
    }
}

