/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.energy.wires.WireType;
import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.common.entities.EntityRailgunShot;
import blusunrize.immersiveengineering.common.entities.EntityRevolvershot;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class IEDamageSources {
    public static DamageSource acid = new IEDamageSource(Lib.DMG_Acid);
    public static DamageSource crusher = new IEDamageSource(Lib.DMG_Crusher);
    public static DamageSource razorWire = new IEDamageSource(Lib.DMG_RazorWire);
    public static DamageSource razorShock = new IEDamageSource(Lib.DMG_RazorShock);
    public static DamageSource wireShock = new ElectricDamageSource(Lib.DMG_WireShock, WireType.COPPER.getElectricSource(), 1.0f);
    private static final IElectricEquipment.ElectricSource TC_LOW = new IElectricEquipment.ElectricSource(0.25f);
    private static final IElectricEquipment.ElectricSource TC_HIGH = new IElectricEquipment.ElectricSource(2.0f);

    public static DamageSource causeCasullDamage(EntityRevolvershot shot, Entity shooter) {
        if (shooter == null) {
            return new TurretDamageSource(Lib.DMG_RevolverCasull);
        }
        return new IEDamageSource_Indirect(Lib.DMG_RevolverCasull, shot, shooter);
    }

    public static DamageSource causePiercingDamage(EntityRevolvershot shot, Entity shooter) {
        if (shooter == null) {
            return new TurretDamageSource(Lib.DMG_RevolverAP).func_76348_h();
        }
        return new IEDamageSource_Indirect(Lib.DMG_RevolverAP, shot, shooter).func_76348_h();
    }

    public static DamageSource causeBuckshotDamage(EntityRevolvershot shot, Entity shooter) {
        if (shooter == null) {
            return new TurretDamageSource(Lib.DMG_RevolverBuck);
        }
        return new IEDamageSource_Indirect(Lib.DMG_RevolverBuck, shot, shooter);
    }

    public static DamageSource causeDragonsbreathDamage(EntityRevolvershot shot, Entity shooter) {
        if (shooter == null) {
            return new TurretDamageSource(Lib.DMG_RevolverDragon).func_76361_j();
        }
        return new IEDamageSource_Indirect(Lib.DMG_RevolverDragon, shot, shooter).func_76361_j();
    }

    public static DamageSource causeHomingDamage(EntityRevolvershot shot, Entity shooter) {
        if (shooter == null) {
            return new TurretDamageSource(Lib.DMG_RevolverHoming);
        }
        return new IEDamageSource_Indirect(Lib.DMG_RevolverHoming, shot, shooter);
    }

    public static DamageSource causeWolfpackDamage(EntityRevolvershot shot, Entity shooter) {
        if (shooter == null) {
            return new TurretDamageSource(Lib.DMG_RevolverWolfpack);
        }
        return new IEDamageSource_Indirect(Lib.DMG_RevolverWolfpack, shot, shooter);
    }

    public static DamageSource causeSilverDamage(EntityRevolvershot shot, Entity shooter) {
        if (shooter == null) {
            return new TurretDamageSource(Lib.DMG_RevolverSilver);
        }
        return new IEDamageSource_Indirect(Lib.DMG_RevolverSilver, shot, shooter);
    }

    public static DamageSource causePotionDamage(EntityRevolvershot shot, Entity shooter) {
        if (shooter == null) {
            return new TurretDamageSource(Lib.DMG_RevolverPotion);
        }
        return new IEDamageSource_Indirect(Lib.DMG_RevolverPotion, shot, shooter);
    }

    public static ElectricDamageSource causeTeslaDamage(float amount, boolean lowPower) {
        return new ElectricDamageSource(Lib.DMG_Tesla, lowPower ? TC_LOW : TC_HIGH, amount);
    }

    public static ElectricDamageSource causeWireDamage(float amount, IElectricEquipment.ElectricSource source) {
        return new ElectricDamageSource(Lib.DMG_WireShock, source, amount);
    }

    public static DamageSource causeRailgunDamage(EntityRailgunShot shot, Entity shooter) {
        return new IEDamageSource_Indirect(Lib.DMG_Railgun, (Entity)shot, shooter).func_76348_h();
    }

    public static DamageSource causeTeslaPrimaryDamage() {
        return new IEDamageSource(Lib.DMG_Tesla_prim).func_76348_h();
    }

    public static class TurretDamageSource
    extends IEDamageSource {
        public TurretDamageSource(String damageTypeIn) {
            super(damageTypeIn);
        }

        public ITextComponent func_151519_b(EntityLivingBase entityLivingBaseIn) {
            String s = "death.attack." + this.field_76373_n + ".turret";
            return new TextComponentTranslation(s, new Object[]{entityLivingBaseIn.func_145748_c_()});
        }
    }

    public static class ElectricDamageSource
    extends DamageSource {
        public IElectricEquipment.ElectricSource source;
        public float dmg;

        public ElectricDamageSource(String tag, IElectricEquipment.ElectricSource source, float amount) {
            super(tag);
            this.source = source;
            this.dmg = amount;
            this.func_76348_h();
        }

        public boolean apply(Entity e) {
            if (e instanceof EntityLivingBase) {
                IElectricEquipment.applyToEntity((EntityLivingBase)e, this, this.source);
            }
            if (this.dmg > 0.0f) {
                e.func_70097_a((DamageSource)this, this.dmg);
            }
            return this.dmg > 0.0f;
        }
    }

    public static class IEDamageSource
    extends DamageSource {
        public IEDamageSource(String tag) {
            super(tag);
        }
    }

    public static class IEDamageSource_Direct
    extends EntityDamageSource {
        public IEDamageSource_Direct(String tag, Entity attacker) {
            super(tag, attacker);
        }
    }

    public static class IEDamageSource_Indirect
    extends EntityDamageSourceIndirect {
        public IEDamageSource_Indirect(String tag, Entity shot, Entity shooter) {
            super(tag, shot, shooter);
        }
    }
}

