/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.common.util.FakePlayerUtil;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fluids.FluidUtil;

public class AssemblerHandler {
    private static final HashMap<Class<? extends IRecipe>, IRecipeAdapter> registry = new LinkedHashMap<Class<? extends IRecipe>, IRecipeAdapter>();
    private static final List<Function<Object, RecipeQuery>> specialQueryConverters = new ArrayList<Function<Object, RecipeQuery>>();
    public static final IRecipeAdapter<IRecipe> defaultAdapter = new IRecipeAdapter<IRecipe>(){

        @Override
        public RecipeQuery[] getQueriedInputs(IRecipe recipe, NonNullList<ItemStack> input) {
            boolean matches;
            NonNullList ingred = recipe.func_192400_c();
            InventoryCrafting verificationInv = Utils.InventoryCraftingFalse.createFilledCraftingInventory(3, 3, input);
            ForgeHooks.setCraftingPlayer((EntityPlayer)FakePlayerUtil.getAnyFakePlayer());
            if (recipe instanceof IShapedRecipe) {
                IShapedRecipe shapedInput = (IShapedRecipe)recipe;
                ShapedRecipes verify = new ShapedRecipes("temp", shapedInput.getRecipeWidth(), shapedInput.getRecipeHeight(), ingred, new ItemStack(Items.field_151016_H));
                matches = verify.func_77569_a(verificationInv, null);
            } else {
                ShapelessRecipes verify = new ShapelessRecipes("temp", new ItemStack(Blocks.field_150346_d), ingred);
                matches = verify.func_77569_a(verificationInv, null);
            }
            ForgeHooks.setCraftingPlayer(null);
            if (!matches) {
                return null;
            }
            RecipeQuery[] query = new RecipeQuery[ingred.size()];
            for (int i = 0; i < query.length; ++i) {
                query[i] = AssemblerHandler.createQuery(ingred.get(i));
            }
            return query;
        }
    };

    public static void registerRecipeAdapter(Class<? extends IRecipe> recipeClass, IRecipeAdapter adapter) {
        registry.put(recipeClass, adapter);
    }

    @Nonnull
    public static IRecipeAdapter findAdapterForClass(Class<? extends IRecipe> recipeClass) {
        IRecipeAdapter adapter = registry.get(recipeClass);
        boolean isSuperIRecipe = IRecipe.class.isAssignableFrom(recipeClass.getSuperclass());
        if (adapter == null) {
            adapter = recipeClass != IRecipe.class && isSuperIRecipe ? AssemblerHandler.findAdapterForClass(recipeClass.getSuperclass()) : defaultAdapter;
            registry.put(recipeClass, adapter);
        }
        return adapter;
    }

    @Nonnull
    public static IRecipeAdapter findAdapter(IRecipe recipe) {
        return AssemblerHandler.findAdapterForClass(recipe.getClass());
    }

    public static void registerSpecialQueryConverters(Function<Object, RecipeQuery> func) {
        specialQueryConverters.add(func);
    }

    public static RecipeQuery createQuery(Object o) {
        if (o == null) {
            return null;
        }
        for (Function<Object, RecipeQuery> func : specialQueryConverters) {
            RecipeQuery q = func.apply(o);
            if (q == null) continue;
            return q;
        }
        if (o instanceof ItemStack) {
            return AssemblerHandler.createQueryFromItemStack((ItemStack)o);
        }
        if (o instanceof Ingredient) {
            ItemStack[] stacks = ((Ingredient)o).func_193365_a();
            if (stacks.length <= 0) {
                return null;
            }
            if (stacks.length == 1) {
                return AssemblerHandler.createQueryFromItemStack(stacks[0]);
            }
            return new RecipeQuery(stacks, 1);
        }
        if (o instanceof IngredientStack) {
            return new RecipeQuery(o, ((IngredientStack)o).inputSize);
        }
        return new RecipeQuery(o, 1);
    }

    public static RecipeQuery createQueryFromItemStack(ItemStack stack) {
        if (FluidUtil.getFluidContained((ItemStack)stack) != null) {
            return new RecipeQuery(FluidUtil.getFluidContained((ItemStack)stack), stack.func_190916_E());
        }
        return new RecipeQuery(stack, stack.func_190916_E());
    }

    static {
        AssemblerHandler.registerRecipeAdapter(IRecipe.class, defaultAdapter);
    }

    public static class RecipeQuery {
        public Object query;
        public int querySize;

        public RecipeQuery(Object query, int querySize) {
            this.query = query;
            this.querySize = querySize;
        }
    }

    public static interface IRecipeAdapter<R extends IRecipe> {
        @Nullable
        default public RecipeQuery[] getQueriedInputs(R recipe) {
            return this.getQueriedInputs(recipe, (NonNullList<ItemStack>)NonNullList.func_191196_a());
        }

        @Nullable
        default public RecipeQuery[] getQueriedInputs(R recipe, NonNullList<ItemStack> input) {
            return this.getQueriedInputs(recipe);
        }
    }
}

